/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.tdms.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.util.Strings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.zhengzhou.tdms.bean.QueryTerminalBean;
import pams.function.zhengzhou.tdms.bean.TerminalInfo;
import pams.function.zhengzhou.tdms.dao.TerminalDistributionDao;
import pams.function.zhengzhou.tdms.entity.TerminalDistribution;

@Repository
public class TerminalDistributionDaoImpl
implements TerminalDistributionDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public TerminalInfo getTerminalInfoByImei(String imei) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildSqlField());
        sb.append(this.buildSqlFrom());
        sb.append(" and t.IMEI = ? ");
        List list = this.baseDao.getListBySQL(sb.toString(), new Object[]{imei}, TerminalInfo.class);
        return list == null || list.isEmpty() ? null : (TerminalInfo)list.get(0);
    }

    @Override
    public void distrib(String id, String distributorId) {
        String sql = "update T_TERMINAL_DISTRIBUTION set STATE = 1, DISTRIBUTOR_ID = ?, DISTRIBUTION_TIME = ? where id = ?";
        this.baseDao.updateBySql(sql, new Object[]{distributorId, new Date(), id});
    }

    @Override
    public List<TerminalInfo> list(QueryTerminalBean bean, Page page) {
        StringBuilder count = new StringBuilder("select count(*) ");
        StringBuilder feild = new StringBuilder();
        feild.append(this.buildSqlField());
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildSqlFrom());
        ArrayList<Object> param = new ArrayList<Object>();
        this.buildSqlCondition(sb, param, bean);
        if (Strings.isNotEmpty((String)bean.getDistributorId())) {
            sb.append(" order by t.DISTRIBUTION_TIME desc, t.id ");
        } else {
            sb.append(" order by t.CREATED_TIME desc, t.id ");
        }
        return this.baseDao.getListBySQL(count.append((CharSequence)sb).toString(), feild.append((CharSequence)sb).toString(), param.toArray(new Object[param.size()]), page, TerminalInfo.class);
    }

    @Override
    public TerminalInfo getTerminalInfoById(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildSqlField());
        sb.append(this.buildSqlFrom());
        sb.append(" and t.id = ? ");
        List list = this.baseDao.getListBySQL(sb.toString(), new Object[]{id}, TerminalInfo.class);
        return list == null || list.isEmpty() ? null : (TerminalInfo)list.get(0);
    }

    @Override
    public void save(TerminalDistribution terminalDistribution) {
        this.baseDao.create((Object)terminalDistribution);
    }

    @Override
    public void update(TerminalDistribution terminalDistribution) {
        this.baseDao.update((Object)terminalDistribution);
    }

    @Override
    public BigDecimal queryCount(QueryTerminalBean terminalBean) {
        StringBuilder sql = new StringBuilder("select count(*) ");
        sql.append(this.buildSqlFrom());
        ArrayList<Object> param = new ArrayList<Object>();
        this.buildSqlCondition(sql, param, terminalBean);
        return (BigDecimal)this.baseDao.getObjectBySQL(sql.toString(), param.toArray());
    }

    @Override
    public TerminalDistribution queryById(String id) {
        return (TerminalDistribution)this.baseDao.getObjectByHQL("from TerminalDistribution t where t.id = ? and t.state <> '3'", new Object[]{id});
    }

    @Override
    public void delete(String id) {
        this.baseDao.updateBySql("update T_TERMINAL_DISTRIBUTION set state = '3' where id = ?", new Object[]{id});
    }

    private String buildSqlFrom() {
        StringBuilder sb = new StringBuilder();
        sb.append(" from T_TERMINAL_DISTRIBUTION t LEFT JOIN t_person p2 ON t.distributor_id = p2.id, T_PERSON p1, T_DEPARTMENT d ").append(" where ").append(" t.PERSON_ID = p1.id ").append(" and d.ID = p1.DEP_ID ").append(" and t.state <> '3' ");
        return sb.toString();
    }

    private String buildSqlField() {
        StringBuilder feild = new StringBuilder("select  ").append(" t.ID as \"id\" ").append(" ,t.STATE as \"state\" ").append(" ,to_char(t.DISTRIBUTION_TIME, 'yyyy-MM-DD HH24:MI:SS') as \"distributionTimeShow\" ").append(" ,t.TERMINAL_MODEL as \"terminalModel\" ").append(" ,t.TERMINAL_BRAND as \"terminalBrand\" ").append(" ,t.IMEI as \"imei\" ").append(" ,p1.CODE as \"code\" ").append(" ,p1.NAME as \"personName\" ").append(" ,p1.id as \"personId\" ").append(" ,d.NAME as \"depName\" ").append(" ,p2.NAME as \"distributorName\" ").append(" ,p1.IDENTIFIER as \"idNo\" ").append(" ,to_char(t.CREATED_TIME, 'yyyy-MM-DD HH24:MI:SS') as \"createTimeShow\" ").append(" ,t.IMEI_WORK_SYS as \"imeiWorkSys\"").append(" ,t.BOXING_NUMBER as \"boxingNumber\"");
        return feild.toString();
    }

    private void buildSqlCondition(StringBuilder sb, List<Object> param, QueryTerminalBean bean) {
        if (Strings.isNotEmpty((String)bean.getDistributorId())) {
            sb.append(" and t.DISTRIBUTOR_ID = ? ");
            param.add(bean.getDistributorId());
        }
        if (Strings.isNotEmpty((String)bean.getImei())) {
            sb.append(" and t.IMEI like ? ");
            param.add("%" + bean.getImei() + "%");
        }
        if (Strings.isNotEmpty((String)bean.getCode())) {
            sb.append(" and p1.CODE = ? ");
            param.add(bean.getCode());
        }
        if (Strings.isNotEmpty((String)bean.getName())) {
            sb.append(" and p1.NAME like ? ");
            param.add("%" + bean.getName() + "%");
        }
        if (Strings.isNotEmpty((String)bean.getState())) {
            sb.append(" and t.STATE = ? ");
            param.add(bean.getState());
        }
        if (Strings.isNotEmpty((String)bean.getIdentifier())) {
            sb.append(" and p1.IDENTIFIER = ?");
            param.add(bean.getIdentifier());
        }
        if (Strings.isNotEmpty((String)bean.getDepId())) {
            if (Strings.isNotEmpty((String)bean.getIsContain()) && "1".equals(bean.getIsContain())) {
                sb.append(" and EXISTS (select * from T_DEPARTMENT d where d.ID = p1.DEP_ID start with d.ID = ? connect by prior d.ID = d.PARENT_ID )");
            } else {
                sb.append(" and p1.DEP_ID = ? ");
            }
            param.add(bean.getDepId());
        }
    }
}

