/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.tdms.service.impl;

import com.xdja.pams.bims.dao.MobileDao;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.CookieUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.TerminalService;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import pams.function.zhengzhou.tdms.bean.ImportTerminalBean;
import pams.function.zhengzhou.tdms.bean.QueryTerminalBean;
import pams.function.zhengzhou.tdms.bean.TerminalInfo;
import pams.function.zhengzhou.tdms.dao.TerminalDistributionDao;
import pams.function.zhengzhou.tdms.entity.TerminalDistribution;
import pams.function.zhengzhou.tdms.service.TerminalDistributionService;

@Service
public class TerminalDistributionServiceImpl
implements TerminalDistributionService {
    @Autowired
    private TerminalDistributionDao terminalDistributionDao;
    @Autowired
    private MobileDao mobileDao;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private TerminalService terminalService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private TokenFactory tokenFactory;
    private static final String[] LASTCHARFORIMEISYS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};

    @Override
    public TerminalInfo getterminalInfoById(String id) {
        TerminalInfo info = this.terminalDistributionDao.getTerminalInfoById(id);
        if (info == null) {
            return null;
        }
        List mobiles = this.mobileDao.queryMobileListBySql("select * from T_BIMS_MOBILE where PERSON_ID = ?", new String[]{info.getPersonId()});
        if (mobiles != null && mobiles.size() > 0) {
            info.setMobile(((Mobile)mobiles.get(0)).getMobile());
        }
        return info;
    }

    @Override
    public List<TerminalInfo> terminalInfo(String imei, String identifier, String code) {
        List<TerminalInfo> terminalInfoList = new ArrayList<TerminalInfo>();
        if (StringUtils.isNotBlank((CharSequence)imei)) {
            TerminalInfo info = this.terminalDistributionDao.getTerminalInfoByImei(imei);
            if (info != null) {
                terminalInfoList.add(info);
            }
        } else {
            QueryTerminalBean queryBean = new QueryTerminalBean();
            queryBean.setCode(code);
            queryBean.setIdentifier(identifier);
            terminalInfoList = this.terminalDistributionDao.list(queryBean, null);
        }
        for (TerminalInfo terminalInfo : terminalInfoList) {
            List mobiles = this.mobileDao.queryMobileListBySql("select * from T_BIMS_MOBILE where PERSON_ID = ?", new String[]{terminalInfo.getPersonId()});
            if (mobiles == null || mobiles.size() <= 0) continue;
            terminalInfo.setMobile(((Mobile)mobiles.get(0)).getMobile());
        }
        return terminalInfoList;
    }

    @Override
    public void distrib(String id, String distributorId) {
        this.terminalDistributionDao.distrib(id, distributorId);
    }

    @Override
    public Map<String, Object> list(QueryTerminalBean bean) {
        Page page = new Page();
        page.setPage(bean.getPage().intValue());
        page.setRp(bean.getRows().intValue());
        List<TerminalInfo> list = this.terminalDistributionDao.list(bean, page);
        for (TerminalInfo ti : list) {
            List mobiles = this.mobileDao.queryMobileListBySql("select * from T_BIMS_MOBILE where PERSON_ID = ?", new String[]{ti.getPersonId()});
            if (mobiles != null && mobiles.size() > 0) {
                ti.setMobile(((Mobile)mobiles.get(0)).getMobile());
            }
            if (Strings.isNotEmpty((String)ti.getTerminalBrand())) {
                ti.setTerminalBrandName(this.commonCodePbService.getCodeNameByCode(ti.getTerminalBrand(), "2021"));
            }
            if (!Strings.isNotEmpty((String)ti.getState())) continue;
            ti.setStateName(this.commonCodePbService.getCodeNameByCode(ti.getState(), "terminal_manage"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", page.getTotal());
        map.put("pageNo", page.getPage());
        map.put("rows", list);
        return map;
    }

    @Override
    public TerminalInfo queryById(String id) {
        TerminalInfo terminalInfo = this.terminalDistributionDao.getTerminalInfoById(id);
        if (terminalInfo != null) {
            List mobiles;
            if (StringUtils.isNotBlank((CharSequence)terminalInfo.getState())) {
                terminalInfo.setStateName(this.commonCodePbService.getCodeNameByCode(terminalInfo.getState(), "terminal_manage"));
            }
            if ((mobiles = this.mobileDao.queryMobileListBySql("select * from T_BIMS_MOBILE where PERSON_ID = ?", new String[]{terminalInfo.getPersonId()})) != null && mobiles.size() > 0) {
                terminalInfo.setMobile(((Mobile)mobiles.get(0)).getMobile());
            }
        }
        return terminalInfo;
    }

    @Override
    @Transactional
    public void save(QueryTerminalBean terminalBean) {
        TerminalInfo terminalInfo = this.terminalDistributionDao.getTerminalInfoByImei(terminalBean.getImei());
        if (StringUtils.isBlank((CharSequence)terminalBean.getId())) {
            if (terminalInfo != null) {
                throw new RuntimeException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5IMEI\u5df2\u88ab\u7ed1\u5b9a\u6ce8\u518c");
            }
            TerminalDistribution terminalDistribution = new TerminalDistribution();
            BeanUtils.copyProperties((Object)terminalBean, (Object)terminalDistribution);
            terminalDistribution.setImeiWorkSys(this.transImeiToWorkSys(terminalDistribution.getImei()));
            terminalDistribution.setUpdatedTime(new Date());
            terminalDistribution.setUpdatedBy(terminalBean.getUpdatedBy());
            terminalDistribution.setCreatedTime(new Date());
            terminalDistribution.setCreatedBy(terminalBean.getCreatedBy());
            terminalDistribution.setState("2");
            this.terminalDistributionDao.save(terminalDistribution);
            this.saveDevice(terminalDistribution);
        } else {
            if (terminalInfo != null && !terminalInfo.getPersonId().equals(terminalBean.getPersonId())) {
                throw new RuntimeException("\u4fee\u6539\u5931\u8d25\uff0c\u8be5IMEI\u5df2\u7ecf\u6ce8\u518c\u7ed9\u5176\u4ed6\u8b66\u5458");
            }
            TerminalDistribution queryTerminal = this.terminalDistributionDao.queryById(terminalBean.getId());
            if (queryTerminal != null) {
                if ("1".equals(queryTerminal.getState()) && !queryTerminal.getImei().equals(terminalBean.getImei())) {
                    throw new RuntimeException("\u4fee\u6539\u5931\u8d25\uff0c\u5df2\u53d1\u653e\u7684\u8bbe\u5907IMEI\u4e0d\u53ef\u4fee\u6539");
                }
                if (!queryTerminal.getImei().equals(terminalBean.getImei()) && terminalInfo != null) {
                    throw new RuntimeException("\u4fee\u6539\u5931\u8d25\uff0c\u8be5IMEI\u5df2\u5b58\u5728");
                }
                Device device = this.deviceService.getByIMEI(queryTerminal.getImeiWorkSys());
                queryTerminal.setImeiWorkSys(this.transImeiToWorkSys(terminalBean.getImei()));
                queryTerminal.setBoxingNumber(terminalBean.getBoxingNumber());
                if ("2".equals(queryTerminal.getState()) && "1".equals(terminalBean.getState())) {
                    queryTerminal.setState(terminalBean.getState());
                    queryTerminal.setDistributionTime(new Date());
                    queryTerminal.setDistributorId(terminalBean.getUpdatedBy());
                }
                queryTerminal.setUpdatedTime(new Date());
                queryTerminal.setUpdatedBy(terminalBean.getUpdatedBy());
                queryTerminal.setImei(terminalBean.getImei());
                queryTerminal.setTerminalBrand(terminalBean.getTerminalBrand());
                queryTerminal.setTerminalModel(terminalBean.getTerminalModel());
                this.terminalDistributionDao.update(queryTerminal);
                if (device != null) {
                    device.setImei(queryTerminal.getImeiWorkSys());
                    this.deviceService.update(device);
                } else {
                    this.saveDevice(queryTerminal);
                }
            } else {
                throw new RuntimeException("\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6761\u7ec8\u7aef\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
        }
    }

    @Override
    public Long queryCount(QueryTerminalBean terminalBean) {
        BigDecimal count = this.terminalDistributionDao.queryCount(terminalBean);
        return count.longValue();
    }

    @Override
    @Transactional
    public void importExcel(MultipartFile file, List<ImportTerminalBean> errorList, String personId, HttpServletRequest request, Map<String, Object> result) throws Exception {
        String ticket = (String)CookieUtils.getCookie((HttpServletRequest)request, (String)"operator", String.class);
        List<ImportTerminalBean> allList = this.parseExcel(file);
        result.put("totalCount", allList.size());
        this.checkSelf(allList, errorList, personId, result, request);
    }

    @Override
    @Transactional
    public void delete(String id) {
        TerminalDistribution terminalDistribution = this.terminalDistributionDao.queryById(id);
        if (terminalDistribution == null) {
            throw new RuntimeException("\u5220\u9664\u5931\u8d25\uff0cid\u4e0d\u5b58\u5728");
        }
        Device device = this.deviceService.getByIMEI(terminalDistribution.getImeiWorkSys());
        if (device != null) {
            device.setImei(null);
            device.setRevokeFlag("1");
            device.setRevocationDate(new Date());
            device.setState("11");
            this.deviceService.update(device);
        }
        this.terminalDistributionDao.delete(id);
    }

    private void checkSelf(List<ImportTerminalBean> allList, List<ImportTerminalBean> errorList, String personId, Map<String, Object> result, HttpServletRequest request) {
        HashMap<String, String> imeiMap = new HashMap<String, String>();
        double n = 0.0;
        int wellCount = 0;
        String ticket = (String)CookieUtils.getCookie((HttpServletRequest)request, (String)"operator", String.class);
        for (ImportTerminalBean terminalBean : allList) {
            boolean flag = this.checkParam(terminalBean, imeiMap, errorList);
            double d = n;
            n = d + 1.0;
            if (d % 100.0 == 0.0) {
                this.baseDao.flushSession();
            }
            if (flag) {
                try {
                    this.saveExcel(terminalBean, personId);
                    ++wellCount;
                }
                catch (Exception e) {
                    terminalBean.setErrorMsg(e.getMessage());
                    errorList.add(terminalBean);
                }
            }
            this.tokenFactory.getOperator().add("upload:terminal:rate:" + ticket, String.valueOf(n / (double)allList.size()));
        }
        result.put("errorList", errorList);
        result.put("wellCount", wellCount);
        result.put("errorCount", errorList.size());
    }

    private boolean checkParam(ImportTerminalBean terminalBean, Map<String, String> imeiMap, List<ImportTerminalBean> errorList) {
        String imei = terminalBean.getImei();
        if (StringUtils.isBlank((CharSequence)imei)) {
            terminalBean.setErrorMsg("IMEI\u4e3a\u7a7a");
            errorList.add(terminalBean);
            return false;
        }
        if (imeiMap.containsKey(imei)) {
            terminalBean.setErrorMsg("IMEI\u91cd\u590d");
            errorList.add(terminalBean);
            return false;
        }
        if (imei.length() != 15) {
            terminalBean.setErrorMsg("IMEI\u957f\u5ea6\u4e0d\u662f15");
            errorList.add(terminalBean);
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)imei)) {
            terminalBean.setErrorMsg("\u65e0\u6548\u7684IMEI\u53f7");
            errorList.add(terminalBean);
            return false;
        }
        TerminalInfo terminalInfo = this.terminalDistributionDao.getTerminalInfoByImei(terminalBean.getImei());
        if (terminalInfo != null) {
            terminalBean.setErrorMsg("IMEI\u5df2\u7ecf\u6ce8\u518c\u7ed9\u5176\u4ed6\u8b66\u5458");
            errorList.add(terminalBean);
            return false;
        }
        String identifier = terminalBean.getIdentifier();
        if (StringUtils.isBlank((CharSequence)identifier)) {
            terminalBean.setErrorMsg("\u8eab\u4efd\u8bc1\u53f7\u7801\u4e3a\u7a7a");
            errorList.add(terminalBean);
            return false;
        }
        if (identifier.length() != 18) {
            terminalBean.setErrorMsg("\u8eab\u4efd\u8bc1\u53f7\u7801\u957f\u5ea6\u4e0d\u662f18");
            errorList.add(terminalBean);
            return false;
        }
        Person person = this.userManageService.getUserByIdentifer(identifier);
        if (person == null) {
            terminalBean.setErrorMsg("\u8be5\u8eab\u4efd\u8bc1\u53f7\u5bf9\u5e94\u4eba\u5458\u4e0d\u5728pams");
            errorList.add(terminalBean);
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)terminalBean.getName()) && !person.getName().equals(terminalBean.getName())) {
            terminalBean.setErrorMsg("\u8be5\u4eba\u5458\u4fe1\u606f\u4e0epams\u4eba\u5458\u4fe1\u606f\u4e0d\u5339\u914d");
            errorList.add(terminalBean);
            return false;
        }
        String boxingNumber = terminalBean.getBoxingNumber();
        if (StringUtils.isNotBlank((CharSequence)boxingNumber) && !StringUtils.isNumeric((CharSequence)boxingNumber) || boxingNumber.length() > 6) {
            terminalBean.setErrorMsg("\u88c5\u7bb1\u53f7\u683c\u5f0f\u9519\u8bef");
            errorList.add(terminalBean);
            return false;
        }
        String state = terminalBean.getState();
        if (StringUtils.isBlank((CharSequence)state) || !"1".equals(state) && !"2".equals(state)) {
            terminalBean.setErrorMsg("\u8bbe\u5907\u53d1\u653e\u72b6\u6001\u5f02\u5e38");
            errorList.add(terminalBean);
            return false;
        }
        terminalBean.setPersonId(person.getId());
        imeiMap.put(imei, imei);
        return true;
    }

    private void saveExcel(ImportTerminalBean terminalBean, String personId) {
        TerminalDistribution terminalDistribution = new TerminalDistribution();
        BeanUtils.copyProperties((Object)terminalBean, (Object)terminalDistribution, (String[])new String[]{"identifier", "errorMsg", "name"});
        terminalDistribution.setImeiWorkSys(this.transImeiToWorkSys(terminalDistribution.getImei()));
        if ("1".equals(terminalBean.getState())) {
            terminalDistribution.setDistributionTime(new Date());
            terminalDistribution.setDistributorId(personId);
        }
        terminalDistribution.setUpdatedTime(new Date());
        terminalDistribution.setCreatedTime(new Date());
        terminalDistribution.setCreatedBy(personId);
        terminalDistribution.setUpdatedBy(personId);
        this.terminalDistributionDao.save(terminalDistribution);
        this.saveDevice(terminalDistribution);
    }

    private void saveDevice(TerminalDistribution terminalDistribution) {
        Person person = this.userManageService.getPersonByPersonId(terminalDistribution.getPersonId());
        if (person == null) {
            throw new RuntimeException("\u4eba\u5458id\u4e0d\u5b58\u5728");
        }
        Device device = this.deviceService.getByIMEI(terminalDistribution.getImeiWorkSys());
        if (device != null && !device.getPersonId().equals(terminalDistribution.getPersonId())) {
            throw new RuntimeException("\u8be5\u6761imei\u5728\u8bbe\u5907\u8868\u4e2d\u5df2\u5b58\u5728\uff0c\u4e14\u4e0d\u5c5e\u4e8e\u8be5\u4eba\u5458");
        }
        if (device == null) {
            device = new Device();
            device.setImei(terminalDistribution.getImeiWorkSys());
            device.setPersonId(person.getId());
            device.setBindingDate(new Date());
            device.setBindingState(null);
            device.setState("3");
            device.setFlag("1");
            device.setLockState("0");
            Terminal terminal = new Terminal();
            terminal.setTerminalname("\u9ed8\u8ba4\u7ec8\u7aef");
            terminal.setTerminalband(terminalDistribution.getTerminalBrand());
            terminal.setTerminalos("000");
            terminal.setTerminaltype("0");
            device.setTerminal(terminal);
            List mobiles = this.mobileDao.queryMobileListBySql("select * from T_BIMS_MOBILE where PERSON_ID = ?", new String[]{person.getId()});
            if (!CollectionUtils.isEmpty((Collection)mobiles)) {
                device.setMobile((Mobile)mobiles.get(0));
            }
            this.deviceService.save(device);
        }
    }

    private List<ImportTerminalBean> parseExcel(MultipartFile file) throws Exception {
        ArrayList<ImportTerminalBean> list = new ArrayList<ImportTerminalBean>();
        String[] colsName = new String[]{"IMEI\u53f7\u7801", "\u8eab\u4efd\u8bc1\u53f7\u7801", "\u59d3\u540d", "\u8bbe\u5907\u54c1\u724c", "\u8bbe\u5907\u578b\u53f7", "\u88c5\u7bb1\u53f7", "\u8bbe\u5907\u53d1\u653e\u72b6\u6001"};
        Sheet sheet = ExcelUtil.parseExcel((MultipartFile)file, (int)0);
        if (sheet != null) {
            int i;
            int colLens = sheet.getRow(0).getPhysicalNumberOfCells();
            if (colLens != colsName.length) {
                throw new Exception(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.parseExcel.colNotMatch"));
            }
            for (i = 0; i < colLens; ++i) {
                String colName = sheet.getRow(0).getCell(i).getStringCellValue();
                if (colsName[i].equals(colName)) continue;
                throw new Exception(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.parseExcel.badColName") + "[" + colName + ":" + colsName[i] + "]");
            }
            for (i = 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                Double number;
                ImportTerminalBean terminalBean = new ImportTerminalBean();
                Row row = sheet.getRow(i);
                if (row.getCell(0) != null) {
                    terminalBean.setImei(Util.lrTrim((String)row.getCell(0).getStringCellValue()));
                }
                if (row.getCell(1) != null) {
                    terminalBean.setIdentifier(Util.lrTrim((String)row.getCell(1).getStringCellValue()));
                }
                if (row.getCell(2) != null) {
                    terminalBean.setName(Util.lrTrim((String)row.getCell(2).getStringCellValue()));
                }
                if (row.getCell(3) != null) {
                    String code = Util.lrTrim((String)row.getCell(3).getStringCellValue());
                    CommonCode commonCode = this.commonCodePbService.getByCode(code, "2021");
                    if (commonCode == null) {
                        terminalBean.setTerminalBrand("001");
                    }
                    terminalBean.setTerminalBrand(code);
                } else {
                    terminalBean.setTerminalBrand("001");
                }
                if (row.getCell(4) != null) {
                    terminalBean.setTerminalModel(Util.lrTrim((String)row.getCell(4).getStringCellValue()));
                } else {
                    terminalBean.setTerminalModel("\u9ed8\u8ba4\u578b\u53f7");
                }
                if (row.getCell(5) != null && (number = Double.valueOf(row.getCell(5).getNumericCellValue())) != null) {
                    int number_ = number.intValue();
                    terminalBean.setBoxingNumber(number_ + "");
                }
                if (row.getCell(6) != null) {
                    String stateName = Util.lrTrim((String)row.getCell(6).getStringCellValue());
                    String state = "";
                    if ("\u5df2\u53d1\u653e".equals(stateName)) {
                        state = "1";
                    }
                    if ("\u672a\u53d1\u653e".equals(stateName)) {
                        state = "2";
                    }
                    terminalBean.setState(state);
                }
                list.add(terminalBean);
            }
        }
        return list;
    }

    private String transImeiToWorkSys(String imei) {
        if (Strings.isEmpty((String)imei)) {
            return imei;
        }
        int length = imei.length();
        StringBuilder prefix = new StringBuilder(imei.substring(0, length - 1));
        Character l = Character.valueOf(imei.charAt(length - 1));
        if (Character.isDigit(l.charValue())) {
            int i = Integer.valueOf(String.valueOf(l));
            return prefix.append(LASTCHARFORIMEISYS[i]).toString();
        }
        return "";
    }
}

