/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.trafficpolice.control;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Response;
import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.zhengzhou.common.control.BaseController;
import pams.function.zhengzhou.trafficpolice.entity.DepInfoEntity;
import pams.function.zhengzhou.trafficpolice.service.TrafficPoliceDepService;
import pams.function.zhengzhou.util.Tools;

@Controller
@Scope(value="session")
public class TrafficPoliceDepController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficPoliceDepController.class);
    @Autowired
    private TrafficPoliceDepService trafficPoliceDepService;

    @RequestMapping(value={"trafficPoliceDep/getDep.do"})
    public void getDep(HttpServletRequest request, String depCode, String page, String rows, HttpServletResponse response) {
        LOG.info("\u67e5\u8be2\u4ea4\u8b66\u5355\u4f4d");
        try {
            if (Util.varCheckEmp((String)page) || Util.varCheckEmp((String)page)) {
                Page page1 = new Page(1, Integer.MAX_VALUE);
                String depLevel = Tools.getDepLevel(depCode);
                List<DepInfoEntity> depInfoEntities = this.trafficPoliceDepService.findByJwtCode(depLevel, page1);
                this.resultJson(response, Util.toJsonStr(depInfoEntities));
            } else {
                Page page1 = new Page(page, rows);
                String depLevel = Tools.getDepLevel(depCode);
                List<DepInfoEntity> depInfoEntities = this.trafficPoliceDepService.findByJwtCode(depLevel, page1);
                this.result(response, Response.successData(depInfoEntities, (Page)page1));
            }
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u4ea4\u8b66\u5355\u4f4d\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"trafficPoliceDep/getDepTree.do"})
    public void getDepTree(HttpServletRequest request, String depCode, HttpServletResponse response) {
        LOG.info("\u67e5\u8be2\u4ea4\u8b66\u5355\u4f4d\u6811");
        try {
            String depLevel = Tools.getDepLevel(depCode);
            ArrayList<DepInfoEntity> list = new ArrayList<DepInfoEntity>();
            DepInfoEntity selectDepInfo = new DepInfoEntity();
            selectDepInfo.setCode("");
            selectDepInfo.setName("--\u8bf7\u9009\u62e9--");
            list.add(selectDepInfo);
            List<DepInfoEntity> depInfoEntities = this.trafficPoliceDepService.findByJwtCode(depLevel, null);
            list.addAll(depInfoEntities);
            this.resultJson(response, Util.toJsonStr(list));
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u4ea4\u8b66\u5355\u4f4d\u6811\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"trafficPoliceDep/addDep.do"})
    public void addDep(HttpServletRequest request, DepInfoEntity infoEntity, HttpServletResponse response) {
        LOG.info("\u6dfb\u52a0\u4ea4\u8b66\u5355\u4f4d");
        try {
            Response responseData = this.trafficPoliceDepService.addDep(infoEntity);
            this.result(response, responseData);
        }
        catch (Exception e) {
            LOG.error("\u6dfb\u52a0\u4ea4\u8b66\u5355\u4f4d\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"trafficPoliceDep/deleteDep.do"})
    public void deleteDep(HttpServletRequest request, DepInfoEntity infoEntity, HttpServletResponse response) {
        LOG.info("\u5220\u9664\u4ea4\u8b66\u5355\u4f4d");
        try {
            Response responseData = this.trafficPoliceDepService.deleteDep(infoEntity);
            this.result(response, responseData);
        }
        catch (Exception e) {
            LOG.error("\u5220\u9664\u4ea4\u8b66\u5355\u4f4d\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }
}

