/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.trafficpolice.dao.impl;

import com.xdja.pams.common.util.Page;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.zhengzhou.common.dao.impl.BaseEntityDaoImpl;
import pams.function.zhengzhou.trafficpolice.dao.TrafficPoliceDepDao;
import pams.function.zhengzhou.trafficpolice.entity.DepInfoEntity;

@Repository(value="trafficPoliceDepDao")
public class TrafficPoliceDepDaoImpl
extends BaseEntityDaoImpl<DepInfoEntity>
implements TrafficPoliceDepDao {
    @Autowired
    public TrafficPoliceDepDaoImpl(SessionFactory sessionFactory) {
        super(sessionFactory, DepInfoEntity.class);
    }

    @Override
    public List<DepInfoEntity> findByCodeOrName(String code, String name) {
        String hql = "from DepInfoEntity where code = :code or name = :name";
        Query query = this.getCurrentSession().createQuery(hql);
        query.setString("code", code).setString("name", name);
        return query.list();
    }

    @Override
    public List<DepInfoEntity> findByJwtCode(String jwtCode, Page page) {
        String selectCount;
        String select;
        ArrayList<String> paramList = new ArrayList<String>(1);
        if (StringUtils.isBlank((CharSequence)jwtCode)) {
            select = "from DepInfoEntity order by  code";
            selectCount = "select count(*) from DepInfoEntity";
        } else {
            select = "from DepInfoEntity where jwtCode like ?  order by code";
            selectCount = "select count(*) from DepInfoEntity where jwtCode like ?";
            paramList.add("%" + jwtCode + "%");
        }
        return this.getListByHQL(selectCount, select, paramList.toArray(), page);
    }
}

