/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.trafficpolice.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.zhengzhou.common.dao.BaseEntityDao;
import pams.function.zhengzhou.common.service.impl.BaseEntityServiceImpl;
import pams.function.zhengzhou.trafficpolice.dao.TrafficPliceDocTextDao;
import pams.function.zhengzhou.trafficpolice.dao.TrafficPoliceDepDao;
import pams.function.zhengzhou.trafficpolice.dao.TrafficPoliceDocDao;
import pams.function.zhengzhou.trafficpolice.entity.DepInfoEntity;
import pams.function.zhengzhou.trafficpolice.entity.DocEntity;
import pams.function.zhengzhou.trafficpolice.service.TrafficPoliceDepService;

@Service(value="trafficPoliceDepService")
public class TrafficPoliceDepServiceImpl
extends BaseEntityServiceImpl<DepInfoEntity>
implements TrafficPoliceDepService {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficPoliceDepServiceImpl.class);
    @Autowired
    private TrafficPoliceDepDao trafficPoliceDepDao;
    @Autowired
    private TrafficPoliceDocDao trafficPoliceDocDao;
    @Autowired
    private TrafficPliceDocTextDao trafficPliceDocTextDao;

    @Override
    public BaseEntityDao<DepInfoEntity> getEntityDao() {
        return this.trafficPoliceDepDao;
    }

    @Override
    public List<DepInfoEntity> findByCodeOrName(String code, String name) {
        return this.trafficPoliceDepDao.findByCodeOrName(code, name);
    }

    @Override
    public List<DepInfoEntity> findByJwtCode(String jwtCode, Page page) {
        return this.trafficPoliceDepDao.findByJwtCode(jwtCode, page);
    }

    @Override
    @Transactional
    public Response deleteDep(DepInfoEntity depInfoEntity) {
        DepInfoEntity entity = (DepInfoEntity)this.findById(depInfoEntity.getEntityPk());
        if (entity == null) {
            LOG.info("\u5355\u4f4d\u4e0d\u5b58\u5728");
            return Response.failMsg((String)"\u5355\u4f4d\u4e0d\u5b58\u5728");
        }
        DocEntity doc = new DocEntity();
        doc.setDwbm(entity.getCode());
        List<DocEntity> list = this.trafficPoliceDocDao.findDoc(doc, null);
        if (!list.isEmpty()) {
            return Response.failMsg((String)"\u5df2\u7ecf\u4e3a\u8be5\u5355\u4f4d\u521d\u59cb\u5316\u8fc7\u7f5a\u5355\u53f7\u6bb5\uff0c\u4e0d\u80fd\u5220\u9664\u8be5\u5355\u4f4d");
        }
        LOG.info("\u5220\u9664\u5355\u4f4d");
        this.delete(entity);
        LOG.info("\u6839\u636e\u5355\u4f4d\u7f16\u7801\u5220\u9664\u6587\u4e66\u5185\u5bb9");
        this.trafficPliceDocTextDao.deleteByDwbm(entity.getCode());
        return Response.successData(null);
    }

    @Override
    @Transactional
    public Response addDep(DepInfoEntity infoEntity) {
        List<DepInfoEntity> existedDeps = this.findByCodeOrName(infoEntity.getCode(), infoEntity.getName());
        if (!existedDeps.isEmpty()) {
            LOG.info("\u4ea4\u8b66\u5355\u4f4d\u5df2\u7ecf\u5b58\u5728");
            DepInfoEntity existedDep = existedDeps.get(0);
            if (existedDep.getCode().equals(infoEntity.getCode())) {
                LOG.info("\u4ea4\u8b66\u5355\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
                return Response.failMsg((String)"\u5355\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
            }
            if (existedDep.getName().equals(infoEntity.getName())) {
                LOG.info("\u4ea4\u8b66\u5355\u4f4d\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                return Response.failMsg((String)"\u5355\u4f4d\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
            return Response.failData(null);
        }
        this.save(infoEntity);
        return Response.successData(null);
    }
}

