/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.trafficpolice.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Response;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.zhengzhou.common.dao.BaseEntityDao;
import pams.function.zhengzhou.common.service.impl.BaseEntityServiceImpl;
import pams.function.zhengzhou.illegalinfo.dao.DocNumberDao;
import pams.function.zhengzhou.illegalinfo.entity.DocNumber;
import pams.function.zhengzhou.trafficpolice.dao.TrafficPoliceDocDao;
import pams.function.zhengzhou.trafficpolice.entity.DepInfoEntity;
import pams.function.zhengzhou.trafficpolice.entity.DocBackEntity;
import pams.function.zhengzhou.trafficpolice.entity.DocEntity;
import pams.function.zhengzhou.trafficpolice.entity.FdbhEntity;
import pams.function.zhengzhou.trafficpolice.service.TrafficPoliceDocService;
import pams.function.zhengzhou.util.DataWebserviceClient;
import xdja.hxd.wsrpc.client.wsrpcClient_new;

@Service(value="trafficPoliceDocService")
public class TrafficPoliceDocServiceImpl
extends BaseEntityServiceImpl<DocEntity>
implements TrafficPoliceDocService {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficPoliceDocServiceImpl.class);
    @Autowired
    private TrafficPoliceDocDao trafficPoliceDocDao;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private CommonCodeService codeService;
    @Autowired
    private DocNumberDao docNumberDao;

    @Override
    public BaseEntityDao<DocEntity> getEntityDao() {
        return this.trafficPoliceDocDao;
    }

    @Override
    @Transactional
    public Response saveDoc(DocEntity doc, String operatorCode) {
        Person person = this.userManageService.getUserByCode(doc.getJh());
        if (person == null) {
            LOG.info("\u8b66\u5458\u4e0d\u5b58\u5728");
            return Response.failMsg((String)"\u8b66\u53f7\u4e0d\u5b58\u5728");
        }
        if (this.checkIfExist(doc)) {
            LOG.info("\u53f7\u6bb5\u5df2\u7ecf\u4f7f\u7528");
            return Response.failMsg((String)"\u53f7\u6bb5\u5df2\u7ecf\u4f7f\u7528");
        }
        doc.setFlag("1");
        doc.setBk("0");
        doc.setUse("0");
        this.save(doc);
        int startNum = Integer.parseInt(doc.getStart());
        int endNum = Integer.parseInt(doc.getEnd());
        for (int i = startNum; i <= endNum; ++i) {
            StringBuilder startString = new StringBuilder(String.valueOf(i));
            while (String.valueOf(startString).length() < 8) {
                startString.insert(0, "0");
            }
            String wsbh = doc.getDwbm() + "7" + startString;
            DocNumber docNumber = new DocNumber();
            docNumber.setFfbm(doc.getDwbm() + "000000");
            docNumber.setJbr(operatorCode);
            docNumber.setLybj("1");
            docNumber.setLybm("");
            docNumber.setLymj(doc.getJh());
            docNumber.setLysj("");
            docNumber.setSysj("");
            docNumber.setWsbh(wsbh);
            docNumber.setWslb("7");
            docNumber.setWszt("0");
            docNumber.setYybm("com.xdja.jtgl");
            this.docNumberDao.save(docNumber);
        }
        return Response.successData(null);
    }

    @Override
    public List<DocEntity> findDoc(DocEntity doc, Page page) {
        List<DocEntity> list = this.trafficPoliceDocDao.findDoc(doc, page);
        if (list == null || list.isEmpty()) {
            return list;
        }
        Map numUseMap = this.codeService.getCodeMap("TRAFFIC_NUM_USE");
        for (DocEntity entity : list) {
            FdbhEntity fdbh;
            DepInfoEntity dep = entity.getDep();
            if (dep != null) {
                entity.setDepName(dep.getName());
            }
            if ((fdbh = entity.getFdbh()) != null) {
                entity.setCurFdbh(fdbh.getFdbh());
            } else {
                entity.setCurFdbh("\u5c1a\u672a\u4f7f\u7528");
            }
            CommonCode code = (CommonCode)numUseMap.get(entity.getFlag());
            if (code != null) {
                entity.setFlagVal(code.getName());
            }
            if (!"7".equals(entity.getCode())) continue;
            entity.setAbolished(true);
        }
        return list;
    }

    @Override
    @Transactional
    public Response abolish(DocEntity doc) {
        DocEntity entity = (DocEntity)this.findById(doc.getEntityPk());
        Response failRes = Response.failMsg((String)"\u7f5a\u5355\u53f7\u6bb5\u5e9f\u9664\u5931\u8d25");
        if (entity == null) {
            return failRes;
        }
        try {
            this.abolishDoc(entity);
        }
        catch (Exception e) {
            LOG.error("\u5220\u9664\u8981\u5e9f\u9664\u7684\u7f5a\u5355\u53f7\u6bb5\u9519\u8bef", (Throwable)e);
            return failRes;
        }
        try {
            LOG.info("\u7f5a\u5355\u53f7\u6bb5\u5e9f\u9664\u6210\u529f\uff0c\u4f46\u4e2d\u95f4\u5e93\u8fdd\u6cd5\u4fe1\u606f\u66f4\u6539\u72b6\u6001\u5931\u8d25\u3002");
            return Response.successMsg((String)"\u7f5a\u5355\u53f7\u6bb5\u5e9f\u9664\u6210\u529f");
        }
        catch (Exception exception) {
            return failRes;
        }
    }

    @Transactional
    public void abolishDoc(DocEntity doc) {
        this.docNumberDao.deleteUnusedNum(doc.getJh());
        DocBackEntity back = new DocBackEntity();
        back.setBk(doc.getBk());
        back.setBy(doc.getBy());
        back.setCode(doc.getCode());
        back.setDwbm(doc.getDwbm());
        back.setEnd(doc.getEnd());
        back.setFlag(doc.getFlag());
        back.setId(doc.getId());
        back.setJh(doc.getJh());
        back.setStart(doc.getStart());
        back.setType(doc.getType());
        back.setUse(doc.getUse());
        LOG.info("\u8bb0\u5f55\u5e9f\u9664\u7684\u7f5a\u5355\u53f7\u5230\u5907\u4efd\u8868\u4e2d");
        this.trafficPoliceDocDao.save(back);
        LOG.info("\u5220\u9664\u8981\u5e9f\u9664\u7684\u7f5a\u5355\u53f7\u6bb5\u8bb0\u5f55");
        this.trafficPoliceDocDao.delete(doc);
    }

    private boolean changeState(DocEntity doc, String newState) {
        LOG.info("\u66f4\u65b0\u72b6\u6001\uff1a" + newState);
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_surveil</Name><IsMain>1</IsMain><Row><Operate>update</Operate><Data>";
        xml = xml + "<c_zt>" + newState + "</c_zt>";
        xml = xml + "</Data><Condition><![CDATA[c_zqmj='" + doc.getJh() + "' and c_zt='" + "0" + "' and c_cjjg like '" + doc.getDwbm() + "%']]></Condition></Row></Table></Tables></Root>";
        if (LOG.isDebugEnabled()) {
            LOG.debug(xml);
        }
        if (wsc.executeUpdate(xml)) {
            return true;
        }
        LOG.info("\u66f4\u65b0\u72b6\u6001\u5931\u8d25: " + wsc.getError());
        return false;
    }
}

