/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.example.https.server;

import com.xdja.pki.gmssl.example.https.HttpsUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class GMHttpsServer360CACert {
    public static void main(String[] args) throws Exception {
        char[] password = "password".toCharArray();
        KeyPair caKeyPair = GMHttpsServer360CACert.getKeyPairFromPEM();
        X509Certificate caCert = GMHttpsServer360CACert.getX509CertificateFromPEM();
        KeyStore serverStore = KeyStore.getInstance("BKS", "BC");
        serverStore.load(null, null);
        serverStore.setKeyEntry("server", caKeyPair.getPrivate(), password, new X509Certificate[]{caCert});
        KeyStore trustStore = KeyStore.getInstance("BKS", "BC");
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca", caCert);
        HttpsUtil.startGMHttpsServer((KeyStore)serverStore, (char[])password, (KeyStore)trustStore, (boolean)false);
    }

    public static KeyPair getKeyPairFromPEM() throws Exception {
        PEMParser pemParser = GMHttpsServer360CACert.getPEMParser("key.pem");
        PEMKeyPair pemPair = (PEMKeyPair)pemParser.readObject();
        KeyPair keyPair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair(pemPair);
        System.out.println(keyPair.getPrivate());
        System.out.println(keyPair.getPublic());
        return keyPair;
    }

    public static X509Certificate getX509CertificateFromPEM() throws Exception {
        PEMParser pemParser = GMHttpsServer360CACert.getPEMParser("cert.pem");
        X509CertificateHolder holder = (X509CertificateHolder)pemParser.readObject();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(holder.getEncoded());
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        System.out.println(certificate);
        return certificate;
    }

    public static PEMParser getPEMParser(String name) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(name);
        if (inputStream == null) {
            throw new Exception("Fail to find pem file: " + name);
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        return new PEMParser((Reader)reader);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProvider("XDJAJSSE") == null) {
            Security.addProvider((Provider)new XDJAJsseProvider());
        }
    }
}

