package com.xdja.pki.gmssl.springboot.server;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;

@RestController
public class WelcomeController {

    @Autowired
    private RestTemplate restTemplate;

    @GetMapping("/get")
    public HashMap<String, String> get() {
//        String url = "https://127.0.0.1:9020/get";
        String url = "https://ebssec.boc.cn";
        String response = restTemplate.getForObject(url, String.class);
        HashMap<String, String> map = new HashMap<>();
        map.put("request", url);
        map.put("ssl", "GMSSLv1.1");
        map.put("cipher_suite", "ECC_SM4_SM3");
        map.put("response", response);
        return map;
    }

    @PostMapping("/post")
    public String post(@RequestBody String body) {
        System.out.println("post " + body);
        return "Hello World! request body is: " + body;
    }
}
