package com.xdja.pki.gmssl.keystore.main;


import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.io.IOException;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class GMSSLCertPrintTools {
    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method, Example: readKeyStore. readCer. readPem");
            System.out.println("if you use readKeyStore. please insert keystore path and password");
            System.out.println("if you use readCer. please insert cer file path ");
            System.out.println("if you use readPem. please insert pem file path ");
            return;
        }

        System.out.println("You want to test: " + args[0]);

        switch (args[0]) {
            case "readKeyStore":
                readKeyStore(args);
                break;
            case "readCer":
                readCer(args);
                break;
            case "readPem":
                readPem(args);
                break;
            default:
                System.out.println("不支持的命令！");
                break;
        }
    }

    private static void readKeyStore(String[] args) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, IOException {
        if (args.length != 3) {
            System.out.println("please insert right param");
            return;
        }
        GMSSLKeyStoreUtils.printGMSSLKeyStore(args[1], args[2]);
    }

    private static void readCer(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("please insert right param");
            return;
        }
        X509Certificate x509Certificate = GMSSLX509Utils.readCertificateFromCer(args[1]);
        System.out.println(x509Certificate);
    }

    private static void readPem(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("please insert right param");
            return;
        }
        X509Certificate x509Certificate = GMSSLX509Utils.readCertificateFromPEM(args[1]);
        System.out.println(x509Certificate);
    }
}
