package com.xdja.pki.hmssl.sdf.pcie.buildcert;


import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.test.GMSSLX509CertUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.Security;
import java.security.cert.X509Certificate;

/**
 * @description: 通过PCIE卡签发证书 需填入生成证书的位置
 * @date: 9:05 2019/6/10
 */
public class GMSSLPCIECertBuild {
    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert cert path");
            return;
        }

        System.out.println("You want to save these certs in : " + args[0]);
        System.out.println("Please");
        generateGMSSLPCIEROOTKeyStore(2, "xdja1234", args[0]);
    }

    public static void generateGMSSLPCIEROOTKeyStore(int privateKeyIndex, String privateKeyPassword, String path) throws Exception {
        String rootDn = "cn=rootca,o=pcie,o=xdja,c=cn";
        X509Certificate rootCertByPCIE = GMSSLX509CertUtils.genRootCertByPCIE(rootDn, privateKeyIndex, privateKeyPassword);
        String encDn = "cn=encByPcie,o=pcie,o=xdja,c=cn";
        X509Certificate encCertByPCIE = GMSSLX509CertUtils.genEncCertByPCIE(encDn, 2, rootDn, privateKeyIndex, privateKeyPassword);
        String signDn = "cn=signByPcie,o=pcie,o=xdja,c=cn";
        X509Certificate signCertByPCIE = GMSSLX509CertUtils.genSignCertByPCIE(signDn, 2, rootDn, privateKeyIndex, privateKeyPassword);
        GMSSLX509CertUtils.saveCert(rootCertByPCIE, signCertByPCIE, encCertByPCIE, new SdfPrivateKey(2, privateKeyPassword.getBytes()),
                new SdfPrivateKey(2, privateKeyPassword.getBytes()), path);

    }
}
