package com.xdja.pcie.sdf.jni.bean;

import java.io.Serializable;

/**
 * 设备信息实体定义
 * @author wyf
 *
 */
public class DeviceInfo implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 设备生产厂商名称
	 */
	private byte[] issuerName = new byte[40];
	/**
	 * 设备型号
	 */
	private byte[] deviceName = new byte[40];
	/**
	 * 设备编号，包含：日期(8字符)、批次号(3字符)、流水号(5字符)
	 */
	private byte[] deviceSerial = new byte[40];
	/**
	 * 密码设备内部软件版本号
	 */
	private int deviceVersion;
	/**
	 * 密码设备支持的接口规范版本号
	 */
	private int standardVersion;
	/**
	 * 第一个元素表示支持的算法；表示方法为非对称算法表示按位或的结果；
	 * <br/>第二个元素表示算法的最大模长，表示方法为支持的模长按位或的结果
	 */
	private int[] asymAlgAbility = new int[2];
	/**
	 * 所支持的对称算法，表示方法为对称算法标识按位或运算结果
	 */
	private int symAlgAbility;
	/**
	 * 所有支持的杂凑算法，表示方法为杂凑算法标识按位或运算结果
	 */
	private int hashAlgAbility;
	/**
	 * 支持的最大文件存储空间(单位字节)
	 */
	private int bufferSize;
	
	public DeviceInfo() {
		super();
	}

	public DeviceInfo(byte[] issuerName, byte[] deviceName, byte[] deviceSerial, int deviceVersion, int standardVersion,
			int[] asymAlgAbility, int symAlgAbility, int hashAlgAbility, int bufferSize) {
		super();
		this.issuerName = issuerName;
		this.deviceName = deviceName;
		this.deviceSerial = deviceSerial;
		this.deviceVersion = deviceVersion;
		this.standardVersion = standardVersion;
		this.asymAlgAbility = asymAlgAbility;
		this.symAlgAbility = symAlgAbility;
		this.hashAlgAbility = hashAlgAbility;
		this.bufferSize = bufferSize;
	}

	/**
	 * 获得 issuerName
	 * @return issuerName 参见 {@linkplain #issuerName} 
	 */
	public byte[] getIssuerName() {
		return issuerName;
	}

	/**
	 * 设置 issuerName
	 * @param issuerName 参见 {@linkplain #issuerName}
	 */
	public void setIssuerName(byte[] issuerName) {
		this.issuerName = issuerName;
	}

	/**
	 * 获得 deviceName
	 * @return deviceName 参见 {@linkplain #deviceName} 
	 */
	public byte[] getDeviceName() {
		return deviceName;
	}

	/**
	 * 设置 deviceName
	 * @param deviceName 参见 {@linkplain #deviceName}
	 */
	public void setDeviceName(byte[] deviceName) {
		this.deviceName = deviceName;
	}

	/**
	 * 获得 deviceSerial
	 * @return deviceSerial 参见 {@linkplain #deviceSerial} 
	 */
	public byte[] getDeviceSerial() {
		return deviceSerial;
	}

	/**
	 * 设置 deviceSerial
	 * @param deviceSerial 参见 {@linkplain #deviceSerial}
	 */
	public void setDeviceSerial(byte[] deviceSerial) {
		this.deviceSerial = deviceSerial;
	}

	/**
	 * 获得 deviceVersion
	 * @return deviceVersion 参见 {@linkplain #deviceVersion} 
	 */
	public int getDeviceVersion() {
		return deviceVersion;
	}

	/**
	 * 设置 deviceVersion
	 * @param deviceVersion 参见 {@linkplain #deviceVersion}
	 */
	public void setDeviceVersion(int deviceVersion) {
		this.deviceVersion = deviceVersion;
	}

	/**
	 * 获得 standardVersion
	 * @return standardVersion 参见 {@linkplain #standardVersion} 
	 */
	public int getStandardVersion() {
		return standardVersion;
	}

	/**
	 * 设置 standardVersion
	 * @param standardVersion 参见 {@linkplain #standardVersion}
	 */
	public void setStandardVersion(int standardVersion) {
		this.standardVersion = standardVersion;
	}

	/**
	 * 获得 asymAlgAbility
	 * @return asymAlgAbility 参见 {@linkplain #asymAlgAbility} 
	 */
	public int[] getAsymAlgAbility() {
		return asymAlgAbility;
	}

	/**
	 * 设置 asymAlgAbility
	 * @param asymAlgAbility 参见 {@linkplain #asymAlgAbility}
	 */
	public void setAsymAlgAbility(int[] asymAlgAbility) {
		this.asymAlgAbility = asymAlgAbility;
	}

	/**
	 * 获得 symAlgAbility
	 * @return symAlgAbility 参见 {@linkplain #symAlgAbility} 
	 */
	public int getSymAlgAbility() {
		return symAlgAbility;
	}

	/**
	 * 设置 symAlgAbility
	 * @param symAlgAbility 参见 {@linkplain #symAlgAbility}
	 */
	public void setSymAlgAbility(int symAlgAbility) {
		this.symAlgAbility = symAlgAbility;
	}

	/**
	 * 获得 hashAlgAbility
	 * @return hashAlgAbility 参见 {@linkplain #hashAlgAbility} 
	 */
	public int getHashAlgAbility() {
		return hashAlgAbility;
	}

	/**
	 * 设置 hashAlgAbility
	 * @param hashAlgAbility 参见 {@linkplain #hashAlgAbility}
	 */
	public void setHashAlgAbility(int hashAlgAbility) {
		this.hashAlgAbility = hashAlgAbility;
	}

	/**
	 * 获得 bufferSize
	 * @return bufferSize 参见 {@linkplain #bufferSize} 
	 */
	public int getBufferSize() {
		return bufferSize;
	}

	/**
	 * 设置 bufferSize
	 * @param bufferSize 参见 {@linkplain #bufferSize}
	 */
	public void setBufferSize(int bufferSize) {
		this.bufferSize = bufferSize;
	}

	@Override
	public String toString() {

        String fmt = "DeviceInfo:";
        fmt = fmt + "\n\t IsserName      : %s";
        fmt = fmt + "\n\t DeviceName     : %s";
        fmt = fmt + "\n\t DeviceSerial   : %s";
        fmt = fmt + "\n\t DeviceVersion  : %X";
        fmt = fmt + "\n\t StandardVersion: %X";
        fmt = fmt + "\n\t AsymAlgAbility : %X, %X";
        fmt = fmt + "\n\t SymAlgAbility  : %X";
        fmt = fmt + "\n\t HashAlgAbility : %X";
        fmt = fmt + "\n\t BufferSize     : %d bytes";

        return String.format(fmt,
                new String(issuerName),
                new String(deviceName),
                new String(deviceSerial),
                deviceVersion,
                standardVersion,
                asymAlgAbility[0], asymAlgAbility[1],
                symAlgAbility, hashAlgAbility, bufferSize);
    }
}
