package com.xdja.pki.gmssl.sdf.pcie;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcieSdfSDKDemo {
    private static Logger logger = LoggerFactory.getLogger(PcieSdfSDKDemo.class.getName());

    public static void main(String[] args) throws Exception {

        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method, Example: all. random, gensm2key. sm2import, sm2sign. sm2enc. sm4enc. sm3hash. sm3hmac. sm4mac");
            System.out.println("                    if use 'random' you can add length, Example: random 28, Default: 28");
            System.out.println("                    if use 'sm2import' you can add enc or sign, index, p12 file path, password, Example: sm2import enc 1 enc_key.p12 password");
            System.out.println("                                                                                                Example: sm2import sign 1 sign_key.p12 password");
            return;
        }

        System.out.println("You want to test: " + args[0]);
        PcieSdfSDK sdfSDK = new PcieSdfSDK();

        switch (args[0]) {
            case "all":
                System.out.println("*************** random ***************");
                random(sdfSDK, args);
                System.out.println("*************** generateKeyPairEcc ***************");
                sdfSDK.generateKeyPairEcc();
                System.out.println("*************** sm2SignDemo ***************");
                sm2SignDemo(sdfSDK);
                System.out.println("*************** sm2EncDemo ***************");
                sm2EncDemo(sdfSDK);
                System.out.println("*************** sm4EncDemo ***************");
                sm4EncDemo(sdfSDK);
                System.out.println("*************** sm3HashDemo ***************");
                sm3HashDemo(sdfSDK);
                System.out.println("*************** sm3HmacDemo ***************");
                sm3HmacDemo(sdfSDK);
                System.out.println("*************** sm4MacDemo ***************");
                sm4MacDemo(sdfSDK);
                break;
            case "random":
                //测试生成 随机数
                random(sdfSDK, args);
                break;
            case "gensm2key":
                //生成SM2公私钥对
                sdfSDK.generateKeyPairEcc();
                break;
            case "sm2import":
                sm2ImportDemo(sdfSDK, args);
                break;
            case "sm2sign":
                sm2SignDemo(sdfSDK);
                break;
            case "sm2enc":
                sm2EncDemo(sdfSDK);
                break;
            case "sm4enc":
                sm4EncDemo(sdfSDK);
                break;
            case "sm3hash":
                sm3HashDemo(sdfSDK);
                break;
            case "sm3hmac":
                sm3HmacDemo(sdfSDK);
                break;
            case "sm4mac":
                sm4MacDemo(sdfSDK);
                break;
            default:
                System.out.println("不支持的命令！");
                break;
        }
    }

    private static void random(PcieSdfSDK sdfSDK, String[] args) throws SdfSDKException {
        int len = 28;
        if (args.length == 2) {
            len = Integer.valueOf(args[1]);
        }
        byte[] out = sdfSDK.generateRandom(len);
        GMSSLByteArrayUtils.printHexBinary(logger, "generateRandom out", out);
    }

    /**
     * 导入SM2公私钥对
     * Example: sm2import enc 1 enc_key.p12 password
     * Example: sm2import sign 1 sign_key.p12 password
     **/
    private static void sm2ImportDemo(PcieSdfSDK sdfSDK, String[] args) throws SdfSDKException {
        if (args.length != 5) {
            System.out.println("Example: sm2import enc 1 enc_key.p12 password");
            System.out.println("Example: sm2import sign 1 sign_key.p12 password");
            return;
        }
        String usage = args[1];
        int index = Integer.valueOf(args[2]);
        String p12file = args[3];
        char[] password = args[4].toCharArray();

        // TODO: 2019/4/10 import sm2 key
//        if ("sign".equals(usage)) {
//            sdfSDK.importSM2SignKey(p12file, password, index);
//        } else {
//            sdfSDK.importSM2EnvKey(p12file, password, index);
//        }
    }

    /**
     * 导入SM2公私钥对 并进行 签名验签
     **/
    private static void sm2SignDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        char[] pw = "63fbd873".toCharArray();
        String signP12 = "cert/admin14_sign_63fbd873.p12";

        //设备访问密码
        byte[] pwd = "xdja1234".getBytes();
        int sm2Index = 1;// sm2 签名、加密公私钥 可以用一个容器
        byte[] data = "12345678123456781234567812345678".getBytes();

//        //导入SM2签名密钥对
//        PublicKey signPublicKey = sdfSDK.importSM2SignKey(signP12, pw, sm2Index);
//        //获取私钥访问权限
//        sdfSDK.getPrivateKeyAccessRight(sm2Index, pwd);
//        //SM2签名
//        EccSignature eccSignature = sdfSDK.internalSignECC(sm2Index, data);
//        //SM2验签
//        sdfSDK.externalVerifyECC(signPublicKey, data, eccSignature);
//        //释放私钥访问权限
//        sdfSDK.releasePrivateKeyAccessRight(sm2Index);
    }

    /**
     * 导入SM2公私钥对 并进行 加密解密操作
     **/
    private static void sm2EncDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        char[] pw = "63fbd873".toCharArray();
        String encP12 = "cert/admin14_enc_63fbd873.p12";

        //设备访问密码
        byte[] pwd = "xdja1234".getBytes();
        int sm2Index = 1;// sm2 签名、加密公私钥 可以用一个容器
        byte[] data = "12345678123456781234567812345678".getBytes();

        //导入SM2加密密钥对
//        PublicKey encPublicKey = sdfSDK.importSM2EnvKey(encP12, pw, sm2Index);
//        //SM2加密
//        EccCipher eccCipher = sdfSDK.externalEncryptECC(encPublicKey, data);
//        //获取私钥访问权限
//        sdfSDK.getPrivateKeyAccessRight(sm2Index, pwd);
//        //SM2解密
//        byte[] out = sdfSDK.internalDecryptECC(sm2Index, data.length, eccCipher);
//
//       GMSSLByteArrayUtils.printHexBinary(logger,"internalDecryptECC out", out);
//        //释放私钥访问权限
//        sdfSDK.releasePrivateKeyAccessRight(sm2Index);
    }

    /**
     * SM4 加密解密 导入会话密钥 销毁会话密钥
     **/
    public static void sm4EncDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        //SM4
        byte[] key = "1234567812345678".getBytes();
        byte[] data = "12345678123456781234567812345678".getBytes();

        //导入会话密钥	SDF_ImportKey
        long[] phKeyHandle = sdfSDK.importKey(key);

        //CBC模式加密	SDF_Encrypt
        byte[] iv = {1, 2, 3, 4, 5, 6, 7, 8};

        byte[] pucEncData = sdfSDK.encrypt(phKeyHandle, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, data);

        //CBC模式解密	SDF_Decrypt
        byte[] d = sdfSDK.decrypt(phKeyHandle, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, pucEncData);


        GMSSLByteArrayUtils.printHexBinary(logger, "sdfSDK.decrypt", d);
        //销毁会话密钥	SDF_DestroyKey
        sdfSDK.destroyKey(phKeyHandle);
    }

    public static void sm3HashDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        byte[] pucID = {1, 2, 3, 4, 5, 6, 7, 8};
        byte[] data = "12345678123456781234567812345678".getBytes();
        GMSSLByteArrayUtils.printHexBinary(logger, "data", data);
//        init	SDF_HashInit
        sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3);
//        update	SDF_HashUpdate
        sdfSDK.hashUpdate(data);
//        final	SDF_HashFinal
        byte[] out = sdfSDK.hashFinal();
        GMSSLByteArrayUtils.printHexBinary(logger, "sdfSDK.hashFinal", out);
    }

    public static void sm3HmacDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
//        MAC计算	SDF_CalculateMAC
        byte[] data = "12345678123456781234567812345678".getBytes();
        byte[] key = "12345678123456781234567812345678".getBytes();
        byte[] mac = sdfSDK.sm3Hmac(data, key);
        GMSSLByteArrayUtils.printHexBinary(logger, "sdfSDK.sm3Hmac", mac);
    }

    public static void sm4MacDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
//        MAC计算	SDF_CalculateMAC
        sdfSDK.calculateMac(1);
    }

}
