package com.xdja.pki.gmssl.sdf.pcie;

import com.xdja.pcie.sdf.jni.bean.EccPrivateKey;
import com.xdja.pcie.sdf.jni.bean.EccPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import org.slf4j.Logger;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.*;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;

public class PcieSdfSDKUtils {

    /*************************************************************************************************
     *                                          JAVA to SDF                                          *
     *************************************************************************************************/
    public static EccPublicKey generateEccPublicKey(Logger logger, PublicKey key) {
        ECPublicKey ecPublicKey = (ECPublicKey) key;

        return generateEccPublicKey(logger, ecPublicKey.getW().getAffineX().toByteArray(),
                ecPublicKey.getW().getAffineY().toByteArray());
    }

    public static EccPublicKey generateEccPublicKey(Logger logger, SdfECCPublicKey key) {
        return generateEccPublicKey(logger, key.getX(), key.getY());
    }

    public static EccPublicKey generateEccPublicKey(Logger logger, byte[] x, byte[] y) {
        logger.info("generateEccPublicKey");

        EccPublicKey pucPublicKey = new EccPublicKey(
                GMSSLX509Utils.ECC_KEY_BITS,
                GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(x),
                GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(y)
        );

        GMSSLByteArrayUtils.printHexBinary(logger, "EccPublicKey x", pucPublicKey.getX());
        GMSSLByteArrayUtils.printHexBinary(logger, "EccPublicKey y", pucPublicKey.getY());
        System.out.println();

        return pucPublicKey;
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, PrivateKey key) {
        ECPrivateKey ecPrivateKey = (ECPrivateKey) key;
        return generateEccPrivateKey(logger, ecPrivateKey.getS().toByteArray());
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, byte[] k) {
        System.out.println("generateEccPrivateKey");
        EccPrivateKey pucPrivateKey = new EccPrivateKey(
                GMSSLX509Utils.ECC_KEY_BITS,
                GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(k)
        );
        GMSSLByteArrayUtils.printHexBinary(logger, "pucPrivateKey k", pucPrivateKey.getK());

        System.out.println();
        return pucPrivateKey;
    }

    /*************************************************************************************************
     *                                          SDF to JAVA                                          *
     *************************************************************************************************/

    public static PublicKey getPublicKeyFromCer(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate certificate = (X509Certificate) factory.generateCertificate(inputStream);
        return certificate.getPublicKey();
    }
}
