package com.xdja.pcie.sdf.jni.bean;

import java.io.Serializable;
import java.util.Arrays;

/**
 * ECC加密密钥对保护结构实体定义
 * @author wyf
 *
 */
public class EnvelopedKeyBlob implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 保护对称密钥的非对称算法标识
	 */
	private long ulAsymmAlgId;
	/**
	 * 对称算法标识
	 * <br/>备注：必须为ECB模式
	 */
	private long ulSymmAlgId;
	/**
	 * 对称密钥密文
	 */
	private EccCipher eccCipherBlob;
	/**
	 * 加密密钥对的公钥
	 */
	private EccPublicKey publicKey;
	/**
	 * 加密密钥对的私钥密文，其有效长度为原文的(ulBits + 7)/8
	 * <br/>备注：私钥原文为结构为EccPrivateKey
	 */
	private byte[] cbEncryptedPrivKey = new byte[64];

	public EnvelopedKeyBlob() {
		super();
	}

	public EnvelopedKeyBlob(long ulAsymmAlgId, long ulSymmAlgId, EccCipher eccCipherBlob, EccPublicKey publicKey,
			byte[] cbEncryptedPrivKey) {
		super();
		this.ulAsymmAlgId = ulAsymmAlgId;
		this.ulSymmAlgId = ulSymmAlgId;
		this.eccCipherBlob = eccCipherBlob;
		this.publicKey = publicKey;
		this.cbEncryptedPrivKey = cbEncryptedPrivKey;
	}

	/**
	 * 获得 ulAsymmAlgId
	 * @return ulAsymmAlgId 参见 {@linkplain #ulAsymmAlgId} 
	 */
	public long getUlAsymmAlgId() {
		return ulAsymmAlgId;
	}

	/**
	 * 设置 ulAsymmAlgId
	 * @param ulAsymmAlgId 参见 {@linkplain #ulAsymmAlgId}
	 */
	public void setUlAsymmAlgId(long ulAsymmAlgId) {
		this.ulAsymmAlgId = ulAsymmAlgId;
	}

	/**
	 * 获得 ulSymmAlgId
	 * @return ulSymmAlgId 参见 {@linkplain #ulSymmAlgId} 
	 */
	public long getUlSymmAlgId() {
		return ulSymmAlgId;
	}

	/**
	 * 设置 ulSymmAlgId
	 * @param ulSymmAlgId 参见 {@linkplain #ulSymmAlgId}
	 */
	public void setUlSymmAlgId(long ulSymmAlgId) {
		this.ulSymmAlgId = ulSymmAlgId;
	}

	/**
	 * 获得 eccCipherBlob
	 * @return eccCipherBlob 参见 {@linkplain #eccCipherBlob} 
	 */
	public EccCipher getEccCipherBlob() {
		return eccCipherBlob;
	}

	/**
	 * 设置 eccCipherBlob
	 * @param eccCipherBlob 参见 {@linkplain #eccCipherBlob}
	 */
	public void setEccCipherBlob(EccCipher eccCipherBlob) {
		this.eccCipherBlob = eccCipherBlob;
	}

	/**
	 * 获得 publicKey
	 * @return publicKey 参见 {@linkplain #publicKey} 
	 */
	public EccPublicKey getPublicKey() {
		return publicKey;
	}

	/**
	 * 设置 publicKey
	 * @param publicKey 参见 {@linkplain #publicKey}
	 */
	public void setPublicKey(EccPublicKey publicKey) {
		this.publicKey = publicKey;
	}

	/**
	 * 获得 cbEncryptedPrivKey
	 * @return cbEncryptedPrivKey 参见 {@linkplain #cbEncryptedPrivKey} 
	 */
	public byte[] getCbEncryptedPrivKey() {
		return cbEncryptedPrivKey;
	}

	/**
	 * 设置 cbEncryptedPrivKey
	 * @param cbEncryptedPrivKey 参见 {@linkplain #cbEncryptedPrivKey}
	 */
	public void setCbEncryptedPrivKey(byte[] cbEncryptedPrivKey) {
		this.cbEncryptedPrivKey = cbEncryptedPrivKey;
	}

	@Override
	public String toString() {
		return "EnvelopedKeyBlob [ulAsymmAlgId=" + ulAsymmAlgId + ", ulSymmAlgId=" + ulSymmAlgId + ", eccCipherBlob="
				+ eccCipherBlob + ", publicKey=" + publicKey + ", cbEncryptedPrivKey="
				+ Arrays.toString(cbEncryptedPrivKey) + "]";
	}

}
