/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lic.verify;

import com.xdja.lic.verify.JNIUtils;
import com.xdja.lic.verify.XLicPair;
import com.xdja.lic.verify.jni.SWIGTYPE_p_p_char;
import com.xdja.lic.verify.jni.SWIGTYPE_p_p_unsigned_char;
import com.xdja.lic.verify.jni.SWIGTYPE_p_p_void;
import com.xdja.lic.verify.jni.SWIGTYPE_p_unsigned_char;
import com.xdja.lic.verify.jni.SWIGTYPE_p_unsigned_int;
import com.xdja.lic.verify.jni.SWIGTYPE_p_unsigned_long_long;
import com.xdja.lic.verify.jni.SWIGTYPE_p_unsigned_short;
import com.xdja.lic.verify.jni.SWIGTYPE_p_void;
import com.xdja.lic.verify.jni.SWIGTYPE_p_xlic;
import com.xdja.lic.verify.jni.xlic_verify_wrapper;
import java.math.BigInteger;

public class XLicVerify {
    private SWIGTYPE_p_xlic pXlic;

    protected void setpXlic(SWIGTYPE_p_xlic xlic) {
        this.pXlic = xlic;
    }

    public SWIGTYPE_p_xlic getpXlic() {
        return this.pXlic;
    }

    public String getProductName() {
        return xlic_verify_wrapper.xlic_get_product_name(this.pXlic);
    }

    public String getProductModel() {
        return xlic_verify_wrapper.xlic_get_product_model(this.pXlic);
    }

    public String getProductOwner() {
        return xlic_verify_wrapper.xlic_get_product_owner(this.pXlic);
    }

    public String getProductOem() {
        return xlic_verify_wrapper.xlic_get_product_oem(this.pXlic);
    }

    public String getProductBroker() {
        return xlic_verify_wrapper.xlic_get_product_broker(this.pXlic);
    }

    public long getValidStart() {
        BigInteger startTime = xlic_verify_wrapper.xlic_get_valid_start(this.pXlic);
        return startTime.longValue();
    }

    public long getValidEnd() {
        BigInteger endTime = xlic_verify_wrapper.xlic_get_valid_end(this.pXlic);
        return endTime.longValue();
    }

    public long getSupportStart() {
        BigInteger supportStartTime = xlic_verify_wrapper.xlic_get_support_start(this.pXlic);
        return supportStartTime.longValue();
    }

    public long getSupportEnd() {
        BigInteger supportEndTime = xlic_verify_wrapper.xlic_get_support_end(this.pXlic);
        return supportEndTime.longValue();
    }

    public XLicPair<Integer, byte[]> getAnchorDevSn() {
        SWIGTYPE_p_p_unsigned_char sn_p_p = xlic_verify_wrapper.new_uint8p_p();
        SWIGTYPE_p_unsigned_char len_p = xlic_verify_wrapper.new_uint8Array(1);
        int ret = xlic_verify_wrapper.xlic_get_anchor_dev_sn(this.pXlic, sn_p_p, len_p);
        byte[] value = new byte[]{0};
        if (ret == 0) {
            SWIGTYPE_p_unsigned_char swigtype_p_unsigned_char = xlic_verify_wrapper.uint8p_p_value(sn_p_p);
            int len = xlic_verify_wrapper.uint8Array_getitem(len_p, 0);
            value = new byte[len];
            for (int i = 0; i < len; ++i) {
                value[i] = (byte)xlic_verify_wrapper.uint8Array_getitem(swigtype_p_unsigned_char, i);
            }
        }
        xlic_verify_wrapper.delete_uint8p_p(sn_p_p);
        xlic_verify_wrapper.delete_uint8Array(len_p);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, byte[]> getAnchorMediaSn() {
        SWIGTYPE_p_p_unsigned_char sn_p_p = xlic_verify_wrapper.new_uint8p_p();
        SWIGTYPE_p_unsigned_char len_p = xlic_verify_wrapper.new_uint8Array(1);
        int ret = xlic_verify_wrapper.xlic_get_anchor_media_sn(this.pXlic, sn_p_p, len_p);
        byte[] value = new byte[]{0};
        if (ret == 0) {
            SWIGTYPE_p_unsigned_char swigtype_p_unsigned_char = xlic_verify_wrapper.uint8p_p_value(sn_p_p);
            int len = xlic_verify_wrapper.uint8Array_getitem(len_p, 0);
            value = new byte[len];
            for (int i = 0; i < len; ++i) {
                value[i] = (byte)xlic_verify_wrapper.uint8Array_getitem(swigtype_p_unsigned_char, i);
            }
        }
        xlic_verify_wrapper.delete_uint8p_p(sn_p_p);
        xlic_verify_wrapper.delete_uint8Array(len_p);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, byte[]> getAnchorUserId() {
        SWIGTYPE_p_p_unsigned_char sn_p_p = xlic_verify_wrapper.new_uint8p_p();
        SWIGTYPE_p_unsigned_char len_p = xlic_verify_wrapper.new_uint8Array(1);
        int ret = xlic_verify_wrapper.xlic_get_anchor_user_id(this.pXlic, sn_p_p, len_p);
        byte[] value = new byte[]{0};
        if (ret == 0) {
            SWIGTYPE_p_unsigned_char swigtype_p_unsigned_char = xlic_verify_wrapper.uint8p_p_value(sn_p_p);
            int len = xlic_verify_wrapper.uint8Array_getitem(len_p, 0);
            value = new byte[len];
            for (int i = 0; i < len; ++i) {
                value[i] = (byte)xlic_verify_wrapper.uint8Array_getitem(swigtype_p_unsigned_char, i);
            }
        }
        xlic_verify_wrapper.delete_uint8p_p(sn_p_p);
        xlic_verify_wrapper.delete_uint8Array(len_p);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, byte[]> getAnchorCustomerId() {
        SWIGTYPE_p_p_unsigned_char sn_p_p = xlic_verify_wrapper.new_uint8p_p();
        SWIGTYPE_p_unsigned_char len_p = xlic_verify_wrapper.new_uint8Array(1);
        int ret = xlic_verify_wrapper.xlic_get_anchor_customer_id(this.pXlic, sn_p_p, len_p);
        byte[] value = new byte[]{0};
        if (ret == 0) {
            SWIGTYPE_p_unsigned_char swigtype_p_unsigned_char = xlic_verify_wrapper.uint8p_p_value(sn_p_p);
            int len = xlic_verify_wrapper.uint8Array_getitem(len_p, 0);
            value = new byte[len];
            for (int i = 0; i < len; ++i) {
                value[i] = (byte)xlic_verify_wrapper.uint8Array_getitem(swigtype_p_unsigned_char, i);
            }
        }
        xlic_verify_wrapper.delete_uint8p_p(sn_p_p);
        xlic_verify_wrapper.delete_uint8Array(len_p);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, byte[]> getAnchorRegId() {
        SWIGTYPE_p_p_unsigned_char sn_p_p = xlic_verify_wrapper.new_uint8p_p();
        SWIGTYPE_p_unsigned_char len_p = xlic_verify_wrapper.new_uint8Array(1);
        int ret = xlic_verify_wrapper.xlic_get_anchor_reg_id(this.pXlic, sn_p_p, len_p);
        byte[] value = new byte[]{0};
        if (ret == 0) {
            SWIGTYPE_p_unsigned_char swigtype_p_unsigned_char = xlic_verify_wrapper.uint8p_p_value(sn_p_p);
            int len = xlic_verify_wrapper.uint8Array_getitem(len_p, 0);
            value = new byte[len];
            for (int i = 0; i < len; ++i) {
                value[i] = (byte)xlic_verify_wrapper.uint8Array_getitem(swigtype_p_unsigned_char, i);
            }
        }
        xlic_verify_wrapper.delete_uint8p_p(sn_p_p);
        xlic_verify_wrapper.delete_uint8Array(len_p);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, Short> getElu8(String key) {
        SWIGTYPE_p_unsigned_char swigtype_p_unsigned_char = JNIUtils.newP_unsigned_char(1);
        int ret = xlic_verify_wrapper.xlic_get_elu8(this.pXlic, key, swigtype_p_unsigned_char);
        short value = 0;
        if (ret == 0) {
            value = JNIUtils.get_unit8Array_item(swigtype_p_unsigned_char, 0);
        }
        JNIUtils.deleteP_unsigned_char(swigtype_p_unsigned_char);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, Integer> getElu16(String key) {
        SWIGTYPE_p_unsigned_short swigtype_p_unsigned_short = xlic_verify_wrapper.new_uint16Array(1);
        int ret = xlic_verify_wrapper.xlic_get_elu16(this.pXlic, key, swigtype_p_unsigned_short);
        int value = 0;
        if (ret == 0) {
            value = xlic_verify_wrapper.uint16Array_getitem(swigtype_p_unsigned_short, 0);
        }
        xlic_verify_wrapper.delete_uint16Array(swigtype_p_unsigned_short);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, Long> getElu32(String key) {
        SWIGTYPE_p_unsigned_int swigtype_p_unsigned_int = xlic_verify_wrapper.new_uint32Array(1);
        int ret = xlic_verify_wrapper.xlic_get_elu32(this.pXlic, key, swigtype_p_unsigned_int);
        long value = 0L;
        if (ret == 0) {
            value = xlic_verify_wrapper.uint32Array_getitem(swigtype_p_unsigned_int, 0);
        }
        xlic_verify_wrapper.delete_uint32Array(swigtype_p_unsigned_int);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, String> getElu64(String key) {
        BigInteger bigInteger;
        SWIGTYPE_p_unsigned_long_long swigtype_p_unsigned_long_long = xlic_verify_wrapper.new_uint64Array(1);
        int ret = xlic_verify_wrapper.xlic_get_elu64(this.pXlic, key, swigtype_p_unsigned_long_long);
        String value = "";
        if (ret == 0 && (bigInteger = xlic_verify_wrapper.uint64Array_getitem(swigtype_p_unsigned_long_long, 0)) != null) {
            value = bigInteger.toString();
        }
        xlic_verify_wrapper.delete_uint64Array(swigtype_p_unsigned_long_long);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, String> getElstr(String key) {
        SWIGTYPE_p_p_char swigtype_p_p_char = xlic_verify_wrapper.new_charp_p();
        int ret = xlic_verify_wrapper.xlic_get_elstr(this.pXlic, key, swigtype_p_p_char);
        String value = "";
        if (ret == 0) {
            value = xlic_verify_wrapper.charp_p_value(swigtype_p_p_char);
        }
        xlic_verify_wrapper.delete_charp_p(swigtype_p_p_char);
        return XLicPair.create(ret, value);
    }

    public XLicPair<Integer, byte[]> getElbin(String key) {
        SWIGTYPE_p_p_void swigtype_p_p_void = xlic_verify_wrapper.new_voidp_p();
        SWIGTYPE_p_unsigned_int swigtype_p_unsigned_int = xlic_verify_wrapper.new_uint32Array(1);
        int ret = xlic_verify_wrapper.xlic_get_elbin(this.pXlic, key, swigtype_p_p_void, swigtype_p_unsigned_int);
        byte[] value = new byte[]{0};
        if (ret == 0) {
            long len = xlic_verify_wrapper.uint32Array_getitem(swigtype_p_unsigned_int, 0);
            value = new byte[(int)len];
            SWIGTYPE_p_void swigtype_p_void = xlic_verify_wrapper.voidp_p_value(swigtype_p_p_void);
            SWIGTYPE_p_unsigned_char swigtype_p_unsigned_char = xlic_verify_wrapper.void_p_to_uint8_t_p(swigtype_p_void);
            for (int i = 0; i < (int)len; ++i) {
                value[i] = (byte)xlic_verify_wrapper.uint8Array_getitem(swigtype_p_unsigned_char, i);
            }
        }
        xlic_verify_wrapper.delete_voidp_p(swigtype_p_p_void);
        xlic_verify_wrapper.delete_uint32Array(swigtype_p_unsigned_int);
        return XLicPair.create(ret, value);
    }

    public void xlicFree() {
        if (!this.isEmptyPXlic(this.pXlic)) {
            xlic_verify_wrapper.xlic_free(this.pXlic);
            this.pXlic = null;
        }
    }

    protected boolean isEmptyPXlic(SWIGTYPE_p_xlic lic) {
        return lic == null;
    }
}

