/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.lic.verify;

import com.xdja.lic.verify.JNIUtils;
import com.xdja.lic.verify.XLicPair;
import com.xdja.lic.verify.XLicVerify;
import com.xdja.lic.verify.jni.SWIGTYPE_p_unsigned_char;
import com.xdja.lic.verify.jni.SWIGTYPE_p_xlic;
import com.xdja.lic.verify.jni.xlic_verify_wrapper;

public class XlicLoad {
    public static XLicPair<Integer, XLicVerify> loadLicFromBuf(byte[] buf, int len) {
        SWIGTYPE_p_unsigned_char swigtype_p_unsigned_char = JNIUtils.toSwigUint8Array(buf, len);
        SWIGTYPE_p_xlic pXlic = xlic_verify_wrapper.xlic_load_from_buf(swigtype_p_unsigned_char, len);
        JNIUtils.deleteP_unsigned_char(swigtype_p_unsigned_char);
        XLicVerify xLicVerify = new XLicVerify();
        if (XlicLoad.isEmptyPXlic(pXlic)) {
            return new XLicPair<Integer, XLicVerify>(-1, xLicVerify);
        }
        xLicVerify.setpXlic(pXlic);
        return new XLicPair<Integer, XLicVerify>(0, xLicVerify);
    }

    public static XLicPair<Integer, XLicVerify> loadLicFromFile(String path) {
        SWIGTYPE_p_xlic pXlic = xlic_verify_wrapper.unix_xlic_load_from_file(path);
        XLicVerify xLicVerify = new XLicVerify();
        if (XlicLoad.isEmptyPXlic(pXlic)) {
            return new XLicPair<Integer, XLicVerify>(-1, xLicVerify);
        }
        xLicVerify.setpXlic(pXlic);
        return new XLicPair<Integer, XLicVerify>(0, xLicVerify);
    }

    public static XLicPair<Integer, XLicVerify> loadBuffVerifyIssuer(byte[] buf, int len, byte[] issuerBuf, int issuerLen) {
        XLicPair<Integer, XLicVerify> xLicPair = XlicLoad.loadLicFromBuf(issuerBuf, issuerLen);
        if (xLicPair.getKey() >= 0) {
            XLicPair<Integer, XLicVerify> xLicSonPair = XlicLoad.loadBuffVerifyIssuer(buf, len, xLicPair.getValue());
            xLicPair.getValue().xlicFree();
            return xLicSonPair;
        }
        if (xLicPair.getValue() != null) {
            xLicPair.getValue().xlicFree();
        }
        return xLicPair;
    }

    public static XLicPair<Integer, XLicVerify> loadFileVerifyIssuer(String path, String issuerPath) {
        XLicPair<Integer, XLicVerify> xLicPair = XlicLoad.loadLicFromFile(issuerPath);
        if (xLicPair.getKey() >= 0) {
            XLicPair<Integer, XLicVerify> xLicPairSon = XlicLoad.loadFileVerifyIssuer(path, xLicPair.getValue());
            xLicPair.getValue().xlicFree();
            return xLicPairSon;
        }
        if (xLicPair.getValue() != null) {
            xLicPair.getValue().xlicFree();
        }
        return xLicPair;
    }

    public static XLicPair<Integer, XLicVerify> loadBuffVerifyIssuer(byte[] buf, int len, XLicVerify xLicVerify) {
        if (xLicVerify == null) {
            return new XLicPair<Integer, Object>(-2, null);
        }
        if (XlicLoad.isEmptyPXlic(xLicVerify.getpXlic())) {
            return new XLicPair<Integer, Object>(-2, null);
        }
        SWIGTYPE_p_unsigned_char swigtype_p_unsigned_char = JNIUtils.toSwigUint8Array(buf, len);
        SWIGTYPE_p_xlic pXlic = xlic_verify_wrapper.xlic_load_buf_verify_issuer(swigtype_p_unsigned_char, len, xLicVerify.getpXlic());
        JNIUtils.deleteP_unsigned_char(swigtype_p_unsigned_char);
        if (XlicLoad.isEmptyPXlic(pXlic)) {
            return new XLicPair<Integer, Object>(-1, null);
        }
        XLicVerify xLicVerifySon = new XLicVerify();
        xLicVerifySon.setpXlic(pXlic);
        return new XLicPair<Integer, XLicVerify>(0, xLicVerifySon);
    }

    public static XLicPair<Integer, XLicVerify> loadFileVerifyIssuer(String path, XLicVerify xLicVerify) {
        if (xLicVerify == null) {
            return XLicPair.create(-2, null);
        }
        if (XlicLoad.isEmptyPXlic(xLicVerify.getpXlic())) {
            return XLicPair.create(-2, null);
        }
        SWIGTYPE_p_xlic pXlic = xlic_verify_wrapper.unix_xlic_load_file_verify_issuer(path, xLicVerify.getpXlic());
        if (XlicLoad.isEmptyPXlic(pXlic)) {
            return XLicPair.create(-1, null);
        }
        XLicVerify xLicVerifySon = new XLicVerify();
        xLicVerifySon.setpXlic(pXlic);
        return XLicPair.create(0, xLicVerifySon);
    }

    public int xlicVerify(String path) {
        return xlic_verify_wrapper.xlic_verify(path);
    }

    protected static boolean isEmptyPXlic(SWIGTYPE_p_xlic lic) {
        return lic == null;
    }
}

