/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.alibaba.fastjson.JSON;
import com.xdja.pki.gmssl.http.GMSSLHttpClient;
import com.xdja.pki.gmssl.http.GMSSLHttpsClient;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpRequest;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpResponse;
import com.xdja.pki.gmssl.http.exception.GMSSLHttpException;
import com.xdja.ra.bean.ErrorMsg;
import com.xdja.ra.bean.Result;
import com.xdja.ra.constant.SdkConstants;
import com.xdja.ra.ennum.ReqMethodEnum;
import com.xdja.ra.error.ErrorBean;
import com.xdja.ra.error.ErrorEnum;
import com.xdja.ra.utils.SdkJsonUtils;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLHttpReqUtils {
    protected static final transient Logger logger = LoggerFactory.getLogger(GMSSLHttpReqUtils.class);

    public static Result sendGMSSLHttpReq(String method, String url, boolean isHttps, X509Certificate[] caCert, Map<String, String> header, byte[] reqBody, Map<String, String> params) {
        GMSSLHttpResponse response;
        GMSSLHttpClient httpClient = null;
        if (isHttps) {
            if (caCert != null) {
                try {
                    httpClient = new GMSSLHttpsClient(caCert);
                }
                catch (GMSSLHttpException e) {
                    logger.error(method + "\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
                    return Result.failure(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
                }
            } else {
                httpClient = new GMSSLHttpsClient();
            }
            url = "https://" + url;
        } else {
            httpClient = new GMSSLHttpClient();
            url = "http://" + url;
        }
        GMSSLHttpRequest request = new GMSSLHttpRequest();
        request.setUrl(url);
        if (null != params) {
            request.setParams(params);
        }
        request.setHeaders(header);
        if (null != reqBody) {
            request.setBody(reqBody);
        }
        try {
            response = GMSSLHttpReqUtils.getGMSSLHttpResponse(httpClient, request, method);
        }
        catch (Exception e) {
            logger.error(method + "\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
            return Result.failure(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
        }
        logger.debug("========== sendGMSSLHttpReq.result>>>>" + response.getStatusCode() + " " + new String(response.getBody()));
        if (response.getStatusCode() != SdkConstants.SUCCESS_CODE_200) {
            if (null == response.getBody()) {
                logger.error(" ========== \u8bf7\u6c42RA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
                return Result.failure(ErrorEnum.RA_OPEN_API_RETURN_INFO_IS_EMPTY);
            }
            try {
                ErrorBean errorBean = SdkJsonUtils.json2Object(String.valueOf(response.getBody()), ErrorBean.class);
                if (null == errorBean.getErrMsg()) {
                    ErrorMsg errorMsg = (ErrorMsg)JSON.parseObject((String)String.valueOf(response.getBody()), ErrorMsg.class);
                    return Result.failure(errorMsg.getErrorCode(), errorMsg.getErrorMsg());
                }
                return Result.failure(errorBean.getErrCode(), errorBean.getErrMsg());
            }
            catch (Exception e) {
                logger.error(" ========== \u8bf7\u6c42RA\u7684\u5916\u90e8\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
                return Result.failure(ErrorEnum.RA_OPEN_API_RETURN_EXCEPTION);
            }
        }
        byte[] resp = response.getBody();
        return Result.success(resp);
    }

    private static GMSSLHttpResponse getGMSSLHttpResponse(GMSSLHttpClient httpClient, GMSSLHttpRequest request, String method) throws GMSSLHttpException {
        if (method.equals(ReqMethodEnum.GET.name)) {
            return httpClient.get(request);
        }
        if (method.equals(ReqMethodEnum.POST.name)) {
            return httpClient.post(request);
        }
        if (method.equals(ReqMethodEnum.PUT.name)) {
            return httpClient.put(request);
        }
        if (method.equals(ReqMethodEnum.DELETE.name)) {
            return httpClient.delete(request);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u6cd5");
    }
}

