/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.util.Enumeration;
import javax.crypto.Cipher;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;

public class SignUtils {
    public static String sign(String algName, PrivateKey key, String source) {
        try {
            Signature signature = Signature.getInstance(algName, "BC");
            signature.initSign(key);
            signature.update(source.getBytes());
            return new String(Base64.encode((byte[])signature.sign()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public static boolean verify(String algName, PublicKey key, String source, String sign) throws Exception {
        Signature signature = Signature.getInstance(algName, "BC");
        signature.initVerify(key);
        signature.update(source.getBytes());
        return signature.verify(Base64.decode((byte[])sign.getBytes()));
    }

    public static String encryption(String algName, Key key, String source) throws Exception {
        Cipher cipher = Cipher.getInstance(algName, "BC");
        cipher.init(1, key);
        byte[] result = cipher.doFinal(source.getBytes());
        return new String(Base64.encode((byte[])result));
    }

    public static String hash(int algName, String source) throws Exception {
        SM3Digest digest = null;
        switch (algName) {
            case 1: {
                digest = new SM3Digest();
                break;
            }
            case 2: {
                digest = new SHA1Digest();
                break;
            }
            case 3: {
                digest = new SHA256Digest();
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684hash\u7b97\u6cd5id:" + algName);
            }
        }
        byte[] data = source.getBytes();
        digest.update(data, 0, data.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return new String(Base64.encode((byte[])result));
    }

    public static PrivateKey getPrivateKey(String path) throws Exception {
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        PEMParser pemParser = new PEMParser((Reader)new FileReader(path));
        Object object = pemParser.readObject();
        pemParser.close();
        PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(null);
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        KeyPair kp = object instanceof PEMEncryptedKeyPair ? converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv)) : converter.getKeyPair((PEMKeyPair)object);
        return kp.getPrivate();
    }

    public static PrivateKey getPrivateKeyFromP12(String path, char[] password) throws Exception {
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        keyStore.load(new FileInputStream(path), password);
        Enumeration<String> aliases = keyStore.aliases();
        PrivateKey key = null;
        while (aliases.hasMoreElements()) {
            String name = aliases.nextElement();
            key = (PrivateKey)keyStore.getKey(name, password);
            if (null == key) continue;
            return key;
        }
        throw new RuntimeException("\u89e3\u6790pfx\u6587\u4ef6\u5931\u8d25");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

