/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.ra.utils.RFC4519StyleUpperCase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtils {
    private static Logger logger = LoggerFactory.getLogger(CertUtils.class);
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";
    public static final String PUBLIC_KEY_HEAD = "-----BEGIN PUBLIC KEY-----";
    public static final String PUBLIC_KEY_TAIL = "-----END PUBLIC KEY-----";
    private static String provider;

    public static X509Certificate getCertFromStr(String str) {
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        X509Certificate x509Cert = CertUtils.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = CertUtils.getCertFromNormalStr(str);
        }
        if (x509Cert == null) {
            x509Cert = CertUtils.getCertFromStr16(str);
        }
        return x509Cert;
    }

    private static synchronized X509Certificate getCertFromB64(String b64) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", provider);
            byte[] bsCert = Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    private static synchronized X509Certificate getCertFromStr16(String str) {
        byte[] bs = CertUtils.hex2byte(str);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", provider);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || str.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static synchronized X509Certificate getCertFromNormalStr(String str) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", provider);
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static PublicKey convertSM2PublicKey(String base64) throws Exception {
        base64 = base64.replace(PUBLIC_KEY_HEAD, "").replace(PUBLIC_KEY_TAIL, "");
        base64 = base64.replace("\r", "").replace("\n", "");
        base64 = base64.replace("\\r", "").replace("\\n", "");
        int digestLen = 32;
        byte[] b = Base64.decode((String)base64);
        byte[] x = new byte[digestLen];
        System.arraycopy(b, 1, x, 0, digestLen);
        byte[] y = new byte[digestLen];
        System.arraycopy(b, digestLen + 1, y, 0, digestLen);
        return CertUtils.convertSM2PublicKey(x, y);
    }

    public static PublicKey convertSM2PublicKey(byte[] x, byte[] y) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)GMSSLX509Utils.ECC_SM2_NAME);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(curve.createPoint(BigIntegers.fromUnsignedByteArray((byte[])x), BigIntegers.fromUnsignedByteArray((byte[])y)), (ECParameterSpec)ecParameterSpec);
        System.out.println("==========" + ecPublicKeySpec.getClass().getName().toString());
        return new BCECPublicKey(GMSSLX509Utils.ECC_SM2_NAME, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static List<X509Certificate> getCertListFromB64(byte[] info) {
        CertificateFactory cf = null;
        List certificates = null;
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(info);
            cf = CertificateFactory.getInstance("X.509", "BC");
            certificates = (List)cf.generateCertificates(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (certificates.size() != 0 && null != certificates) {
            certificates = CertUtils.sortCerts(certificates);
            return certificates;
        }
        String str = new String(info);
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        str = str.replace("\\r", "").replace("\\n", "");
        try {
            byte[] certByte = Base64.decode((String)str);
            if (certByte == null || certByte.length == 0) {
                certByte = CertUtils.hex2byte(str);
            }
            ByteArrayInputStream inStream = new ByteArrayInputStream(certByte);
            certificates = (List)cf.generateCertificates(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != certificates && certificates.size() != 0) {
            certificates = CertUtils.sortCerts(certificates);
            return certificates;
        }
        return certificates;
    }

    public static List<java.security.cert.Certificate> getSortCertListFromB64(String b64P7b) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.decode((String)b64P7b);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            List certificates = (List)cf.generateCertificates(inStream);
            Iterator it = certificates.iterator();
            ArrayList<java.security.cert.Certificate> list = new ArrayList();
            while (it.hasNext()) {
                java.security.cert.Certificate elem = (java.security.cert.Certificate)it.next();
                list.add(elem);
            }
            list = CertUtils.sortCerts(list);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List sortCerts(List certs) {
        int i;
        if (certs.size() < 2) {
            return certs;
        }
        X500Principal issuer = ((X509Certificate)certs.get(0)).getIssuerX500Principal();
        boolean okay = true;
        for (int i2 = 1; i2 != certs.size(); ++i2) {
            X509Certificate cert = (X509Certificate)certs.get(i2);
            if (!issuer.equals(cert.getSubjectX500Principal())) {
                okay = false;
                break;
            }
            issuer = ((X509Certificate)certs.get(i2)).getIssuerX500Principal();
        }
        if (okay) {
            return certs;
        }
        ArrayList<X509Certificate> retList = new ArrayList<X509Certificate>(certs.size());
        ArrayList orig = new ArrayList(certs);
        for (i = 0; i < certs.size(); ++i) {
            X509Certificate cert = (X509Certificate)certs.get(i);
            boolean found = false;
            X500Principal subject = cert.getSubjectX500Principal();
            for (int j = 0; j != certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!c.getIssuerX500Principal().equals(subject)) continue;
                found = true;
                break;
            }
            if (found) continue;
            retList.add(cert);
            certs.remove(i);
        }
        block3: for (i = 0; i != retList.size(); ++i) {
            issuer = ((X509Certificate)retList.get(i)).getIssuerX500Principal();
            for (int j = 0; j < certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!issuer.equals(c.getSubjectX500Principal())) continue;
                retList.add(c);
                certs.remove(j);
                continue block3;
            }
        }
        if (certs.size() > 0) {
            return orig;
        }
        return retList;
    }

    public static final boolean verifyCertIssueCa(String userCert, String caCert) {
        X509Certificate userCert1 = CertUtils.getCertFromStr(userCert);
        X509Certificate caCert1 = CertUtils.getCertFromStr(caCert);
        try {
            userCert1.verify(caCert1.getPublicKey());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static List<X509Certificate> getCertListFromP7b(byte[] bytes) {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        try {
            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)bytes);
            ContentInfo contentInfo = new ContentInfo(asn1Sequence);
            SignedData instance = SignedData.getInstance((Object)contentInfo.getContent());
            ASN1Set instanceCertificates = instance.getCertificates();
            Enumeration objects = instanceCertificates.getObjects();
            while (objects.hasMoreElements()) {
                ASN1Encodable o = (ASN1Encodable)objects.nextElement();
                ASN1InputStream inStream = new ASN1InputStream(o.toASN1Primitive().getEncoded());
                CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
                X509Certificate certificate = (X509Certificate)cf.generateCertificate((InputStream)inStream);
                list.add(certificate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        List sortCerts = CertUtils.sortCerts(list);
        return sortCerts;
    }

    public static X509Certificate convertUploadFileToCert(byte[] certder) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(certder);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != x509Cert) {
            return x509Cert;
        }
        String str = new String(certder);
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        x509Cert = CertUtils.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = CertUtils.getCertFromStr16(str);
        }
        return x509Cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMPCertificate[] getCMPCert(java.security.cert.Certificate cert) throws CertificateEncodingException, IOException {
        try (ASN1InputStream ins = new ASN1InputStream(cert.getEncoded());){
            CMPCertificate[] res;
            ASN1Primitive pcert = ins.readObject();
            Certificate c = Certificate.getInstance((Object)pcert.toASN1Primitive());
            CMPCertificate[] cMPCertificateArray = res = new CMPCertificate[]{new CMPCertificate(c)};
            return cMPCertificateArray;
        }
    }

    public static String writeObject(Object obj) throws Exception {
        StringWriter stringWriter = new StringWriter();
        GMSSLX509Utils.writePEM((Object)obj, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String getSubjectByX509Cert(X509Certificate x509Certificate) throws NamingException {
        X500Name x500Name;
        try {
            byte[] encoded = x509Certificate.getTBSCertificate();
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)encoded);
            int seqStart = 0;
            if (!(seq.getObjectAt(0) instanceof ASN1TaggedObject)) {
                seqStart = -1;
            }
            ASN1Encodable objectAt = seq.getObjectAt(seqStart + 5);
            x500Name = X500Name.getInstance((X500NameStyle)RFC4519StyleUpperCase.INSTANCE, (Object)objectAt.toASN1Primitive());
        }
        catch (CertificateEncodingException e) {
            logger.error("\u4ecex509\u8bc1\u4e66\u4e2d\u83b7\u53d6\u4f7f\u7528\u8005DN\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return x500Name.toString();
    }

    public static byte[] writeObjectToByteArray(X509Certificate certificate) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        GMSSLX509Utils.writePEM((Object)certificate, (Writer)outputStreamWriter);
        return byteArrayOutputStream.toByteArray();
    }

    public static int getPublicKeyLength(byte[] base64CertBytes) throws Exception {
        X509Certificate certificate = CertUtils.getCertFromStr(new String(base64CertBytes));
        PublicKey publicKey = certificate.getPublicKey();
        KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
        String algorithm = certificate.getPublicKey().getAlgorithm();
        if ("RSA".equalsIgnoreCase(algorithm)) {
            RSAPublicKeySpec keySpec = keyFactory.getKeySpec(certificate.getPublicKey(), RSAPublicKeySpec.class);
            BigInteger modulus = keySpec.getModulus();
            return modulus.bitLength();
        }
        if ("EC".equalsIgnoreCase(algorithm)) {
            return 256;
        }
        throw new Exception();
    }

    public static int getPublicKeyLength(X509Certificate certificate) throws Exception {
        byte[] bytes = CertUtils.writeObjectToByteArray(certificate);
        int publicKeyLength = CertUtils.getPublicKeyLength(bytes);
        return publicKeyLength;
    }

    static {
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        provider = bouncyCastleProvider.getName();
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

