package com.xdja.ra.ennum;

/**
 * @author: ggp
 * @Date: 2019/10/31 15:04
 * @Description:
 */
public enum PersonUserTypeEnum {

        IDENTITY_CARD(1, "身份证"),

        OFFICIAL_CARD(2, "军官证"),

        PASSPORT(3, "护照"),

        OTHER(4,"其他");

        public int id;
        public String value;

    PersonUserTypeEnum(int id, String value) {
            this.id = id;
            this.value = value;
        }

        public static String getValueFromId(int id) {
            for (PersonUserTypeEnum t : PersonUserTypeEnum.values()) {
                if (t.id == id) {
                    return t.value;
                }
            }
            throw new IllegalArgumentException(String.format("PersonUserTypeEnum 枚举转换异常[id=%d]", id));
        }


}
