package com.xdja.ra.utils;

import com.xdja.ra.bean.Config;
import com.xdja.ra.bean.ConfigException;
import com.xdja.ra.bean.JSONException;
import com.xdja.ra.constant.Constants;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;

import java.io.File;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;

/**
 * @author: ggp
 * @Date: 2019/11/1 15:47
 * @Description:
 */
public class ConfigUtils {
    /**
     * 如果文件不存在，创建文件
     */
    static {
        try {
            File file = new File(Constants.CONFIG_PATH);
            if (!file.getParentFile().exists()) {
                boolean mkdir = file.getParentFile().mkdirs();
                boolean mk_file = file.createNewFile();
                if (!mkdir || !mk_file) {
                    throw new IOException("创建文件失败");
                }
            }
        } catch (IOException e) {
            throw new RuntimeException("创建文件失败，文件路径：" + Constants.CONFIG_PATH);
        }
    }

    /**
     * 获取RA服务IP地址
     *
     * @return
     * @throws ConfigException
     */
    public static String getServerIp() throws ConfigException {
        Config config = getConfig();
        return config.getServerIp();
    }

    /**
     * 配置RA服务IP地址
     *
     * @param serverIp
     * @throws ConfigException
     */
    public static void setServerIp(String serverIp) throws ConfigException {
        Config config = getConfig();
        config.setServerIp(serverIp);
        setConfig(config);
    }

    /**
     * 获取RA服务端口号
     *
     * @return
     * @throws ConfigException
     */
    public static String getServerPort() throws ConfigException {
        Config config = getConfig();
        return config.getServerPort();
    }

    /**
     * 配置RA服务端口号
     *
     * @param serverPort
     * @throws ConfigException
     */
    public static void setServerPort(String serverPort) throws ConfigException {
        Config config = getConfig();
        config.setServerPort(serverPort);
        setConfig(config);
    }

    /**
     * 获取私钥文件路径
     *
     * @return
     * @throws ConfigException
     */
    public static String getPriKeyPath() throws ConfigException {
        Config config = getConfig();
        return config.getPrikeyPath();
    }

    /**
     * 配置私钥文件路径
     *
     * @param priKeyPath
     * @throws ConfigException
     */
    public static void setPriKeyPath(String priKeyPath) throws ConfigException {
        Config config = getConfig();
        config.setPrikeyPath(priKeyPath);
        setConfig(config);
    }

    /**
     * 获取私钥文件机密口令
     *
     * @return
     * @throws ConfigException
     */
    public static String getPriKeyPwd() throws ConfigException {
        Config config = getConfig();
        return config.getPriKeyPwd();
    }

    /**
     * 配置私钥文件机密口令
     *
     * @param priKeyPwd
     * @throws ConfigException
     */
    public static void setPriKeyPwd(String priKeyPwd) throws ConfigException {
        Config config = getConfig();
        config.setPriKeyPwd(priKeyPwd);
        setConfig(config);
    }

    /**
     * 获取信任证书链路径
     *
     * @return
     * @throws ConfigException
     */
    public static String getTrustCertPath() throws ConfigException {
        Config config = getConfig();
        return config.getTrustCertPath();
    }

    /**
     * 配置信任证书链路径
     *
     * @param trustCertPath
     * @throws ConfigException
     */
    public static void setTrustCertPath(String trustCertPath) throws ConfigException {
        Config config = getConfig();
        config.setTrustCertPath(trustCertPath);
        setConfig(config);
    }

    /**
     * 获取第三方系统唯一标识符
     *
     * @return
     * @throws ConfigException
     */
    public static String getSystemFlag() throws ConfigException {
        Config config = getConfig();
        return config.getSystemFlag();
    }

    /**
     * 配置第三方系统唯一标识符
     *
     * @param systemFlag
     * @throws ConfigException
     */
    public static void setSystemFlag(String systemFlag) throws ConfigException {
        Config config = getConfig();
        config.setSystemFlag(systemFlag);
        setConfig(config);
    }

    /**
     * 保存配置文件
     *
     * @param config
     * @throws Exception
     */
    public static void setConfig(Config config) throws ConfigException {
        if (null == config) {
            throw new IllegalArgumentException("保存config时，config为空");
        }
        try {
            FileUtils.saveFile(JsonMapper.alwaysMapper().toJson(config), Constants.CONFIG_PATH);
        } catch (JSONException e) {
            throw new ConfigException(e);
        }
    }

    /**
     * 读取配置文件
     *
     * @return
     */
    public static Config getConfig() throws ConfigException {
        try {
            String content = FileUtils.read(Constants.CONFIG_PATH);
            if (StringUtils.isBlank(content)) {
                return new Config();
            }
            return JsonMapper.alwaysMapper().fromJson(content, Config.class);
        } catch (Exception e) {
            throw new ConfigException(e);
        }

    }

//    /**
//     * 获取信任证书
//     *
//     * @return
//     * @throws ConfigException
//     */
//    public static X509Certificate[] getTrustCert() throws ConfigException {
//        String trustCertPath = getTrustCertPath();
//        X509Certificate[] caCerts;
//        try {
//            String trustCertP7b = FileUtils.read(trustCertPath);
//            byte[] base64Bytes = Base64.decode(trustCertP7b);
//            List<X509Certificate> certs = CertUtils.getCertListFromP7b(base64Bytes);
//            caCerts = new X509Certificate[certs.size()];
//            for (int i = 0; i < certs.size(); i++) {
//                caCerts[i] = certs.get(i);
//            }
//        } catch (Exception e) {
//            throw new ConfigException(e);
//        }
//
//        return caCerts;
//    }
//
//    /**
//     * 获取系统证书
//     *
//     * @return
//     * @throws ConfigException
//     */
//    public static X509Certificate getNormalCert() throws ConfigException {
//        X509Certificate normalCert;
//        try {
//            normalCert = (X509Certificate) KeyStoreUtils.getPublicKeyFromP12(null, getPriKeyPath(), getPriKeyPwd());
//        } catch (Exception e) {
//            throw new ConfigException(e);
//        }
//
//        return normalCert;
//    }
//
//    /**
//     * 获取系统证书签名算法
//     *
//     * @return
//     * @throws ConfigException
//     */
//    public static String getNormalCertSignAlg() throws ConfigException {
//        X509Certificate normalCert = getNormalCert();
//        return normalCert.getSigAlgName();
//    }
//    /**
//     * 获取系统证书签名算法OID
//     *
//     * @return
//     * @throws ConfigException
//     */
//    public static String getNormalCertSignAlgOid() throws ConfigException {
//        X509Certificate normalCert = getNormalCert();
//        return normalCert.getSigAlgOID();
//    }
//
//    /**
//     * 获取系统签名证书Sn
//     * @return
//     * @throws ConfigException
//     */
//    public static String getUserCertSn() throws ConfigException{
//        X509Certificate userCert = getNormalCert();
//        return userCert.getSerialNumber().toString(16);
//    }
//    /**
//     * 获取系统私钥
//     *
//     * @return
//     * @throws ConfigException
//     */
//    public static PrivateKey getNormalPrivateKey() throws ConfigException {
//        PrivateKey normalPrivateKey;
//        try {
//            normalPrivateKey = SignUtils.getPrivateKeyFromP12(getPriKeyPath(),getPriKeyPwd().toCharArray());
//        } catch (Exception e) {
//            throw new ConfigException(e);
//        }
//
//        return normalPrivateKey;
//    }
//
//    /**
//     * 获取访问RA的baseUrl
//     *
//     * @return
//     * @throws ConfigException
//     */
//    public static String getRaBaseUrl() throws ConfigException {
//        String baseUrl = getServerIp() + ":" + getServerPort() + "/ra-web" ;
//        return baseUrl;
//    }

}