/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.simplestorage;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.security.auth.x500.X500Principal;

public class KeyStoreUtils {
    static final String KEYSTORE_PROVIDER_ANDROID_KEYSTORE = "AndroidKeyStore";
    static final int DEFAULT_KEY_SIZE = 224;
    private static final String mAlias = Process.myUid() + "";
    private static KeyStoreUtils instance;
    private Context context;
    private KeyStore ks;
    private byte[] key;

    private KeyStoreUtils(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        try {
            this.ks = KeyStore.getInstance(KEYSTORE_PROVIDER_ANDROID_KEYSTORE);
            this.ks.load(null);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized byte[] getKey(Context context) {
        return KeyStoreUtils.getInstance(context).getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static KeyStoreUtils getInstance(Context context) {
        if (instance != null) return instance;
        Class<KeyStoreUtils> clazz = KeyStoreUtils.class;
        synchronized (KeyStoreUtils.class) {
            if (instance != null) return instance;
            instance = new KeyStoreUtils(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    byte[] getKey() {
        if (this.key == null) {
            if (!this.isHaveKeyStore()) {
                this.genKey();
            }
            this.key = this.getKeyFromSystem();
        }
        return this.key;
    }

    private synchronized void genKey() {
        try {
            long start = SystemClock.elapsedRealtime();
            this.genKeyPair(this.context);
            long end = SystemClock.elapsedRealtime();
            Log.e((String)"genKey", (String)("gen time: " + (end - start)));
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    private byte[] getKeyFromSystem() {
        try {
            KeyStore.Entry entry = this.ks.getEntry(mAlias, null);
            if (entry == null) {
                return null;
            }
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                return null;
            }
            PublicKey publicKey = this.ks.getCertificate(mAlias).getPublicKey();
            byte[] keyBytes = publicKey.getEncoded();
            return Arrays.copyOfRange(keyBytes, keyBytes.length - 16, keyBytes.length);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableEntryException e) {
            e.printStackTrace();
        }
        return null;
    }

    private KeyPair genKeyPair(Context context) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        KeyGenParameterSpec spec;
        String algorithm;
        if (Build.VERSION.SDK_INT < 23) {
            GregorianCalendar start = new GregorianCalendar();
            GregorianCalendar end = new GregorianCalendar();
            ((Calendar)end).add(1, 10);
            algorithm = "RSA";
            spec = new KeyPairGeneratorSpec.Builder(context).setKeySize(224).setKeyType("EC").setAlias(mAlias).setSubject(new X500Principal("CN=" + mAlias)).setSerialNumber(BigInteger.valueOf(224L)).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
        } else {
            algorithm = "EC";
            spec = new KeyGenParameterSpec.Builder(mAlias, 3).setKeySize(224).setUserAuthenticationRequired(false).setDigests(new String[]{"NONE"}).build();
        }
        KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance(algorithm, KEYSTORE_PROVIDER_ANDROID_KEYSTORE);
        kpGenerator.initialize((AlgorithmParameterSpec)spec);
        KeyPair kp = kpGenerator.generateKeyPair();
        return kp;
    }

    private boolean isHaveKeyStore() {
        try {
            try {
                KeyStore.Entry entry = this.ks.getEntry(mAlias, null);
                if (entry != null) {
                    return true;
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableEntryException e) {
            e.printStackTrace();
        }
        return false;
    }

    private PublicKey getLocalPublicKey() {
        try {
            KeyStore.Entry entry = this.ks.getEntry(mAlias, null);
            if (entry == null) {
                return null;
            }
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                return null;
            }
            PublicKey publicKey = this.ks.getCertificate(mAlias).getPublicKey();
            return publicKey;
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnrecoverableEntryException e) {
            e.printStackTrace();
            return null;
        }
    }
}

