/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.simplestorage;

import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import android.util.Base64;
import com.tencent.mmkv.MMKV;
import com.xdja.simplestorage.KeyStoreUtils;

public class SimpleStorage {
    private Context context;
    private final String name;
    private final boolean encryptFlag;
    private static final String DEFAULT_ENCRYPT_NAME = "_default_encrypt_" + Process.myUid();
    private MMKV mmkv;
    private static boolean initFlag = false;

    private SimpleStorage(Context context, String name, boolean encryptFlag) {
        this.context = context;
        this.name = name;
        this.encryptFlag = encryptFlag;
    }

    public void putString(String key, String value) {
        MMKV mmkv = this.getMmkv();
        mmkv.putString(key, value);
    }

    public void putBytes(String key, byte[] value) {
        MMKV mmkv = this.getMmkv();
        mmkv.putBytes(key, value);
    }

    public void putInt(String key, int value) {
        MMKV mmkv = this.getMmkv();
        mmkv.putInt(key, value);
    }

    public String getString(String key, String defaultValue) {
        MMKV mmkv = this.getMmkv();
        return mmkv.getString(key, defaultValue);
    }

    public byte[] getBytes(String key) {
        MMKV mmkv = this.getMmkv();
        return mmkv.getBytes(key, null);
    }

    public int getInt(String key, int defaultValue) {
        MMKV mmkv = this.getMmkv();
        return mmkv.getInt(key, defaultValue);
    }

    public String[] getAllKey() {
        MMKV mmkv = this.getMmkv();
        return mmkv.allKeys();
    }

    public void remove(String key) {
        MMKV mmkv = this.getMmkv();
        mmkv.remove(key);
    }

    public void removeAll() {
        MMKV mmkv = this.getMmkv();
        mmkv.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MMKV getMmkv() {
        if (this.mmkv != null) {
            return this.mmkv;
        }
        this.init();
        Class<SimpleStorage> clazz = SimpleStorage.class;
        synchronized (SimpleStorage.class) {
            if (!this.encryptFlag) {
                byte[] key = KeyStoreUtils.getKey(this.context);
                String keyStr = Base64.encodeToString((byte[])key, (int)2);
                this.mmkv = TextUtils.isEmpty((CharSequence)this.name) ? MMKV.mmkvWithID((String)DEFAULT_ENCRYPT_NAME, (int)1, (String)keyStr) : MMKV.mmkvWithID((String)this.name, (int)1, (String)keyStr);
            } else {
                this.mmkv = TextUtils.isEmpty((CharSequence)this.name) ? MMKV.defaultMMKV() : MMKV.mmkvWithID((String)this.name);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mmkv;
        }
    }

    private synchronized void init() {
        if (!initFlag) {
            MMKV.initialize((Context)this.context);
        }
    }

    public static class Builder {
        private String name = "";
        private boolean encryptFlag = false;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEncrypt(boolean flag) {
            this.encryptFlag = flag;
            return this;
        }

        public SimpleStorage build(Context context) {
            return new SimpleStorage(context, this.name, this.encryptFlag);
        }
    }
}

