/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process;

import android.os.Bundle;
import android.util.Log;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.multichip.param.ImportCertBean;
import com.xdja.multichip.process.SupperJniApiBinder;
import com.xdja.multichip.utils.ConvertUtil;
import com.xdja.skfapi.EccCipherBlob;
import com.xdja.skfapi.EccPublicKeyBlob;
import com.xdja.skfapi.EnvelopedKeyBlob;
import java.util.Arrays;

public class SuppertImportCert {
    protected Bundle importCert(SupperJniApiBinder binder, Bundle bundle) {
        Bundle result = new Bundle();
        bundle.setClassLoader(ImportCertBean.class.getClassLoader());
        try {
            byte[] signCertFid;
            int[] outLen;
            byte[] out;
            ImportCertBean bean = (ImportCertBean)bundle.getParcelable(ImportCertBean.class.getSimpleName());
            EnvelopedKeyBlob envelopedKey = this.getBean(bean.envelopedKey);
            int ret = binder.VerifyPIN(binder.mHandle, bean.role, bean.pin.getBytes(), bean.pin.length());
            if (ret != 0) {
                result.putInt("ret", ret);
                Log.e((String)"ImportCertLog", (String)("VerifyPin ret = " + ret));
                return result;
            }
            byte[] signPriFid = new byte[]{bean.signPubFid[0], (byte)(bean.signPubFid[1] + 1)};
            byte[] eccCipherBytes = this.getEccCipherBytes(envelopedKey.eccCipherBlob);
            ret = binder.SM2DecryptGM(binder.mHandle, signPriFid, eccCipherBytes, eccCipherBytes.length, out = new byte[eccCipherBytes.length], outLen = new int[1]);
            if (ret != 0) {
                result.putInt("ret", ret);
                Log.e((String)"ImportCertLog", (String)("SM2DecryptGM ret = " + ret));
                return result;
            }
            byte[] cipherKey = Arrays.copyOf(out, outLen[0]);
            byte[] encPriKey = new byte[envelopedKey.cbEncryptedPriKey.length];
            if (envelopedKey.ulSymmAlgID == 257) {
                ret = binder.SM1KEY(binder.mHandle, cipherKey, envelopedKey.cbEncryptedPriKey, envelopedKey.cbEncryptedPriKey.length, 0, encPriKey, null);
                if (ret != 0) {
                    result.putInt("ret", ret);
                    Log.w((String)"ImportCertLog", (String)("SM1KEY ret = " + ret));
                    return result;
                }
            } else if (envelopedKey.ulSymmAlgID == 1025) {
                ret = binder.SM4KEY(binder.mHandle, cipherKey, envelopedKey.cbEncryptedPriKey, envelopedKey.cbEncryptedPriKey.length, 0, encPriKey, null);
                if (ret != 0) {
                    result.putInt("ret", ret);
                    Log.w((String)"ImportCertLog", (String)("SM4KEY ret = " + ret));
                    return result;
                }
            } else {
                result.putInt("ret", -2);
                return result;
            }
            if ((ret = binder.WriteCert(binder.mHandle, signCertFid = new byte[]{bean.signPubFid[0], (byte)(bean.signPubFid[1] - 1)}, bean.signCert, bean.signCert.length)) != 0) {
                result.putInt("ret", ret);
                Log.w((String)"ImportCertLog", (String)("WriteCert signCert ret = " + ret));
                return result;
            }
            byte[] exchangePubFid = new byte[]{bean.signPubFid[0], (byte)(bean.signPubFid[1] - 3)};
            XDJA_SM2_PUBKEY pubKey = new XDJA_SM2_PUBKEY();
            System.arraycopy(envelopedKey.pubKey.xCoordinate, 32, pubKey.x, 0, pubKey.x.length);
            System.arraycopy(envelopedKey.pubKey.yCoordinate, 32, pubKey.y, 0, pubKey.y.length);
            ret = binder.WriteSm2PubKey(binder.mHandle, exchangePubFid, pubKey);
            if (ret != 0) {
                result.putInt("ret", ret);
                Log.w((String)"ImportCertLog", (String)("WriteSm2PubKey ret = " + ret));
                return result;
            }
            byte[] exchangePriFid = new byte[]{bean.signPubFid[0], (byte)(bean.signPubFid[1] - 2)};
            XDJA_SM2_PRIKEY priKey = new XDJA_SM2_PRIKEY();
            System.arraycopy(encPriKey, 32, priKey.d, 0, priKey.d.length);
            ret = binder.WriteSm2PriKey(binder.mHandle, exchangePriFid, priKey);
            if (ret != 0) {
                result.putInt("ret", ret);
                Log.w((String)"ImportCertLog", (String)("WriteSm2PriKey ret = " + ret));
                return result;
            }
            byte[] exchangeCertFid = new byte[]{bean.signPubFid[0], (byte)(bean.signPubFid[1] - 4)};
            ret = binder.WriteCert(binder.mHandle, exchangeCertFid, bean.encCert, bean.encCert.length);
            if (ret != 0) {
                result.putInt("ret", ret);
                Log.w((String)"ImportCertLog", (String)("WriteCert encCert ret = " + ret));
                return result;
            }
            result.putInt("ret", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.putInt("ret", -101);
        }
        return result;
    }

    private EnvelopedKeyBlob getBean(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        EnvelopedKeyBlob envelopedKey = new EnvelopedKeyBlob();
        int start = 0;
        int len = 4;
        envelopedKey.version = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = 4;
        envelopedKey.ulSymmAlgID = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = 4;
        envelopedKey.ulBits = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = 64;
        envelopedKey.cbEncryptedPriKey = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 132;
        envelopedKey.pubKey = this.getEccPublicKeyBlob(Arrays.copyOfRange(bytes, start, start + len));
        int tmpStart = start + len + 64 + 64 + 32;
        int tmpLen = 4;
        int eccCipherLen = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, tmpStart, tmpStart + tmpLen));
        start += len;
        len = 164 + eccCipherLen;
        envelopedKey.eccCipherBlob = this.getEccCipherBlob(Arrays.copyOfRange(bytes, start, start + len));
        return envelopedKey;
    }

    private EccPublicKeyBlob getEccPublicKeyBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        EccPublicKeyBlob eccPublicKeyBlob = new EccPublicKeyBlob();
        int start = 0;
        int len = 4;
        eccPublicKeyBlob.bitLen = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = 64;
        eccPublicKeyBlob.xCoordinate = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 64;
        eccPublicKeyBlob.yCoordinate = Arrays.copyOfRange(bytes, start, start + len);
        return eccPublicKeyBlob;
    }

    private EccCipherBlob getEccCipherBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        EccCipherBlob eccCipher = new EccCipherBlob();
        int start = 0;
        int len = 64;
        eccCipher.xXCoordinate = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 64;
        eccCipher.yCoordinate = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 32;
        eccCipher.hash = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 4;
        eccCipher.cipherLen = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = eccCipher.cipherLen;
        byte[] tmp = Arrays.copyOfRange(bytes, start, start + len);
        eccCipher.cipher = new byte[len];
        System.arraycopy(tmp, 0, eccCipher.cipher, 0, len);
        return eccCipher;
    }

    private byte[] getEccCipherBytes(EccCipherBlob eccCipher) {
        if (eccCipher == null) {
            return null;
        }
        int len = eccCipher.xXCoordinate.length / 2 + eccCipher.yCoordinate.length / 2 + eccCipher.hash.length + 4 + eccCipher.cipherLen;
        byte[] result = new byte[len];
        int start = 0;
        len = eccCipher.xXCoordinate.length / 2;
        System.arraycopy(eccCipher.xXCoordinate, len, result, start, len);
        start += len;
        len = eccCipher.yCoordinate.length / 2;
        System.arraycopy(eccCipher.yCoordinate, len, result, start, len);
        start += len;
        len = eccCipher.hash.length;
        System.arraycopy(eccCipher.hash, 0, result, start, len);
        start += len;
        len = 4;
        System.arraycopy(ConvertUtil.intToBytes(eccCipher.cipherLen), 0, result, start, len);
        start += len;
        len = eccCipher.cipher.length;
        System.arraycopy(eccCipher.cipher, 0, result, start, len);
        return result;
    }
}

