/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cc;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.taisys.model.Card;
import com.xdja.cc.BaseCard;
import com.xdja.cc.SM3Digest;
import com.xdja.cc.Sm4;
import com.xdja.cc.Util;
import com.xdja.cc.XDJA_DEVINFO;
import com.xdja.cc.XDJA_FILE;
import com.xdja.cc.XDJA_RSA_PRIKEY;
import com.xdja.cc.XDJA_RSA_PUBKEY;
import com.xdja.cc.XDJA_SM2_PARAM;
import com.xdja.cc.XDJA_SM2_PRIKEY;
import com.xdja.cc.XDJA_SM2_PUBKEY;
import com.xdja.cssp.sm2cipher.ec.NamedEllipse;
import com.xdja.cssp.sm2cipher.sm2.cipher.ECSM2Signer;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM2Encrypt;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CoverCard
extends BaseCard {
    private Application mApplication;
    private int mInitStatus;
    private int mReadSm1KeyStatu;
    private int mReadSm4KeyStatu;
    byte[] key;
    private static Lock mLock;
    private static final int PZ = 237;
    public static final int SM2_ENC_MAX_LENGTH = 148;
    public static final int SM2_DEC_MAX_LENGTH = 245;
    public static final int SIGN_HASH = 0;
    public static final int SIGN_NOHASH = 1;

    public native int CryptSmEcbEncrypt(byte[] var1, byte[] var2, int var3, byte[] var4);

    public native int CryptSmEcbDecrypt(byte[] var1, byte[] var2, int var3, byte[] var4);

    public native int CryptSmCbcEncrypt(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    public native int CryptSmCbcDecrypt(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5);

    private Application getApplication() {
        try {
            Class<?> cls = Class.forName("android.app.ActivityThread");
            Method mid = cls.getMethod("currentApplication", new Class[0]);
            Application app = (Application)mid.invoke(cls, new Object[0]);
            return app;
        }
        catch (NoSuchMethodException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        catch (ClassNotFoundException e4) {
            e4.printStackTrace();
        }
        catch (InvocationTargetException e5) {
            e5.printStackTrace();
        }
        return null;
    }

    public CoverCard() {
        this.onCreate();
        this.mReadSm1KeyStatu = 0;
        this.mReadSm4KeyStatu = 0;
    }

    private synchronized void onCreate() {
        this.mApplication = this.getApplication();
        if (mLock == null) {
            mLock = new ReentrantLock();
        }
    }

    public CoverCard(Card cc) {
        super(cc);
        this.onCreate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SendAPDU(byte[] send, int slen, byte[] recv, int[] rlen) {
        if (send == null || slen <= 0 || recv == null) {
            return -12;
        }
        String data = new String(send, 0, slen);
        mLock.lock();
        try {
            Log.d((String)"CoverCard", (String)("send [" + data + "]"));
            String reply = this.mcc.SendAPDU(data);
            Log.d((String)"CoverCard", (String)("recv [" + reply + "]"));
            if (reply == null || reply.isEmpty()) {
                int n = -100;
                return n;
            }
            if (recv.length < reply.length()) {
                int n = -12;
                return n;
            }
            System.arraycopy(reply.getBytes(), 0, recv, 0, reply.length());
            rlen[0] = reply.length();
            int n = 0;
            return n;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -100;
    }

    public void SetLogFlag(boolean flag) {
        this.mcc.setPrintLog(flag);
    }

    public String GetOtiType() {
        return this.mcc.getOtiType();
    }

    public int GetInitStatus() {
        return this.mInitStatus;
    }

    public void OpenSEService() throws InterruptedException {
        Card.SCSupported supported = new Card.SCSupported(){

            @Override
            public void isSupported(boolean b2) {
                CoverCard.this.mInitStatus = 2;
                Log.i((String)"CoverCard", (String)("SCSupported->isSupported = " + b2 + " mInitStatus = " + CoverCard.this.mInitStatus));
                Log.i((String)"CoverCard", (String)("current time : " + System.currentTimeMillis()));
            }
        };
        this.mInitStatus = 0;
        Log.i((String)"CoverCard", (String)("before mInitStatus = " + this.mInitStatus));
        Context context = this.mApplication.getApplicationContext();
        this.mcc.OpenSEService(context, supported);
        this.mInitStatus = 1;
        Log.i((String)"CoverCard", (String)("after mInitStatus = " + this.mInitStatus));
    }

    public void OpenSEService(Context context) throws InterruptedException {
        Card.SCSupported supported = new Card.SCSupported(){

            @Override
            public void isSupported(boolean b2) {
                Log.i((String)"CoverCard", (String)("SCSupported->isSupported = " + b2));
                Log.i((String)"CoverCard", (String)("current time : " + System.currentTimeMillis()));
            }
        };
        this.mcc.OpenSEService(context, supported);
    }

    public void OpenSEService(Context context, Card.SCSupported supported) {
        this.mcc.OpenSEService(context, supported);
    }

    public void CloseSEService() {
        mLock.lock();
        try {
            this.mcc.CloseSEService();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int VerifyPIN(int role, byte[] pin, int len) {
        byte[] psw = this.check_and_gen_password(pin, len);
        if (psw == null) {
            Log.e((String)"CoverCard", (String)"[erro] VerifyPIN: illegal pin format");
            return -12;
        }
        mLock.lock();
        try {
            int n = this.mcc.VerifyPIN(role, psw);
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetPINTryCount(int role) {
        String icmd = String.format("B01D01%02X00", role);
        mLock.lock();
        try {
            String recv = this.mcc.SendAPDU(icmd);
            int n = this.HandleApduErrCode(recv);
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] GetPinTryCount dumps[" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -100;
    }

    private byte[] check_and_gen_password(byte[] pin, int len) {
        if (pin == null || pin.length < 6 || len < 6 || len > 16 || len > pin.length) {
            return null;
        }
        if (len == pin.length) {
            return pin;
        }
        byte[] loc = new byte[len];
        System.arraycopy(pin, 0, loc, 0, len);
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ChangePIN(int role, byte[] oldPIN, int oldLEN, byte[] newPIN, int newLEN) {
        byte[] o = this.check_and_gen_password(oldPIN, oldLEN);
        byte[] n = this.check_and_gen_password(newPIN, newLEN);
        if (o == null) {
            Log.e((String)"CoverCard", (String)"[erro] VerifyPIN: illegal oldPIN format");
            return -12;
        }
        if (n == null) {
            Log.e((String)"CoverCard", (String)"[erro] VerifyPIN: illegal newPIN format");
            return -12;
        }
        mLock.lock();
        try {
            int n2 = this.mcc.ChangePIN(role, o, n);
            return n2;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int UnlockPIN(int pukId, byte[] puk, int pukLen, byte[] pin, int pinLen) {
        if (pukLen != 8 || puk.length < 8) {
            Log.e((String)"CoverCard", (String)"[erro] UnlockPIN: invalid parameter, illegal puk length");
            return -12;
        }
        byte[] PUK = this.check_and_gen_password(puk, pukLen);
        if (PUK == null) {
            Log.e((String)"CoverCard", (String)"[erro] UnlockPIN: invalid parameter, illegal puk");
            return -12;
        }
        byte[] psd = this.check_and_gen_password(pin, pinLen);
        if (psd == null) {
            Log.e((String)"CoverCard", (String)"[erro] VerifyPIN: illegal pin format");
            return -12;
        }
        mLock.lock();
        try {
            int n = this.mcc.UnlockPIN(pukId, PUK, psd);
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSingleRandom(int len, byte[] arr) {
        String icmd = String.format("B0120000%02x", len & 0xFF);
        mLock.lock();
        try {
            String recv = this.mcc.SendAPDU(icmd);
            String code = this.getCode(recv);
            int r = this.HandleApduErrCode(code);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] getSingleRandom: SendApud recv[" + recv + "]"));
                int n = r;
                return n;
            }
            int size = recv.length() - code.length();
            String data = recv.substring(0, size);
            if (len * 2 != size) {
                Log.e((String)"CoverCard", (String)String.format("[erro] getSingleRandom: len[%d], data[%d][%s]", len, size, recv.substring(0, size)));
                int n = -100;
                return n;
            }
            Util.Str2Byte(data, arr, null);
            int n = r;
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] getSingleRandom dumps [" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -100;
    }

    public int GenRandom(int len, byte[] arr) {
        if (len == 0) {
            return 0;
        }
        if (arr == null || arr.length < len) {
            Log.e((String)"CoverCard", (String)"[erro] GenRandom: invalid parameter, arr");
            return -12;
        }
        int oncel = 0;
        for (int total = 0; total < len; total += oncel) {
            byte[] onceb;
            int r;
            oncel = len - total;
            if (oncel > 128) {
                oncel = 128;
            }
            if ((r = this.getSingleRandom(oncel, onceb = new byte[oncel])) != 0) {
                Log.e((String)"CoverCard", (String)("[erro] GenRandom: getSingleRandom [" + r + "]"));
                return r;
            }
            System.arraycopy(onceb, 0, arr, total, oncel);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetDevInfo(XDJA_DEVINFO dev) {
        if (dev == null) {
            Log.e((String)"CoverCard", (String)"[erro] GetDevInfo: dev should not be null.");
            return -12;
        }
        mLock.lock();
        try {
            String icmd = "B010000000";
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("recv -> [" + recv + "]"));
            String code = this.getCode(recv);
            int r = this.HandleApduErrCode(code);
            if (r == 0) {
                int size = recv.length() - code.length();
                dev.trans(recv.substring(0, size));
            }
            int n = r;
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)"[erro] GetDevInfo catch exceptin.");
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int CreateFile(XDJA_FILE file) {
        if (file == null) {
            Log.e((String)"CoverCard", (String)"[erro] CreateFile: invalid parameter, file should not be null.");
            return -12;
        }
        String icmd = "b0e00000" + file.toApduData();
        int ret = -100;
        mLock.lock();
        try {
            String recv = this.mcc.SendAPDU(icmd);
            ret = this.HandleApduErrCode(recv);
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] CreateFile: " + e2.getStackTrace()));
            int n = -2;
            return n;
        }
        finally {
            mLock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int DeleteFile(byte[] id) {
        if (id == null || id.length < 2) {
            Log.e((String)"CoverCard", (String)"[erro] DeleteFile: invalid parameter, id");
            return -12;
        }
        String icmd = String.format("B004000002%02x%02x", id[0], id[1]);
        mLock.lock();
        try {
            Log.i((String)"CoverCard", (String)("[info] DeleteFile send [" + icmd + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("[info] DeleteFile recv [" + recv + "]"));
            int n = this.HandleApduErrCode(recv);
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] DeleteFile dumps[" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetFileInfo(byte[] id, XDJA_FILE file) {
        if (id == null || id.length < 2 || file == null) {
            Log.e((String)"CoverCard", (String)"[erro] GetFileInfo: invalid parameter, id");
            return -12;
        }
        String icmd = String.format("B0B1%02X%02X%02X", id[0] & 0xFF, id[1] & 0xFF, XDJA_FILE.size() & 0xFF);
        mLock.lock();
        try {
            String recv = this.mcc.SendAPDU(icmd);
            if (recv.length() < 4) {
                Log.e((String)"CoverCard", (String)("[erro] GetFileInfo response[" + recv + "]"));
                int n = -100;
                return n;
            }
            String body = recv.substring(0, recv.length() - 4);
            String resp = recv.substring(recv.length() - 4);
            int err = this.HandleApduErrCode(resp);
            if (err == 0) {
                file.parse(body);
            }
            int n = err;
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] GetFileInfo dumps[" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -2;
    }

    public int SelectFile(byte[] fid) {
        mLock.lock();
        try {
            int n = this.__SelectFile(fid);
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    private int __SelectFile(byte[] fid) {
        if (fid == null || fid.length < 2) {
            Log.e((String)"CoverCard", (String)"[erro] SelectFile: invalid parameter, fid");
            return -12;
        }
        String data = String.format("%02x%02x", fid[0] & 0xFF, fid[1] & 0xFF);
        String icmd = "B0A4000C02" + data;
        try {
            String recv = this.mcc.SendAPDU(icmd);
            return this.HandleApduErrCode(recv);
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("SelectFile catch an exception [" + e2.getMessage() + "]"));
            e2.printStackTrace();
            return -2;
        }
    }

    private int SingleReadFile(byte[] fid, int pos, int rlen, byte[] out) {
        String p12 = String.format("%04x", pos & 0xFFFF);
        String p3 = String.format("%02x", rlen);
        String icmd = "B0B0" + p12 + p3;
        Log.i((String)"CoverCard", (String)("SingleReadFile[" + icmd + "]"));
        try {
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("[info]SingleReadFile[" + recv + "]"));
            String code = this.getCode(recv);
            int r = this.HandleApduErrCode(code);
            if (r == 0) {
                String data = recv.substring(0, recv.length() - code.length());
                int[] riz = new int[]{0};
                Log.i((String)"CoverCard", (String)("[info] SingleReadFile " + String.format("rlen %d, riz %d", rlen, riz[0])));
                if (data.length() / 2 < rlen) {
                    Log.e((String)"CoverCard", (String)String.format("[erro] SingleReadFile: data size: request [%d], reply [%d]", rlen, riz[0]));
                    return -42;
                }
                Util.Str2Byte(data, out, riz);
            }
            return r <= 0 ? r : -42;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] SingleReadFile exception[" + e2.getMessage() + "]"));
            e2.printStackTrace();
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadFile(byte[] fid, int pos, int rlen, byte[] out) {
        mLock.lock();
        try {
            int r = this.__SelectFile(fid);
            if (r != 0) {
                int n = r;
                return n;
            }
            int n = this.__ReadFile(fid, pos, rlen, out);
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    private int __ReadFile(byte[] fid, int pos, int rlen, byte[] out) {
        int oncel;
        if (fid == null || fid.length < 2) {
            Log.e((String)"CoverCard", (String)"[erro] WriteFile: invalid parameter, fid");
            return -12;
        }
        if (rlen == 0) {
            return 0;
        }
        if (out == null || out.length < rlen) {
            Log.e((String)"CoverCard", (String)"[erro] ReadFile: invalid parameter, out");
            return -12;
        }
        for (int total = 0; total < rlen; total += oncel) {
            byte[] onceb;
            int offset;
            int r;
            oncel = rlen - total;
            if (oncel > 128) {
                oncel = 128;
            }
            if ((r = this.SingleReadFile(fid, offset = pos + total, oncel, onceb = new byte[oncel])) != 0) {
                Log.e((String)"CoverCard", (String)("[erro] ReadFile [" + r + "]"));
                return r;
            }
            System.arraycopy(onceb, 0, out, total, oncel);
        }
        return 0;
    }

    private int SingleWriteFile(byte[] id, int pos, int wlen, byte[] data) {
        String cla = "B0";
        String ins = "D6";
        String p12 = String.format("%04x", pos);
        String p3 = String.format("%02x", wlen & 0xFF);
        StringBuilder builder = new StringBuilder("");
        for (int i2 = 0; i2 < wlen; ++i2) {
            builder.append(String.format("%02x", data[i2]));
        }
        String icmd = cla + ins + p12 + p3 + builder.toString();
        try {
            Log.i((String)"CoverCard", (String)("[info] WriteFile [send][" + icmd + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("[info] WriteFile [recv][" + recv + "]"));
            int r = this.HandleApduErrCode(this.getCode(recv));
            return r <= 0 ? r : -42;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] WriteFile dumps[" + e2.getMessage() + "]"));
            e2.printStackTrace();
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteFile(byte[] id, int pos, int wlen, byte[] data) {
        mLock.lock();
        try {
            int r = this.__SelectFile(id);
            if (r != 0) {
                int n = r;
                return n;
            }
            int n = this.__WriteFile(id, pos, wlen, data);
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    private int __WriteFile(byte[] id, int pos, int wlen, byte[] data) {
        int oncel;
        if (id == null || id.length < 2) {
            Log.e((String)"CoverCard", (String)"[erro] WriteFile: invalid parameter, id");
            return -12;
        }
        if (wlen == 0) {
            return 0;
        }
        if (data == null || data.length < wlen) {
            Log.e((String)"CoverCard", (String)"[erro] WriteFile: invalid parameter, data");
            return -12;
        }
        for (int total = 0; total < wlen; total += oncel) {
            oncel = wlen - total > 128 ? 128 : wlen - total;
            int offset = pos + total;
            byte[] temp = new byte[oncel];
            System.arraycopy(data, total, temp, 0, oncel);
            int r = this.SingleWriteFile(id, offset, oncel, temp);
            if (r == 0) continue;
            Log.e((String)"CoverCard", (String)("[erro] WriteFile [" + r + "]"));
            return r;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadCert(byte[] fid, byte[] cert, int[] certlen) {
        int pos = 0;
        byte[] clen = new byte[4];
        mLock.lock();
        try {
            int r = this.__SelectFile(fid);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] ReadFile: [" + r + "]"));
                int n = r;
                return n;
            }
            r = this.__ReadFile(fid, pos, 4, clen);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)"[erro] ReadCert: read file length error.");
                int n = r;
                return n;
            }
            pos += 4;
            int total = clen[0] << 24 & 0xFF000000 | clen[1] << 16 & 0xFF0000 | clen[2] << 8 & 0xFF00 | clen[3] & 0xFF;
            if (cert.length < total) {
                Log.e((String)"CoverCard", (String)"[erro] ReadCert: cert buffer is too small.");
                int n = -12;
                return n;
            }
            Log.i((String)"CoverCard", (String)String.format("total -> 0x%08x", total));
            r = this.__ReadFile(fid, pos, total, cert);
            if (r == 0 && certlen != null && certlen.length > 0) {
                certlen[0] = total;
            }
            int n = r;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteCert(byte[] fid, byte[] cert, int certlen) {
        if (certlen < 0) {
            return -12;
        }
        if (certlen == 0) {
            return 0;
        }
        if (cert == null || cert.length < certlen) {
            return -12;
        }
        int r = 0;
        int pos = 0;
        byte[] clen = new byte[]{(byte)(certlen >> 24 & 0xFF), (byte)(certlen >> 16 & 0xFF), (byte)(certlen >> 8 & 0xFF), (byte)(certlen & 0xFF)};
        Log.i((String)"CoverCard", (String)String.format("[[[%02x, %02x, %02x, %02x]]]", clen[0], clen[1], clen[2], clen[3]));
        mLock.lock();
        try {
            r = this.__SelectFile(fid);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] ReadFile->[SelectFile][" + r + "]"));
                int n = r;
                return n;
            }
            r = this.__WriteFile(fid, pos, clen.length, clen);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteCert->[write cert length][" + r + "]"));
                int n = r;
                return n;
            }
            r = this.__WriteFile(fid, pos += clen.length, certlen, cert);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteCert->[write cert][" + r + "]"));
            }
            int n = r;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadRsaPubKey(byte[] id, XDJA_RSA_PUBKEY key) {
        if (key == null) {
            Log.e((String)"CoverCard", (String)"[erro] ReadRSAPublicKey: invalid parameter, key should not be null");
            return -12;
        }
        int size = 264;
        byte[] arr = new byte[size];
        mLock.lock();
        try {
            int r = this.__SelectFile(id);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] ReadRSAPublicKey: SelectFile [" + r + "]"));
                int n = r;
                return n;
            }
            r = this.__ReadFile(id, 0, size, arr);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] ReadRSAPublicKey: ReaFile [" + r + "]"));
                int n = r;
                return n;
            }
            key.bits = Util.Byte2Int(arr, 0);
            key.e = Util.Byte2Int(arr, 260);
            System.arraycopy(arr, 4, key.m, 0, 256);
            int n = 0;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteRsaPubKey(byte[] id, XDJA_RSA_PUBKEY key) {
        if (key == null) {
            Log.e((String)"CoverCard", (String)"[erro] WriteRSAPublicKey: invalid key, should not be null.");
            return -12;
        }
        mLock.lock();
        try {
            int r = this.__SelectFile(id);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteRSAPrivateKey: SelectFile + [" + r + "]"));
                int n = r;
                return n;
            }
            int size0 = 264;
            byte[] bits = Util.Int2Byte(key.bits);
            byte[] e2 = Util.Int2Byte(key.e);
            byte[] arr0 = new byte[size0];
            System.arraycopy(bits, 0, arr0, 0, 4);
            System.arraycopy(key.m, 0, arr0, 4, 256);
            System.arraycopy(e2, 0, arr0, size0 - 4, 4);
            r = this.__WriteFile(id, 0, size0, arr0);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteRSAPublicKey: WriteFile [" + r + "]"));
                int n = r;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteRsaPriKey(byte[] id, XDJA_RSA_PRIKEY key) {
        if (key == null) {
            Log.e((String)"CoverCard", (String)"[erro] WriteRSAPrivateKey : invalid key, should not be null.");
            return -12;
        }
        mLock.lock();
        try {
            int r = this.__SelectFile(id);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteRSAPrivateKey : SelectFile [" + r + "]"));
                int n = r;
                return n;
            }
            int size = 644;
            byte[] arr = new byte[size];
            byte[] siz = Util.Int2Byte(key.bits);
            int pos = 0;
            System.arraycopy(siz, 0, arr, pos, 4);
            System.arraycopy(key.p, 0, arr, pos += 4, 128);
            System.arraycopy(key.q, 0, arr, pos += 128, 128);
            System.arraycopy(key.dp, 0, arr, pos += 128, 128);
            System.arraycopy(key.dq, 0, arr, pos += 128, 128);
            System.arraycopy(key.ce, 0, arr, pos += 128, 128);
            r = this.__WriteFile(id, 0, size, arr);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteRSAPrivateKey : WriteFile [" + r + "]"));
                int n = r;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadSm2PubKey(byte[] id, XDJA_SM2_PUBKEY key) {
        if (key == null) {
            Log.e((String)"CoverCard", (String)"[erro] ReadSM2PublicKey: invalid key, should not be null");
            return -12;
        }
        mLock.lock();
        try {
            int r = this.__SelectFile(id);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] ReadSM2PublicKey: SelectFile [" + r + "]"));
                int n = r;
                return n;
            }
            int sm2keylen = 32;
            int siz = sm2keylen * 2;
            byte[] arr = new byte[siz];
            r = this.__ReadFile(id, 0, siz, arr);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] ReadSM2PublicKey : ReadFile [" + r + "]"));
                int n = r;
                return n;
            }
            System.arraycopy(arr, 0, key.x, 0, sm2keylen);
            System.arraycopy(arr, sm2keylen, key.y, 0, sm2keylen);
            int n = 0;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteSm2PubKey(byte[] id, XDJA_SM2_PUBKEY key) {
        if (key == null) {
            Log.e((String)"CoverCard", (String)"[erro] WriteSM2PublicKey: invalid key, should not be null");
            return -12;
        }
        mLock.lock();
        try {
            int r = this.__SelectFile(id);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteSM2PublicKey: SelectFile [" + r + "]"));
                int n = r;
                return n;
            }
            int siz = 64;
            byte[] arr = new byte[siz];
            System.arraycopy(key.x, 0, arr, 0, 32);
            System.arraycopy(key.y, 0, arr, 32, 32);
            r = this.__WriteFile(id, 0, siz, arr);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteSM2PublicKey: WriteFile [" + r + "]"));
                int n = r;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int WriteSm2PriKey(byte[] id, XDJA_SM2_PRIKEY key) {
        if (key == null) {
            Log.e((String)"CoverCard", (String)"[erro] WriteSM2PrivateKey: invalid key, should not be null");
            return -12;
        }
        mLock.lock();
        try {
            int r = this.__SelectFile(id);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteSM2PrivateKey: SelectFile [" + r + "]"));
                int n = r;
                return n;
            }
            int siz = 32;
            r = this.__WriteFile(id, 0, siz, key.d);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("[erro] WriteSM2PrivateKey: WriteFile [" + r + "]"));
                int n = r;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    public int RSA_Calc(byte[] id, byte[] dat, int siz, byte[] cip, int[] ciz, boolean padding) {
        int index;
        if (id == null || id.length < 2) {
            return -12;
        }
        if (dat == null || dat.length < siz) {
            return -12;
        }
        if (ciz == null || ciz.length == 0) {
            return -12;
        }
        if (cip == null) {
            return -12;
        }
        int pad = 1;
        if (padding) {
            pad = 0;
        }
        if (siz <= 237) {
            return this.RSA_Calc_1(id, pad, 0, dat, siz, cip, ciz);
        }
        int times = siz / 237 + 1;
        byte[] once = new byte[237];
        int r = 0;
        System.arraycopy(dat, 0, once, 0, 237);
        r = this.RSA_Calc_1(id, pad, 1, once, 237, cip, ciz);
        if (r != 0) {
            Log.e((String)"CoverCard", (String)String.format("[erro][RSA_Calc] RSA_Calc_1 pad[%d] type[%d] r[%d]", pad, 1, r));
            return r;
        }
        for (index = 1; index < times - 1; ++index) {
            System.arraycopy(dat, 237 * index, once, 0, 237);
            r = this.RSA_Calc_1(null, pad, 2, once, 237, cip, ciz);
            if (r == 0) continue;
            return r;
        }
        int oize = siz - 237 * index;
        System.arraycopy(dat, 237 * index, once, 0, oize);
        return this.RSA_Calc_1(null, pad, 3, once, oize, cip, ciz);
    }

    private int RSA_Calc_1(byte[] id, int pad, int type, byte[] dat, int siz, byte[] cip, int[] ciz) {
        String icmd = "";
        icmd = id != null ? String.format("B017%02X%02X%02X%02X%02X", pad, type, siz + 2, id[0] & 0xFF, id[1] & 0xFF) + Util.Byte2Str(dat, siz) : String.format("B017%02X%02X%02X", pad & 0xFF, type & 0xFF, siz & 0xFF) + Util.Byte2Str(dat, siz);
        try {
            Log.i((String)"CoverCard", (String)("[info][RSA_Calc_1] send[" + icmd + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("[info][RSA_Calc_1] recv[" + recv + "]"));
            String code = this.getCode(recv);
            int r = this.HandleApduErrCode(code);
            if (r == 0) {
                String data = recv.substring(0, recv.length() - code.length());
                Util.Str2Byte(data, cip, ciz);
            }
            return r;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)String.format("[erro][RSA_Calc_1] SendAPDU dumps [%s]", e2.getMessage()));
            e2.printStackTrace();
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RSAPubKeyCalc(byte[] id, int bits, byte[] dat, int siz, byte[] out, int[] oiz) {
        mLock.lock();
        try {
            if (bits != 1024 && bits != 2048) {
                Log.e((String)"CoverCard", (String)("[erro] RSAPublicKey : invalid parameter, bits = " + bits));
                int n = -12;
                return n;
            }
            if (siz != bits / 8) {
                Log.e((String)"CoverCard", (String)("[erro] RSAPubKeyCalc : invalid parameter, siz = " + siz));
                int n = -12;
                return n;
            }
            int n = this.RSA_Calc(id, dat, siz, out, oiz, true);
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RSAPubKeyCalc(XDJA_RSA_PUBKEY pubkey, byte[] dat, int siz, byte[] out, int[] oiz) {
        mLock.lock();
        try {
            if (pubkey.bits != 1024 && pubkey.bits != 2048) {
                Log.e((String)"CoverCard", (String)("[erro] RSAPublicKey : invalid parameter, bits = " + pubkey.bits));
                int n = -12;
                return n;
            }
            if (siz != pubkey.bits / 8) {
                Log.e((String)"CoverCard", (String)("[erro] RSAPubKeyCalc : invalid parameter, siz = " + siz));
                int n = -12;
                return n;
            }
            if (65537 != pubkey.e) {
                Log.e((String)"CoverCard", (String)("[erro] RSAPubKeyCalc : invalid parameter, e = " + pubkey.e));
                int n = -12;
                return n;
            }
            byte[] m = new byte[pubkey.bits / 8];
            byte[] e2 = new byte[]{1, 0, 1};
            System.arraycopy(pubkey.m, 0, m, 0, pubkey.bits / 8);
            PublicKey pk = null;
            BigInteger B1 = new BigInteger(1, m);
            BigInteger B2 = new BigInteger(1, e2);
            RSAPublicKeySpec spec = new RSAPublicKeySpec(B1, B2);
            Cipher cipher = Cipher.getInstance("RSA");
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            pk = keyFactory.generatePublic(spec);
            cipher.init(1, pk);
            byte[] outbuf = cipher.doFinal(dat);
            System.arraycopy(outbuf, 0, out, 0, pubkey.bits / 8);
            oiz[0] = out.length;
        }
        catch (NoSuchPaddingException e3) {
            e3.printStackTrace();
        }
        catch (NoSuchAlgorithmException e4) {
            e4.printStackTrace();
        }
        catch (InvalidKeySpecException e5) {
            e5.printStackTrace();
        }
        catch (BadPaddingException e6) {
            e6.printStackTrace();
        }
        catch (IllegalBlockSizeException e7) {
            e7.printStackTrace();
        }
        catch (InvalidKeyException e8) {
            e8.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RSAPriKeyCalc(byte[] id, int bits, byte[] dat, int siz, byte[] out, int[] oiz) {
        mLock.lock();
        try {
            if (bits != 1024 && bits != 2048) {
                Log.e((String)"CoverCard", (String)("[erro] RSAPublicKey : invalid parameter, bits = " + bits));
                int n = -12;
                return n;
            }
            if (siz != bits / 8) {
                Log.e((String)"CoverCard", (String)("[erro] RSAPubKeyCalc : invalid parameter, siz = " + siz));
                int n = -12;
                return n;
            }
            int n = this.RSA_Calc(id, dat, siz, out, oiz, true);
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    private byte[] SHA1(byte[] dat, int len) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(dat, 0, len);
            return sha1.digest();
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RSASign(byte[] id, int bits, int datatype, byte[] dat, int diz, byte[] sig, int[] siz) {
        if (bits != 1024 && bits != 2048) {
            Log.e((String)"CoverCard", (String)("[erro] RSAPublicKey : invalid parameter, bits = " + bits));
            return -12;
        }
        if (diz <= 0) {
            Log.e((String)"CoverCard", (String)("[erro] RSASign: " + String.format("invalid parameter, siz should above 0,  but diz = %d", diz)));
            return -12;
        }
        byte[] mac = dat;
        int miz = diz;
        if (datatype == 1) {
            mac = this.SHA1(dat, diz);
            if (mac == null) {
                Log.e((String)"CoverCard", (String)"[erro] RSASign: SHA1 error");
                return -100;
            }
            miz = mac.length;
        } else if (datatype == 0) {
            if (miz != 20 || dat.length < miz) {
                Log.e((String)"CoverCard", (String)String.format("[erro] RSASign: invalid dat/diz, datatype %d, dat.length %d, diz %d", datatype, dat.length, diz));
                return -12;
            }
        } else {
            Log.e((String)"CoverCard", (String)("[erro] RSASign: invalid datatype [" + datatype + "]"));
            return -12;
        }
        mLock.lock();
        try {
            int n = this.RSA_Calc(id, mac, miz, sig, siz, false);
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    private void pcks_1_remove_padding(byte[] src, int siz, byte[] des, int[] diz) {
        switch (src[1]) {
            case 0: {
                break;
            }
            case 1: {
                int pos;
                for (pos = 2; pos < siz && (src[pos] & 0xFF) == 255; ++pos) {
                }
                if (pos == siz || src[pos] != 0) break;
                diz[0] = siz - ++pos;
                System.arraycopy(src, pos, des, 0, diz[0]);
                return;
            }
            case 2: {
                break;
            }
        }
        System.arraycopy(src, 0, des, 0, siz);
        diz[0] = siz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RSASignVerify(byte[] id, int bits, int datatype, byte[] dat, int diz, byte[] sig, int siz) {
        int r;
        if (bits != 1024 && bits != 2048) {
            Log.e((String)"CoverCard", (String)("[erro] RSAPublicKey : invalid parameter, bits = " + bits));
            return -12;
        }
        byte[] out = new byte[bits / 8];
        int[] oiz = new int[]{0};
        byte[] data = new byte[bits / 8];
        int[] size = new int[]{0};
        byte[] mac = dat;
        int miz = diz;
        if (datatype == 1) {
            mac = this.SHA1(dat, diz);
            if (mac == null) {
                Log.e((String)"CoverCard", (String)"[erro] RSASign: SHA1 error");
                return -100;
            }
            miz = mac.length;
        } else if (datatype == 0) {
            if (miz != 20 || dat.length < miz) {
                Log.e((String)"CoverCard", (String)String.format("[erro] RSASign: invalid dat/diz, datatype %d, dat.length %d, diz %d", datatype, dat.length, diz));
                return -12;
            }
        } else {
            Log.e((String)"CoverCard", (String)("[erro] RSASign: invalid datatype [" + datatype + "]"));
            return -12;
        }
        mLock.lock();
        try {
            r = this.RSA_Calc(id, sig, siz, out, oiz, true);
        }
        finally {
            mLock.unlock();
        }
        if (r == 0) {
            this.pcks_1_remove_padding(out, oiz[0], data, size);
            if (miz != size[0]) {
                return 1;
            }
            for (int i2 = 0; i2 < miz; ++i2) {
                if (mac[i2] == data[i2]) continue;
                return 1;
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GenRSAKeyPair(int bits, byte[] pubfid, byte[] prifid) {
        String cla = "B0";
        String ins = "26";
        String p2 = "00";
        String p3 = "04";
        String data = String.format("%02x%02x%02x%02x", pubfid[0] & 0xFF, pubfid[1] & 0xFF, prifid[0] & 0xFF, prifid[1] & 0xFF);
        String p1 = "";
        if (bits == 1024) {
            p1 = "01";
        } else if (bits == 2048) {
            p1 = "02";
        } else {
            Log.e((String)"CoverCard", (String)("[erro] GenRSAKeyPair invalid bits [" + bits + "]"));
            return -12;
        }
        mLock.lock();
        try {
            String send = cla + ins + p1 + p2 + p3 + data;
            String recv = this.mcc.SendAPDU(send);
            int n = this.HandleApduErrCode(recv);
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] GenRSAKeyPair [" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GenSM2KeyPair(byte[] pubfid, byte[] prifid) {
        String cla = "B0";
        String ins = "26";
        String p1 = "03";
        String p2 = "00";
        String p3 = "04";
        String data = String.format("%02x%02x%02x%02x", pubfid[0] & 0xFF, pubfid[1] & 0xFF, prifid[0] & 0xFF, prifid[1] & 0xFF);
        mLock.lock();
        try {
            String send = cla + ins + p1 + p2 + p3 + data;
            String recv = this.mcc.SendAPDU(send);
            int n = this.HandleApduErrCode(recv);
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] GenSM2KeyPair [" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SetSM2Id(byte[] sm2id, int len) {
        String cls = "B0";
        String ins = "1A";
        String p1 = "00";
        String p2 = "01";
        String p3 = String.format("%02x", len & 0xFF);
        StringBuilder builder = new StringBuilder("");
        for (int i2 = 0; i2 < len; ++i2) {
            builder.append(String.format("%02x", sm2id[i2]));
        }
        String icmd = cls + ins + p1 + p2 + p3 + builder.toString();
        mLock.lock();
        try {
            Log.i((String)"CoverCard", (String)("[debug] SetSM2Id [send][" + icmd + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("[debug] SetSM2Id [recv][" + recv + "]"));
            int n = this.HandleApduErrCode(recv);
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] SetSM2Id dumps [" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetSM2Id(byte[] sm2id, int[] len) {
        String cla = "B0";
        String ins = "1A";
        String p1 = "01";
        String p2 = "01";
        String p3 = "10";
        String icmd = cla + ins + p1 + p2 + p3;
        mLock.lock();
        try {
            Log.i((String)"CoverCard", (String)("[debug] GetSM2Id [send][" + icmd + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("[debug] GetSM2Id [recv][" + recv + "]"));
            String code = this.getCode(recv);
            int err = this.HandleApduErrCode(code);
            if (err == 0) {
                int size = recv.length() - code.length();
                Util.Str2Byte(recv.substring(0, size), sm2id, len);
            }
            int n = err;
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] GetSM2Id dumps[" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SetSM2Param(XDJA_SM2_PARAM sm2param) {
        String cla = "B0";
        String ins = "1A";
        String p1 = "00";
        String p2 = "02";
        String p3 = String.format("%02x", sm2param.size() & 0xFF);
        String data = sm2param.toApduData();
        String icmd = cla + ins + p1 + p2 + p3 + data;
        mLock.lock();
        try {
            Log.i((String)"CoverCard", (String)("SetSM2Param send[" + icmd.toUpperCase() + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("SetSM2Param recv[" + recv + "]"));
            int n = this.HandleApduErrCode(recv);
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] SetSM2Param dumps[" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XDJA_SM2_PARAM GetSM2Param() {
        String cla = "B0";
        String ins = "1A";
        String p1 = "01";
        String p2 = "02";
        String p3 = String.format("%02x", 192);
        String icmd = cla + ins + p1 + p2 + p3;
        mLock.lock();
        try {
            Log.i((String)"CoverCard", (String)("GetSM2Param send[" + icmd.toUpperCase() + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("GetSM2Param recv[" + recv + "]"));
            String code = recv.substring(recv.length() - 4);
            int err = this.HandleApduErrCode(recv.substring(recv.length() - 4));
            if (err == 0) {
                XDJA_SM2_PARAM xDJA_SM2_PARAM = new XDJA_SM2_PARAM(recv.substring(0, recv.length() - 4));
                return xDJA_SM2_PARAM;
            }
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] GetSM2Param dumps[" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetSM2Param(XDJA_SM2_PARAM sm2param) {
        if (sm2param == null) {
            Log.e((String)"CoverCard", (String)"[erro] GetSM2Param: invalid sm2param, should not be null.");
            return -12;
        }
        String cla = "B0";
        String ins = "1A";
        String p1 = "01";
        String p2 = "02";
        String p3 = String.format("%02x", 192);
        String icmd = cla + ins + p1 + p2 + p3;
        mLock.lock();
        try {
            Log.i((String)"CoverCard", (String)("GetSM2Param send[" + icmd.toUpperCase() + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("GetSM2Param recv[" + recv + "]"));
            String code = this.getCode(recv);
            int r = this.HandleApduErrCode(code);
            if (r == 0) {
                String data = recv.substring(0, recv.length() - code.length());
                sm2param.parse(data);
            }
            int n = r;
            return n;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] GetSM2Param dumps [" + e2.getMessage() + "]"));
            e2.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
        return -2;
    }

    private int SM2_Calc(byte[] id, byte[] idata, int ilen, byte[] out, int[] olen) {
        String cla = "B0";
        String ins = "2A";
        String p1 = "00";
        String p2 = "00";
        String p3 = String.format("%02x", ilen + 2 & 0xFF);
        String header = String.format("%02X%02X", id[0] & 0xFF, id[1] & 0xFF);
        StringBuilder builder = new StringBuilder(header);
        for (int i2 = 0; i2 < ilen; ++i2) {
            builder.append(String.format("%02X", idata[i2]));
        }
        String icmd = cla + ins + p1 + p2 + p3 + builder.toString();
        try {
            Log.i((String)"CoverCard", (String)("[debug] SM2_Calc " + header + "[send][" + icmd + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("[debug] SM2_Calc " + header + "[recv][" + recv + "]"));
            if (recv.length() < 4) {
                Log.e((String)"CoverCard", (String)("[erro] SM2_Calc " + header + "[recv][" + recv + "]"));
                return -100;
            }
            String code = this.getCode(recv);
            int r = this.HandleApduErrCode(code);
            if (r == 0) {
                int size = recv.length() - code.length();
                Util.Str2Byte(recv.substring(0, size), out, olen);
            }
            return r;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] SM2_Calc" + header + " dumps [" + e2.getMessage() + "]"));
            e2.printStackTrace();
            return -2;
        }
    }

    public int SM2Encrypt(byte[] id, byte[] in, int ilen, byte[] out, int[] olen) {
        if (ilen > 148) {
            Log.e((String)"CoverCard", (String)String.format("[erro] SM2Encrypt data length[%d] is over max-limit[%d]", ilen, 148));
            return -12;
        }
        if (out == null || out.length < ilen + 97) {
            return -12;
        }
        byte[] dat = new byte[out.length];
        mLock.lock();
        int r = this.SM2_Calc(id, in, ilen, dat, olen);
        mLock.unlock();
        if (r == 0) {
            this.SM2CipherSwap(dat, out, olen[0], true);
        }
        return r;
    }

    public int SM2Encrypt(XDJA_SM2_PUBKEY key, byte[] in, int ilen, byte[] out, int[] olen) {
        byte[] dat0;
        if (ilen > 148) {
            Log.e((String)"CoverCard", (String)String.format("[erro] SM2Encrypt data length[%d] is over max-limit[%d]", ilen, 148));
            return -12;
        }
        if (out == null || out.length < ilen + 97) {
            return -12;
        }
        SM2Encrypt sm2enc = new SM2Encrypt(new NamedEllipse());
        byte[] arr0 = new byte[65];
        arr0[0] = 4;
        System.arraycopy(key.x, 0, arr0, 1, 32);
        System.arraycopy(key.y, 0, arr0, 33, 32);
        if (in.length == ilen) {
            dat0 = in;
        } else {
            dat0 = new byte[ilen];
            System.arraycopy(in, 0, dat0, 0, ilen);
        }
        byte[] enc = sm2enc.pubkeyEncrypt(dat0, arr0);
        if (enc == null) {
            Log.e((String)"CoverCard", (String)"pubkeyEncrypt err");
            return 1;
        }
        olen[0] = enc.length;
        System.arraycopy(enc, 0, out, 0, enc.length);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2Decrypt(byte[] id, byte[] in, int ilen, byte[] out, int[] olen) {
        if (ilen > 245) {
            Log.e((String)"CoverCard", (String)String.format("[erro] SM2Decrypt data length[%d] is over max-limit[%d]", ilen, 245));
            return -12;
        }
        if (in == null || in.length < 97 || in.length < ilen) {
            return -12;
        }
        byte[] dat = new byte[ilen];
        this.SM2CipherSwap(in, dat, ilen, false);
        mLock.lock();
        try {
            int n = this.SM2_Calc(id, dat, ilen, out, olen);
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    private void SM2CipherSwap(byte[] cip0, byte[] cip1, int siz, boolean is_enc) {
        if (is_enc) {
            int pos = 0;
            System.arraycopy(cip0, 0, cip1, 0, 65);
            System.arraycopy(cip0, 97, cip1, pos += 65, siz - 65 - 32);
            System.arraycopy(cip0, 65, cip1, pos += siz - 65 - 32, 32);
        } else {
            int pos = 0;
            System.arraycopy(cip0, 0, cip1, 0, 65);
            System.arraycopy(cip0, siz - 32, cip1, pos += 65, 32);
            System.arraycopy(cip0, 65, cip1, pos += 32, siz - pos);
        }
    }

    private int SM2Sign(byte[] id, byte[] dat, int diz, byte[] sig, int[] siz) {
        if (id == null || id.length < 2) {
            Log.e((String)"CoverCard", (String)"[erro] SM2Sign: invalid param, id is null or id.length < 2");
            return -12;
        }
        if (diz != 32) {
            Log.e((String)"CoverCard", (String)("[erro] SM2Sign: invalid param, diz should be 32, but siz = " + diz));
            return -12;
        }
        if (dat == null || dat.length < diz) {
            Log.e((String)"CoverCard", (String)"[erro] SM2Sign: invalid param, dat is null or dat.length < diz");
            return -12;
        }
        if (sig == null || sig.length < diz * 2) {
            Log.e((String)"CoverCard", (String)"[erro] SM2Sign: invalid param, sig is null or sig.length is < diz * 2");
            return -12;
        }
        String cla = "B0";
        String ins = "2C";
        String p1 = "00";
        String p2 = "00";
        String p3 = String.format("%02X", diz + 2);
        String data = String.format("%02X%02X", id[0] & 0xFF, id[1] & 0xFF) + Util.Byte2Str(dat, diz);
        String icmd = cla + ins + p1 + p2 + p3 + data;
        try {
            Log.i((String)"CoverCard", (String)("[info] SM2Sign [send][" + icmd + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("[info] SM2Sign [recv][" + recv + "]"));
            String code = this.getCode(recv);
            int r = this.HandleApduErrCode(code);
            if (r == 0) {
                int size = recv.length() - code.length();
                Util.Str2Byte(recv.substring(0, size), sig, siz);
            }
            return r;
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] SM2Sign dumps[" + e2.getMessage() + "]"));
            e2.printStackTrace();
            return -2;
        }
    }

    private int SM2SignVerify(byte[] id, byte[] dat, int diz, byte[] sig, int siz, boolean hash) {
        if (id == null || id.length < 2) {
            Log.e((String)"CoverCard", (String)"[erro] SM2SignVerify: invalid param, id is null or id.length < 2");
            return -12;
        }
        if (diz != 32) {
            Log.e((String)"CoverCard", (String)("[erro] SM2SignVerify: invalid param, diz should be 32, but siz = " + diz));
            return -12;
        }
        if (dat == null || dat.length < diz) {
            Log.e((String)"CoverCard", (String)"[erro] SM2SignVerify: invalid param, dat is null or dat.length < diz");
            return -12;
        }
        if (sig == null || sig.length < diz * 2) {
            Log.e((String)"CoverCard", (String)"[erro] SM2SignVerify: invalid param, sig is null or sig.length is < diz * 2");
            return -12;
        }
        int p2 = 1;
        if (hash) {
            p2 = 0;
        }
        String icmd = String.format("B02100%02X%02X%02X%02X%s%s", p2, diz + siz + 2, id[0] & 0xFF, id[1] & 0xFF, Util.Byte2Str(sig, siz), Util.Byte2Str(dat, diz));
        try {
            Log.i((String)"CoverCard", (String)("[info] SM2SignVerify send[" + icmd + "]"));
            String recv = this.mcc.SendAPDU(icmd);
            Log.i((String)"CoverCard", (String)("[info] SM2SignVerify recv[" + recv + "]"));
            String code = this.getCode(recv);
            return this.HandleApduErrCode(code);
        }
        catch (Exception e2) {
            Log.e((String)"CoverCard", (String)("[erro] SM2SignVerify: dumps [" + e2.getMessage() + "]"));
            e2.printStackTrace();
            return -2;
        }
    }

    private int SM2SignEx(byte[] pid, byte[] sid, byte[] dat, int diz, byte[] sig, int[] siz) {
        if (diz <= 0 || dat == null || dat.length < diz) {
            return -12;
        }
        byte[] mac = this.__sm2_calc_e_value(pid, dat, diz);
        if (mac == null) {
            Log.e((String)"CoverCard", (String)"[erro] SM2SignEx: SM3.doFinal() return null mac");
            return -30;
        }
        return this.SM2Sign(sid, mac, mac.length, sig, siz);
    }

    private int SM2SignVerifyEx(byte[] pid, byte[] dat, int diz, byte[] sig, int siz) {
        if (diz <= 0 || dat == null || dat.length < diz) {
            return -12;
        }
        byte[] mac = this.__sm2_calc_e_value(pid, dat, diz);
        if (mac == null) {
            Log.e((String)"CoverCard", (String)"[erro] SM2SignEx: __sm2_calc_mac return null mac");
            return -30;
        }
        return this.SM2SignVerify(pid, mac, mac.length, sig, siz, true);
    }

    private int SM2SignVerifyEx(XDJA_SM2_PUBKEY key, byte[] dat, int diz, byte[] sig, int siz) {
        if (diz <= 0 || dat == null || dat.length < diz) {
            return -12;
        }
        byte[] mac = this.__sm2_calc_e_value(key, dat, diz);
        if (mac == null) {
            Log.e((String)"CoverCard", (String)"[erro] SM2SignEx: __sm2_calc_mac return null mac");
            return -30;
        }
        return this.SM2SignVerify(key, mac, mac.length, sig, siz);
    }

    private int SM2SignVerify(XDJA_SM2_PUBKEY key, byte[] dat, int diz, byte[] sig, int siz) {
        byte[] dat0;
        if (key == null || dat == null || diz <= 0 || sig == null || siz <= 0 || dat.length < diz || sig.length < siz) {
            return -12;
        }
        byte[] arr0 = new byte[65];
        arr0[0] = 4;
        System.arraycopy(key.x, 0, arr0, 1, 32);
        System.arraycopy(key.y, 0, arr0, 33, 32);
        ECSM2Signer ec = new ECSM2Signer(new NamedEllipse());
        ec.init(false, arr0);
        BigInteger r = new BigInteger(Util.Byte2Str(sig, 0, 32), 16);
        BigInteger s = new BigInteger(Util.Byte2Str(sig, 32, 32), 16);
        if (dat.length == diz) {
            dat0 = dat;
        } else {
            dat0 = new byte[diz];
            System.arraycopy(dat, 0, dat0, 0, diz);
        }
        return ec.verifySignature(dat0, r, s) ? 0 : 1;
    }

    private byte[] __sm2_calc_e_value(XDJA_SM2_PUBKEY key, byte[] dat, int diz) {
        byte[] sm2id = new byte[64];
        int[] siz = new int[]{0};
        int r = this.GetSM2Id(sm2id, siz);
        if (r != 0) {
            Log.e((String)"CoverCard", (String)String.format("[erro] __sm2_calc_mac: GetSM2Id [%d]", r));
            return null;
        }
        XDJA_SM2_PARAM sm2param = new XDJA_SM2_PARAM();
        r = this.GetSM2Param(sm2param);
        if (r != 0) {
            Log.e((String)"CoverCard", (String)String.format("[erro] __sm2_calc_mac: GetSM2Param [%d]", r));
            return null;
        }
        int pos = 0;
        int w_siz = 210;
        byte[] wrap = new byte[w_siz];
        wrap[0] = 0;
        wrap[1] = -128;
        System.arraycopy(sm2id, 0, wrap, pos += 2, 16);
        System.arraycopy(sm2param.a, 0, wrap, pos += 16, 32);
        System.arraycopy(sm2param.b, 0, wrap, pos += 32, 32);
        System.arraycopy(sm2param.x, 0, wrap, pos += 32, 32);
        System.arraycopy(sm2param.y, 0, wrap, pos += 32, 32);
        System.arraycopy(key.x, 0, wrap, pos += 32, 32);
        System.arraycopy(key.y, 0, wrap, pos += 32, 32);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(wrap, 0, w_siz);
        byte[] z = sm3.doFinal();
        if (z == null) {
            return null;
        }
        byte[] zdat = new byte[z.length + diz];
        System.arraycopy(z, 0, zdat, 0, z.length);
        System.arraycopy(dat, 0, zdat, z.length, diz);
        sm3.reset();
        sm3.update(zdat, 0, zdat.length);
        return sm3.doFinal();
    }

    private byte[] __sm2_calc_e_value(byte[] id, byte[] dat, int diz) {
        XDJA_SM2_PUBKEY sm2pub = new XDJA_SM2_PUBKEY();
        int r = this.ReadSm2PubKey(id, sm2pub);
        if (r != 0) {
            Log.e((String)"CoverCard", (String)String.format("[erro] __sm2_calc_mac: ReadSm2PubKey [%d]", r));
            return null;
        }
        return this.__sm2_calc_e_value(sm2pub, dat, diz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2Sign(byte[] pid, byte[] sid, int flag, byte[] dat, int diz, byte[] sig, int[] siz) {
        mLock.lock();
        try {
            if (flag == 0) {
                int n = this.SM2Sign(sid, dat, diz, sig, siz);
                return n;
            }
            if (flag == 1) {
                int n = this.SM2SignEx(pid, sid, dat, diz, sig, siz);
                return n;
            }
            int n = -12;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2SignVerify(byte[] pid, int flag, byte[] dat, int diz, byte[] sig, int siz) {
        mLock.lock();
        try {
            if (flag == 1) {
                int n = this.SM2SignVerifyEx(pid, dat, diz, sig, siz);
                return n;
            }
            if (flag == 0) {
                int n = this.SM2SignVerify(pid, dat, diz, sig, siz, true);
                return n;
            }
            int n = -12;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SM2SignVerify(XDJA_SM2_PUBKEY key, int flag, byte[] dat, int diz, byte[] sig, int siz) {
        mLock.lock();
        try {
            if (flag == 1) {
                int n = this.SM2SignVerifyEx(key, dat, diz, sig, siz);
                return n;
            }
            if (flag == 0) {
                int n = this.SM2SignVerify(key, dat, diz, sig, siz);
                return n;
            }
            int n = -12;
            return n;
        }
        finally {
            mLock.unlock();
        }
    }

    private int ReadKey(byte[] key, int len) {
        byte[] id = new byte[]{0, 8};
        int r = this.SelectFile(id);
        if (r != 0) {
            return -31;
        }
        int pos = 99;
        byte[] temp = new byte[16];
        r = this.ReadFile(id, pos, 1, temp);
        if ((temp[0] & 0xFF) == 0) {
            return -32;
        }
        if ((temp[0] & 0xFF) != 16) {
            return -33;
        }
        int siz = temp[0] & 0xFF;
        return this.ReadFile(id, ++pos, siz, key);
    }

    public int SM4(byte[] dat, int siz, int flag, byte[] out, int[] olen, byte kID, byte[] iv) {
        if (dat == null || dat.length == 0 || out == null || out.length == 0) {
            return -12;
        }
        if (0 == this.mReadSm4KeyStatu) {
            this.key = new byte[16];
            int r = this.ReadKey(this.key, this.key.length);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("ReadKey ret [" + r + "]"));
                return r;
            }
            this.mReadSm4KeyStatu = 1;
        }
        if (1 == flag && kID == 8) {
            byte[] plain = new byte[siz];
            System.arraycopy(dat, 0, plain, 0, siz);
            byte[] secure = Sm4.sm4_encrypt_ecb(this.key, plain);
            if (secure == null) {
                return 1;
            }
            System.arraycopy(secure, 0, out, 0, secure.length);
            olen[0] = secure.length;
        } else if (0 == flag && kID == 9) {
            byte[] secure = new byte[siz];
            System.arraycopy(dat, 0, secure, 0, siz);
            byte[] plain = Sm4.sm4_decrypt_ecb(this.key, secure);
            if (plain == null) {
                return 1;
            }
            System.arraycopy(plain, 0, out, 0, plain.length);
            olen[0] = secure.length;
        } else if (17 == flag) {
            byte[] plain = new byte[siz];
            System.arraycopy(dat, 0, plain, 0, siz);
            byte[] secure = Sm4.sm4_encrypt_cbc(this.key, plain, iv);
            if (secure == null) {
                return 1;
            }
            System.arraycopy(secure, 0, out, 0, secure.length);
            olen[0] = secure.length;
        } else if (16 == flag) {
            byte[] secure = new byte[siz];
            System.arraycopy(dat, 0, secure, 0, siz);
            byte[] plain = Sm4.sm4_decrypt_cbc(this.key, secure, iv);
            if (plain == null) {
                return 1;
            }
            System.arraycopy(plain, 0, out, 0, plain.length);
            olen[0] = secure.length;
        } else {
            return -12;
        }
        return 0;
    }

    public int SM4KEY(byte[] key, byte[] dat, int siz, int flag, byte[] out, byte[] iv) {
        int r = 0;
        if (dat == null || dat.length == 0 || out == null || out.length == 0) {
            return -12;
        }
        r = key.length;
        if (r != 16) {
            return -12;
        }
        if (1 == flag) {
            byte[] plain = new byte[siz];
            System.arraycopy(dat, 0, plain, 0, siz);
            byte[] secure = Sm4.sm4_encrypt_ecb(key, plain);
            if (secure == null) {
                return 1;
            }
            System.arraycopy(secure, 0, out, 0, secure.length);
        } else if (0 == flag) {
            byte[] secure = new byte[siz];
            System.arraycopy(dat, 0, secure, 0, siz);
            byte[] plain = Sm4.sm4_decrypt_ecb(key, secure);
            if (plain == null) {
                return 1;
            }
            System.arraycopy(plain, 0, out, 0, plain.length);
        } else if (17 == flag) {
            if (iv.length != 16) {
                return -12;
            }
            byte[] plain = new byte[siz];
            System.arraycopy(dat, 0, plain, 0, siz);
            byte[] secure = Sm4.sm4_encrypt_cbc(key, plain, iv);
            if (secure == null) {
                return 1;
            }
            System.arraycopy(secure, 0, out, 0, secure.length);
        } else if (16 == flag) {
            byte[] secure = new byte[siz];
            System.arraycopy(dat, 0, secure, 0, siz);
            byte[] plain = Sm4.sm4_decrypt_cbc(key, secure, iv);
            if (plain == null) {
                return 1;
            }
            System.arraycopy(plain, 0, out, 0, plain.length);
        } else {
            return -12;
        }
        return 0;
    }

    public int SM1(byte[] dat, int siz, int flag, byte[] out, byte kID, byte[] iv) {
        int r;
        if (dat == null || dat.length == 0 || out == null || out.length == 0) {
            return -12;
        }
        if (0 == this.mReadSm1KeyStatu) {
            this.key = new byte[16];
            r = this.ReadKey(this.key, this.key.length);
            if (r != 0) {
                Log.e((String)"CoverCard", (String)("ReadKey ret [" + r + "]"));
                return r;
            }
            this.mReadSm1KeyStatu = 1;
        }
        byte[] tmpkey = new byte[32];
        for (r = 0; r < 32; ++r) {
            tmpkey[r] = 0;
        }
        System.arraycopy(this.key, 0, tmpkey, 0, 16);
        if (1 == flag && kID == 8) {
            byte[] plain = new byte[siz];
            byte[] secure = new byte[siz];
            System.arraycopy(dat, 0, plain, 0, siz);
            r = this.CryptSmEcbEncrypt(tmpkey, plain, plain.length, secure);
            if (0 != r) {
                return 1;
            }
            System.arraycopy(secure, 0, out, 0, secure.length);
        } else if (0 == flag && kID == 9) {
            byte[] secure = new byte[siz];
            byte[] plain = new byte[siz];
            System.arraycopy(dat, 0, secure, 0, siz);
            r = this.CryptSmEcbDecrypt(tmpkey, secure, secure.length, plain);
            if (0 != r) {
                return 1;
            }
            System.arraycopy(plain, 0, out, 0, plain.length);
        } else if (17 == flag && kID == 8) {
            r = iv.length;
            if (16 != r) {
                return -12;
            }
            byte[] plain = new byte[siz];
            byte[] secure = new byte[siz];
            System.arraycopy(dat, 0, plain, 0, siz);
            r = this.CryptSmCbcEncrypt(tmpkey, iv, plain, plain.length, secure);
            if (0 != r) {
                return 1;
            }
            System.arraycopy(secure, 0, out, 0, secure.length);
        } else if (16 == flag && kID == 9) {
            r = iv.length;
            if (16 != r) {
                return -12;
            }
            byte[] secure = new byte[siz];
            byte[] plain = new byte[siz];
            System.arraycopy(dat, 0, secure, 0, siz);
            r = this.CryptSmCbcDecrypt(tmpkey, iv, secure, secure.length, plain);
            if (0 != r) {
                return 1;
            }
            System.arraycopy(plain, 0, out, 0, plain.length);
        } else {
            return -12;
        }
        return 0;
    }

    public int SM1KEY(byte[] key, byte[] dat, int siz, int flag, byte[] out, byte[] iv) {
        int r = 0;
        if (dat == null || dat.length == 0 || out == null || out.length == 0) {
            return -12;
        }
        r = key.length;
        if (r != 16) {
            return -12;
        }
        byte[] tmpkey = new byte[32];
        for (r = 0; r < 32; ++r) {
            tmpkey[r] = 0;
        }
        System.arraycopy(key, 0, tmpkey, 0, 16);
        if (1 == flag) {
            byte[] plain = new byte[siz];
            byte[] secure = new byte[siz];
            System.arraycopy(dat, 0, plain, 0, siz);
            r = this.CryptSmEcbEncrypt(tmpkey, plain, plain.length, secure);
            if (0 != r) {
                return 1;
            }
            System.arraycopy(secure, 0, out, 0, secure.length);
        } else if (0 == flag) {
            byte[] secure = new byte[siz];
            byte[] plain = new byte[siz];
            System.arraycopy(dat, 0, secure, 0, siz);
            r = this.CryptSmEcbDecrypt(tmpkey, secure, secure.length, plain);
            if (0 != r) {
                return 1;
            }
            System.arraycopy(plain, 0, out, 0, plain.length);
        } else if (17 == flag) {
            r = iv.length;
            if (16 != r) {
                return -12;
            }
            byte[] plain = new byte[siz];
            byte[] secure = new byte[siz];
            System.arraycopy(dat, 0, plain, 0, siz);
            r = this.CryptSmCbcEncrypt(tmpkey, iv, plain, plain.length, secure);
            if (0 != r) {
                return 1;
            }
            System.arraycopy(secure, 0, out, 0, secure.length);
        } else if (16 == flag) {
            r = iv.length;
            if (16 != r) {
                return -12;
            }
            byte[] secure = new byte[siz];
            byte[] plain = new byte[siz];
            System.arraycopy(dat, 0, secure, 0, siz);
            r = this.CryptSmCbcDecrypt(tmpkey, iv, secure, secure.length, plain);
            if (0 != r) {
                return 1;
            }
            System.arraycopy(plain, 0, out, 0, plain.length);
        } else {
            return -12;
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    static {
        System.loadLibrary("smcrypt");
    }
}

