/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.sm2cipher.sm2.cipher;

import com.xdja.cssp.sm2cipher.ec.ECConstants;
import com.xdja.cssp.sm2cipher.ec.ECCurve;
import com.xdja.cssp.sm2cipher.ec.ECPoint;
import com.xdja.cssp.sm2cipher.ec.NamedEllipse;
import com.xdja.cssp.sm2cipher.ec.RandomGen;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM3Digest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECSM2Signer
implements ECConstants {
    byte[] key = new byte[32];
    byte[] pubkey = new byte[65];
    SecureRandom random = new SecureRandom();
    public static String ID = "1234567812345678";
    private NamedEllipse namedEllipse = new NamedEllipse();

    public ECSM2Signer(NamedEllipse namedEllipse) {
        if (namedEllipse == null) {
            namedEllipse = new NamedEllipse();
        }
        this.namedEllipse = namedEllipse;
    }

    public void init(boolean forSigning, byte[] key) {
        if (forSigning) {
            System.arraycopy(key, 0, this.key, 32 - key.length, key.length);
            this.pubkey = this.getG().multiply(new BigInteger(1, this.key)).getEncoded();
        } else {
            System.arraycopy(key, 0, this.pubkey, 0, 65);
        }
    }

    public BigInteger[] generateSignature(byte[] message) {
        try {
            byte[] E = this.sm3WithID(message, ID.getBytes());
            BigInteger n = this.namedEllipse.getN();
            BigInteger e2 = this.calculateE(n, E);
            BigInteger r = null;
            BigInteger s = null;
            ECPoint G = null;
            ECPoint p = null;
            do {
                BigInteger k2 = null;
                k2 = RandomGen.randomGenerate();
                while (k2.signum() < 0) {
                    k2 = RandomGen.randomGenerate();
                }
                G = this.getG();
                p = G.multiply(k2);
                r = e2.add(p.getX().toBigInteger()).mod(n);
                if (r.equals(ZERO) || r.add(k2).equals(n)) {
                    s = ZERO;
                    continue;
                }
                BigInteger d2 = new BigInteger(1, this.key);
                BigInteger tmp1 = ONE.add(d2).mod(n);
                BigInteger tmp2 = r.multiply(d2).mod(n);
                tmp2 = k2.subtract(tmp2).mod(n);
                BigInteger xtmp = tmp1.modInverse(n);
                s = xtmp.multiply(tmp2).mod(n);
            } while (s.equals(ZERO));
            BigInteger[] res = new BigInteger[]{r, s};
            return res;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint p;
        ECPoint p2;
        ECCurve.Fp eCurve = new ECCurve.Fp(this.namedEllipse.getQ(), this.namedEllipse.getA(), this.namedEllipse.getB());
        BigInteger n = this.namedEllipse.getN();
        BigInteger e2 = this.calculateE(n, message);
        ECPoint G = null;
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger t = r.add(s).mod(n);
        if (t.compareTo(ZERO) == 0) {
            return false;
        }
        G = this.getG();
        ECPoint p1 = G.multiply(s);
        ECPoint p3 = p1.add(p2 = (p = ((ECCurve)eCurve).decodePoint(this.pubkey)).multiply(t));
        BigInteger R = e2.add(p3.getX().toBigInteger()).mod(n);
        return R.compareTo(r) == 0;
    }

    public byte[] sm3WithID(byte[] M, byte[] ID) {
        byte[] ZA = this.createZ(ID);
        byte[] M1 = new byte[ZA.length + M.length];
        System.arraycopy(ZA, 0, M1, 0, ZA.length);
        System.arraycopy(M, 0, M1, ZA.length, M.length);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(M1);
        byte[] e2 = sm3.doFinal();
        return e2;
    }

    public byte[] createZ(byte[] ID) {
        if (ID == null || ID.length < 1) {
            throw new RuntimeException("id is needed when computer z");
        }
        ECCurve.Fp eCurve = new ECCurve.Fp(this.namedEllipse.getQ(), this.namedEllipse.getA(), this.namedEllipse.getB());
        byte[] a2 = this.namedEllipse.getA().toByteArray();
        byte[] b2 = this.namedEllipse.getB().toByteArray();
        byte[] gx = this.namedEllipse.getX().toByteArray();
        byte[] gy = this.namedEllipse.getY().toByteArray();
        ECPoint Q = ((ECCurve)eCurve).decodePoint(this.pubkey);
        byte[] ax = Q.getX().toBigInteger().toByteArray();
        byte[] ay = Q.getY().toBigInteger().toByteArray();
        byte[] ida = new byte[194 + ID.length];
        ida[0] = (byte)((0xFF00 & ID.length * 8) >> 8);
        ida[1] = (byte)(0xFF & ID.length * 8);
        System.arraycopy(ID, 0, ida, 2, ID.length);
        this.fillData(ida, a2, ID.length, 1);
        this.fillData(ida, b2, ID.length, 2);
        this.fillData(ida, gx, ID.length, 3);
        this.fillData(ida, gy, ID.length, 4);
        this.fillData(ida, ax, ID.length, 5);
        this.fillData(ida, ay, ID.length, 6);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(ida);
        byte[] Z = sm3.doFinal();
        return Z;
    }

    private void fillData(byte[] ida, byte[] src, int idLength, int j2) {
        int pos = 2 + idLength + 32 * j2 - 1;
        int max = src.length;
        for (int i2 = 0; i2 < src.length && i2 < 32; ++i2) {
            ida[pos] = src[max - i2 - 1];
            --pos;
        }
        if (max == 31) {
            ida[pos] = 0;
        }
    }

    private ECPoint getG() {
        ECCurve.Fp eCurve = new ECCurve.Fp(this.namedEllipse.getQ(), this.namedEllipse.getA(), this.namedEllipse.getB());
        ECPoint.Fp G = new ECPoint.Fp(eCurve, this.namedEllipse.getGx(), this.namedEllipse.getGy());
        return G;
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        if (n.bitLength() > message.length * 8) {
            return new BigInteger(1, message);
        }
        int messageBitLength = message.length * 8;
        BigInteger trunc = new BigInteger(1, message);
        if (messageBitLength - n.bitLength() > 0) {
            trunc = trunc.shiftRight(messageBitLength - n.bitLength());
        }
        return trunc;
    }
}

