/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.tmc;

import android.content.Context;
import com.taisys.model.Card;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.cc.BaseCard;
import com.xdja.cc.CoverCard;
import com.xdja.cc.XDJA_SM2_PARAM;
import com.xdja.cc.XDJA_SM2_PRIKEY;
import java.util.HashSet;
import java.util.Set;

public class TMCAPI
extends BaseCard {
    public static final int SIGN_HASH = 0;
    public static final int SIGN_NOHASH = 1;
    public static final int XKR_NO_ROLE = -6;
    private Set<Integer> mRoleSet;
    private CoverCard mcc = new CoverCard();

    public TMCAPI() {
        this.mRoleSet = new HashSet<Integer>();
        this.mRoleSet.add(1);
        this.mRoleSet.add(2);
        this.mRoleSet.add(3);
        this.mRoleSet.add(4);
        this.mRoleSet.add(5);
        this.mRoleSet.add(17);
    }

    public int SendAPDU(byte[] send, int slen, byte[] recv, int[] rlen) {
        return this.mcc.SendAPDU(send, slen, recv, rlen);
    }

    public void SetLogFlag(boolean flag) {
        this.mcc.SetLogFlag(flag);
    }

    public String GetOtiType() {
        return this.mcc.GetOtiType();
    }

    public void OpenSEService(Context context, Card.SCSupported supported) {
        this.mcc.OpenSEService(context, supported);
    }

    public void CloseSEService() {
        this.mcc.CloseSEService();
    }

    public int VerifyPIN(int role, byte[] pin, int len) {
        if (!this.mRoleSet.contains(role)) {
            return -6;
        }
        return this.mcc.VerifyPIN(1, pin, len);
    }

    public int GetPINTryCount(int role) {
        if (!this.mRoleSet.contains(role)) {
            return -6;
        }
        return this.mcc.GetPINTryCount(1);
    }

    public int ChangePIN(int role, byte[] oldPIN, int oldLEN, byte[] newPIN, int newLEN) {
        if (!this.mRoleSet.contains(role)) {
            return -6;
        }
        return this.mcc.ChangePIN(1, oldPIN, oldLEN, newPIN, newLEN);
    }

    public int ReloadPIN(int role, byte[] key, int keyLen, byte[] pin, int pinLen) {
        if (!this.mRoleSet.contains(role)) {
            return -6;
        }
        return this.mcc.UnlockPIN(1, key, keyLen, pin, pinLen);
    }

    public int GenRandom(int len, byte[] arr) {
        return this.mcc.GenRandom(len, arr);
    }

    public int GetDevInfo(XDJA_DEVINFO dev) {
        com.xdja.cc.XDJA_DEVINFO devinfo = new com.xdja.cc.XDJA_DEVINFO();
        int ret = this.mcc.GetDevInfo(devinfo);
        if (ret == 0) {
            int siz = devinfo.getCardId().length() < dev.cardid.length ? devinfo.getCardId().length() : dev.cardid.length;
            System.arraycopy(devinfo.getCardId().getBytes(), 0, dev.cardid, 0, siz);
            siz = devinfo.getCosVersion().length() < dev.cosver.length ? devinfo.getCosVersion().length() : dev.cosver.length;
            System.arraycopy(devinfo.getCosVersion().getBytes(), 0, dev.cosver, 0, siz);
            dev.cardtype = devinfo.getCardType();
        }
        return ret;
    }

    public int CreateFile(XDJA_FILE file) {
        com.xdja.cc.XDJA_FILE loc = new com.xdja.cc.XDJA_FILE(file.id, file.type, file.room, file.read_Acl, file.write_Acl, file.use_Acl);
        return this.mcc.CreateFile(loc);
    }

    public int DeleteFile(byte[] id) {
        return this.mcc.DeleteFile(id);
    }

    public int GetFileInfo(byte[] id, XDJA_FILE file) {
        com.xdja.cc.XDJA_FILE ccfile = new com.xdja.cc.XDJA_FILE();
        int ret = this.mcc.GetFileInfo(id, ccfile);
        if (ret == 0) {
            System.arraycopy(ccfile.id, 0, file.id, 0, 2);
            file.type = ccfile.type;
            file.room = ccfile.room;
            file.read_Acl = ccfile.read_Acl;
            file.write_Acl = ccfile.write_Acl;
            file.use_Acl = ccfile.use_Acl;
        }
        return ret;
    }

    public int SelectFile(byte[] fid) {
        return this.mcc.SelectFile(fid);
    }

    public int ReadFile(byte[] fid, int pos, int rlen, byte[] out) {
        return this.mcc.ReadFile(fid, pos, rlen, out);
    }

    public int WriteFile(byte[] id, int pos, int wlen, byte[] data) {
        return this.mcc.WriteFile(id, pos, wlen, data);
    }

    public int ReadCert(byte[] fid, byte[] cert, int[] certlen) {
        return this.mcc.ReadCert(fid, cert, certlen);
    }

    public int WriteCert(byte[] fid, byte[] cert, int certlen) {
        return this.mcc.WriteCert(fid, cert, certlen);
    }

    public int ReadRsaPubKey(byte[] id, XDJA_RSA_PUBKEY key) {
        com.xdja.cc.XDJA_RSA_PUBKEY rsapub = new com.xdja.cc.XDJA_RSA_PUBKEY();
        int ret = this.mcc.ReadRsaPubKey(id, rsapub);
        if (ret == 0) {
            key.bits = rsapub.bits;
            key.e = rsapub.e;
            System.arraycopy(rsapub.m, 0, key.m, 0, 256);
        }
        return ret;
    }

    public int WriteRsaPubKey(byte[] id, XDJA_RSA_PUBKEY key) {
        com.xdja.cc.XDJA_RSA_PUBKEY rsapub = new com.xdja.cc.XDJA_RSA_PUBKEY(key.bits, key.m, key.e);
        return this.mcc.WriteRsaPubKey(id, rsapub);
    }

    public int WriteRsaPriKey(byte[] id, XDJA_RSA_PRIKEY key) {
        com.xdja.cc.XDJA_RSA_PRIKEY rsapri = new com.xdja.cc.XDJA_RSA_PRIKEY(key.bits, key.p, key.q, key.dp, key.dq, key.ce);
        return this.mcc.WriteRsaPriKey(id, rsapri);
    }

    public int ReadSm2PubKey(byte[] id, XDJA_SM2_PUBKEY key) {
        com.xdja.cc.XDJA_SM2_PUBKEY sm2pub = new com.xdja.cc.XDJA_SM2_PUBKEY();
        int ret = this.mcc.ReadSm2PubKey(id, sm2pub);
        if (ret == 0) {
            System.arraycopy(sm2pub.x, 0, key.x, 0, 32);
            System.arraycopy(sm2pub.y, 0, key.y, 0, 32);
        }
        return ret;
    }

    public int WriteSm2PubKey(byte[] id, XDJA_SM2_PUBKEY key) {
        com.xdja.cc.XDJA_SM2_PUBKEY sm2pub = new com.xdja.cc.XDJA_SM2_PUBKEY(key.x, key.y);
        return this.mcc.WriteSm2PubKey(id, sm2pub);
    }

    public int WriteSm2PriKey(byte[] id, com.xdja.SafeKey.XDJA_SM2_PRIKEY key) {
        XDJA_SM2_PRIKEY sm2pri = new XDJA_SM2_PRIKEY(key.d);
        return this.mcc.WriteSm2PriKey(id, sm2pri);
    }

    public int RSAPubKeyCalc(XDJA_RSA_PUBKEY key, byte[] dat, int siz, byte[] out, int[] oiz) {
        com.xdja.cc.XDJA_RSA_PUBKEY rsapub = new com.xdja.cc.XDJA_RSA_PUBKEY(key.bits, key.m, key.e);
        return this.mcc.RSAPubKeyCalc(rsapub, dat, siz, out, oiz);
    }

    public int RSAPubKeyCalc(byte[] id, int bits, byte[] dat, int siz, byte[] out, int[] oiz) {
        return this.mcc.RSAPubKeyCalc(id, bits, dat, siz, out, oiz);
    }

    public int RSAPriKeyCalc(byte[] id, int bits, byte[] dat, int siz, byte[] out, int[] oiz) {
        return this.mcc.RSAPriKeyCalc(id, bits, dat, siz, out, oiz);
    }

    public int RSASign(byte[] id, int bits, int datatype, byte[] dat, int diz, byte[] sig, int[] siz) {
        return this.mcc.RSASign(id, bits, datatype, dat, diz, sig, siz);
    }

    public int RSASignVerify(byte[] id, int bits, int datatype, byte[] dat, int diz, byte[] sig, int siz) {
        return this.mcc.RSASignVerify(id, bits, datatype, dat, diz, sig, siz);
    }

    public int GenRSAKeyPair(int bits, byte[] pubfid, byte[] prifid) {
        return this.mcc.GenRSAKeyPair(bits, pubfid, prifid);
    }

    public int GenSM2KeyPair(byte[] pubfid, byte[] prifid) {
        return this.mcc.GenSM2KeyPair(pubfid, prifid);
    }

    public int SetSM2Id(byte[] sm2id, int len) {
        return this.mcc.SetSM2Id(sm2id, len);
    }

    public int GetSM2Id(byte[] sm2id, int[] len) {
        return this.mcc.GetSM2Id(sm2id, len);
    }

    public int SetSM2Param(com.xdja.SafeKey.XDJA_SM2_PARAM sm2param) {
        XDJA_SM2_PARAM param = new XDJA_SM2_PARAM(sm2param.p, sm2param.a, sm2param.b, sm2param.n, sm2param.x, sm2param.y);
        return this.mcc.SetSM2Param(param);
    }

    public int GetSM2Param(com.xdja.SafeKey.XDJA_SM2_PARAM sm2param) {
        XDJA_SM2_PARAM param = new XDJA_SM2_PARAM();
        int ret = this.mcc.GetSM2Param(param);
        if (ret == 0) {
            System.arraycopy(param.p, 0, sm2param.p, 0, 32);
            System.arraycopy(param.a, 0, sm2param.a, 0, 32);
            System.arraycopy(param.b, 0, sm2param.b, 0, 32);
            System.arraycopy(param.n, 0, sm2param.n, 0, 32);
            System.arraycopy(param.x, 0, sm2param.x, 0, 32);
            System.arraycopy(param.y, 0, sm2param.y, 0, 32);
        }
        return ret;
    }

    public int SM2Encrypt(XDJA_SM2_PUBKEY key, byte[] in, int ilen, byte[] out, int[] olen) {
        com.xdja.cc.XDJA_SM2_PUBKEY sm2pub = new com.xdja.cc.XDJA_SM2_PUBKEY();
        System.arraycopy(key.x, 0, sm2pub.x, 0, 32);
        System.arraycopy(key.y, 0, sm2pub.y, 0, 32);
        return this.mcc.SM2Encrypt(sm2pub, in, ilen, out, olen);
    }

    public int SM2EncryptGM(XDJA_SM2_PUBKEY key, byte[] in, int ilen, byte[] out, int[] olen) {
        int[] len = new int[1];
        byte[] outbuf = new byte[97 + ilen];
        com.xdja.cc.XDJA_SM2_PUBKEY sm2pub = new com.xdja.cc.XDJA_SM2_PUBKEY();
        System.arraycopy(key.x, 0, sm2pub.x, 0, 32);
        System.arraycopy(key.y, 0, sm2pub.y, 0, 32);
        int ret = this.mcc.SM2Encrypt(sm2pub, in, ilen, outbuf, len);
        if (0 != ret) {
            return ret;
        }
        System.arraycopy(outbuf, 1, out, 0, 64);
        olen[0] = 64;
        System.arraycopy(outbuf, len[0] - 32, out, olen[0], 32);
        olen[0] = olen[0] + 32;
        out[olen[0]] = (byte)(len[0] - 97);
        out[olen[0] + 1] = 0;
        out[olen[0] + 2] = 0;
        out[olen[0] + 3] = 0;
        olen[0] = olen[0] + 4;
        System.arraycopy(outbuf, 65, out, olen[0], len[0] - 97);
        olen[0] = olen[0] + (len[0] - 97);
        return ret;
    }

    public int SM2Encrypt(byte[] id, byte[] in, int ilen, byte[] out, int[] olen) {
        return this.mcc.SM2Encrypt(id, in, ilen, out, olen);
    }

    public int SM2EncryptGM(byte[] id, byte[] in, int ilen, byte[] out, int[] olen) {
        byte[] outbuf = new byte[97 + ilen];
        int[] len = new int[1];
        int ret = this.mcc.SM2Encrypt(id, in, ilen, outbuf, len);
        if (0 != ret) {
            return ret;
        }
        System.arraycopy(outbuf, 1, out, 0, 64);
        olen[0] = 64;
        System.arraycopy(outbuf, len[0] - 32, out, olen[0], 32);
        olen[0] = olen[0] + 32;
        out[olen[0]] = (byte)(len[0] - 97);
        out[olen[0] + 1] = 0;
        out[olen[0] + 2] = 0;
        out[olen[0] + 3] = 0;
        olen[0] = olen[0] + 4;
        System.arraycopy(outbuf, 65, out, olen[0], len[0] - 97);
        olen[0] = olen[0] + (len[0] - 97);
        return ret;
    }

    public int SM2Decrypt(byte[] id, byte[] in, int ilen, byte[] out, int[] olen) {
        return this.mcc.SM2Decrypt(id, in, ilen, out, olen);
    }

    public int SM2DecryptGM(byte[] id, byte[] in, int ilen, byte[] out, int[] olen) {
        int inbuflen = 0;
        byte[] inbuf = new byte[ilen];
        inbuf[0] = 4;
        System.arraycopy(in, 0, inbuf, ++inbuflen, 64);
        System.arraycopy(in, 100, inbuf, inbuflen += 64, ilen - 100);
        System.arraycopy(in, 64, inbuf, inbuflen += ilen - 100, 32);
        return this.mcc.SM2Decrypt(id, inbuf, inbuflen += 32, out, olen);
    }

    public int SM2Sign(byte[] pid, byte[] sid, int flag, byte[] dat, int diz, byte[] sig, int[] siz) {
        return this.mcc.SM2Sign(pid, sid, flag, dat, diz, sig, siz);
    }

    public int SM2SignVerify(byte[] pid, int flag, byte[] dat, int diz, byte[] sig, int siz) {
        return this.mcc.SM2SignVerify(pid, flag, dat, diz, sig, siz);
    }

    public int SM2SignVerify(XDJA_SM2_PUBKEY key, int flag, byte[] dat, int diz, byte[] sig, int siz) {
        com.xdja.cc.XDJA_SM2_PUBKEY sm2pub = new com.xdja.cc.XDJA_SM2_PUBKEY();
        System.arraycopy(key.x, 0, sm2pub.x, 0, 32);
        System.arraycopy(key.y, 0, sm2pub.y, 0, 32);
        return this.mcc.SM2SignVerify(sm2pub, flag, dat, diz, sig, siz);
    }

    public int SM4(byte[] dataIn, int dataLen, int flag, byte[] dataOut, int[] outLen, byte kID, byte[] IV) {
        return this.mcc.SM4(dataIn, dataLen, flag, dataOut, outLen, kID, IV);
    }

    public int SM4KEY(byte[] key, byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte[] IV) {
        return this.mcc.SM4KEY(key, dataIn, dataLen, flag, dataOut, IV);
    }

    public int SM1(byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        return this.mcc.SM1(dataIn, dataLen, flag, dataOut, kID, IV);
    }

    public int SM1KEY(byte[] key, byte[] dataIn, int dataLen, int flag, byte[] dataOut, byte[] IV) {
        return this.mcc.SM1KEY(key, dataIn, dataLen, flag, dataOut, IV);
    }
}

