/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.simalliance.openmobileapi.Channel;
import org.simalliance.openmobileapi.FileViewProvider;
import org.simalliance.openmobileapi.Provider;
import org.simalliance.openmobileapi.internal.ByteArrayConverter;
import org.simalliance.openmobileapi.internal.DerTlvCoder;
import org.simalliance.openmobileapi.internal.DerTlvParser;
import org.simalliance.openmobileapi.internal.ErrorStrings;
import org.simalliance.openmobileapi.internal.OidParser;
import org.simalliance.openmobileapi.internal.TlvEntryWrapper;

public class PKCS15Provider
extends Provider {
    private FileViewProvider mFileViewProvider;
    private byte[] mOdfContent;
    private byte[] mTokenInfoContent;
    public static final byte[] AID_PKCS15 = new byte[]{-96, 0, 0, 0, 99, 80, 75, 67, 83, 45, 49, 53};
    private static final int FID_EF_DIR = 12032;
    private static final int FID_EF_ODF = 20529;
    private static final int FID_EF_TOKEN_INFO = 20530;
    private static final byte[] TLV_TAG_PKCS15_APP_TEMPLATE = new byte[]{97};
    private static final byte[] TLV_TAG_PKCS15_PATH = new byte[]{81};
    private static final byte[] TLV_TAG_OID = new byte[]{6};
    private static final byte[] TLV_TAG_SEQUENCE = new byte[]{48};
    private static final byte[] TLV_TAG_PRIVATE_KEY = new byte[]{-96};
    private static final byte[] TLV_TAG_PUBLIC_KEY = new byte[]{-95};
    private static final byte[] TLV_TAG_PUBLIC_KEY_TRUSTED = new byte[]{-94};
    private static final byte[] TLV_TAG_SECRET_KEY = new byte[]{-93};
    private static final byte[] TLV_TAG_CERTIFICATE = new byte[]{-92};
    private static final byte[] TLV_TAG_CERTIFICATE_TRUSTED = new byte[]{-91};
    private static final byte[] TLV_TAG_CERTIFICATE_USEFUL = new byte[]{-90};
    private static final byte[] TLV_TAG_DATA_OBJECT = new byte[]{-89};
    private static final byte[] TLV_TAG_AUTHENTICATE_OBJECT = new byte[]{-88};

    public PKCS15Provider(Channel channel) throws IOException, IllegalStateException {
        super(channel);
        this.mFileViewProvider = new FileViewProvider(channel);
        if (!this.currentDirIsPkcs15FileStructure()) {
            FileViewProvider.FCP fcpEfDir;
            try {
                fcpEfDir = this.mFileViewProvider.selectByPath(Integer.toHexString(12032), false);
            }
            catch (IllegalArgumentException e2) {
                throw new IOException("No PKCS#15 file structure found.");
            }
            int numberOfRecords = fcpEfDir.getNumberOfRecords();
            for (int i2 = 0; i2 < numberOfRecords; ++i2) {
                byte[] recordData = this.mFileViewProvider.readRecord(0, i2 + 1).getData();
                if (!this.recordContainsValidPath(recordData)) continue;
                this.mOdfContent = this.readOdf();
                this.mTokenInfoContent = this.readTokenInfo();
                return;
            }
            throw new IOException("No PKCS#15 file structure found.");
        }
        this.mOdfContent = this.readOdf();
        this.mTokenInfoContent = this.readTokenInfo();
    }

    public byte[] getODF() throws IllegalStateException {
        return this.mOdfContent;
    }

    public byte[] getTokenInfo() {
        return this.mTokenInfoContent;
    }

    public Path[] getPrivateKeyPaths() {
        TlvEntryWrapper derObject;
        ArrayList<Path> paths = new ArrayList<Path>();
        DerTlvParser parser = new DerTlvParser();
        byte[] odfContent = parser.getValidTlvData(this.getODF());
        for (int position = 0; position < odfContent.length; position += derObject.getTotalLength()) {
            derObject = new TlvEntryWrapper(odfContent, position, parser);
            if (!this.isPrivateKeyTag(derObject.getTag())) continue;
            try {
                paths.add(this.decodePath(derObject.getValue()));
                continue;
            }
            catch (IllegalArgumentException e2) {
                // empty catch block
            }
        }
        if (paths.size() > 0) {
            return paths.toArray(new Path[paths.size()]);
        }
        return null;
    }

    public Path[] getPublicKeyPaths() {
        TlvEntryWrapper derObject;
        ArrayList<Path> paths = new ArrayList<Path>();
        DerTlvParser parser = new DerTlvParser();
        byte[] odfContent = parser.getValidTlvData(this.getODF());
        for (int position = 0; position < odfContent.length; position += derObject.getTotalLength()) {
            derObject = new TlvEntryWrapper(odfContent, position, parser);
            if (!this.isPublicKeyTag(derObject.getTag())) continue;
            try {
                paths.add(this.decodePath(derObject.getValue()));
                continue;
            }
            catch (IllegalArgumentException e2) {
                // empty catch block
            }
        }
        if (paths.size() > 0) {
            return paths.toArray(new Path[paths.size()]);
        }
        return null;
    }

    public Path[] getCertificatePaths() {
        TlvEntryWrapper derObject;
        ArrayList<Path> paths = new ArrayList<Path>();
        DerTlvParser parser = new DerTlvParser();
        byte[] odfContent = parser.getValidTlvData(this.getODF());
        for (int position = 0; position < odfContent.length; position += derObject.getTotalLength()) {
            derObject = new TlvEntryWrapper(odfContent, position, parser);
            if (!this.isCertificateTag(derObject.getTag())) continue;
            try {
                paths.add(this.decodePath(derObject.getValue()));
                continue;
            }
            catch (IllegalArgumentException e2) {
                // empty catch block
            }
        }
        if (paths.size() > 0) {
            return paths.toArray(new Path[paths.size()]);
        }
        return null;
    }

    public Path[] getDataObjPaths() {
        TlvEntryWrapper derObject;
        ArrayList<Path> paths = new ArrayList<Path>();
        DerTlvParser parser = new DerTlvParser();
        byte[] odfContent = parser.getValidTlvData(this.getODF());
        for (int position = 0; position < odfContent.length; position += derObject.getTotalLength()) {
            derObject = new TlvEntryWrapper(odfContent, position, parser);
            if (!this.isDataObjectTag(derObject.getTag())) continue;
            try {
                paths.add(this.decodePath(derObject.getValue()));
                continue;
            }
            catch (IllegalArgumentException e2) {
                // empty catch block
            }
        }
        if (paths.size() > 0) {
            return paths.toArray(new Path[paths.size()]);
        }
        return null;
    }

    public Path[] getAuthObjPaths() {
        TlvEntryWrapper derObject;
        ArrayList<Path> paths = new ArrayList<Path>();
        DerTlvParser parser = new DerTlvParser();
        byte[] odfContent = parser.getValidTlvData(this.getODF());
        for (int position = 0; position < odfContent.length; position += derObject.getTotalLength()) {
            derObject = new TlvEntryWrapper(odfContent, position, parser);
            if (!this.isAuthenticationObjectTag(derObject.getTag())) continue;
            try {
                paths.add(this.decodePath(derObject.getValue()));
                continue;
            }
            catch (IllegalArgumentException e2) {
                // empty catch block
            }
        }
        if (paths.size() > 0) {
            return paths.toArray(new Path[paths.size()]);
        }
        return null;
    }

    public byte[] readFile(Path path) throws SecurityException, UnsupportedOperationException, IOException, IllegalArgumentException, IllegalStateException {
        FileViewProvider.FCP fcp = this.mFileViewProvider.selectByPath(ByteArrayConverter.byteArrayToPathString(path.getPath()), true);
        if (fcp.getFileType() != 1) {
            throw new IllegalArgumentException("Could not read file: not an EF.");
        }
        if (fcp.getFileStructure() == 1) {
            int length;
            int index;
            if (path.hasIndexLength()) {
                index = path.getIndex();
                length = path.getLength();
            } else {
                index = 0;
                length = 0;
            }
            return this.mFileViewProvider.readBinary(0, index, length);
        }
        if (!path.hasIndexLength()) {
            throw new IllegalArgumentException("Could not read file: index not specified in a record-based file.");
        }
        return this.mFileViewProvider.readRecord(0, path.getIndex()).getData();
    }

    public byte[] searchOID(byte[] dodf, String oid) throws IllegalArgumentException, UnsupportedOperationException {
        TlvEntryWrapper entry;
        byte[] encodedOid = OidParser.encodeOid(oid);
        DerTlvParser parser = new DerTlvParser();
        try {
            entry = new TlvEntryWrapper(dodf, 0, parser);
        }
        catch (Exception e2) {
            return null;
        }
        if (!Arrays.equals(entry.getTag(), TLV_TAG_DATA_OBJECT)) {
            return null;
        }
        byte[] outerContent = entry.getValue();
        int outerPosition = 0;
        while (outerPosition < outerContent.length) {
            TlvEntryWrapper outerTlvEntry;
            try {
                outerTlvEntry = new TlvEntryWrapper(outerContent, outerPosition, parser);
            }
            catch (Exception e3) {
                return null;
            }
            if (Arrays.equals(outerTlvEntry.getTag(), TLV_TAG_SEQUENCE)) {
                TlvEntryWrapper innerTlvEntry;
                int innerPosition = 0;
                byte[] innerContent = outerTlvEntry.getValue();
                try {
                    innerTlvEntry = new TlvEntryWrapper(innerContent, innerPosition, parser);
                }
                catch (Exception e4) {
                    outerPosition += outerTlvEntry.getTotalLength();
                    continue;
                }
                if (Arrays.equals(innerTlvEntry.getTag(), TLV_TAG_OID) && Arrays.equals(encodedOid, innerTlvEntry.getValue())) {
                    innerPosition += innerTlvEntry.getTotalLength();
                    try {
                        innerTlvEntry = new TlvEntryWrapper(innerContent, innerPosition, parser);
                    }
                    catch (Exception e5) {
                        outerPosition += outerTlvEntry.getTotalLength();
                        continue;
                    }
                    return innerTlvEntry.getValue();
                }
            }
            outerPosition += outerTlvEntry.getTotalLength();
        }
        return null;
    }

    public Path decodePath(byte[] der) throws IllegalArgumentException {
        int position;
        DerTlvParser parser = new DerTlvParser();
        TlvEntryWrapper derPathObject = new TlvEntryWrapper(der, 0, parser);
        if (!Arrays.equals(derPathObject.getTag(), DerTlvCoder.TAG_SEQUENCE)) {
            throw new IllegalArgumentException("Unexpected tag.");
        }
        byte[] sequenceBytes = derPathObject.getValue();
        TlvEntryWrapper derPathValue = new TlvEntryWrapper(sequenceBytes, position = 0, parser);
        if (!Arrays.equals(derPathValue.getTag(), DerTlvCoder.TAG_OCTET_STRING)) {
            throw new IllegalArgumentException("Unexpected tag.");
        }
        if ((position += derPathValue.getTotalLength()) >= sequenceBytes.length) {
            return new Path(derPathValue.getValue());
        }
        TlvEntryWrapper derIndex = new TlvEntryWrapper(sequenceBytes, position, parser);
        if (!Arrays.equals(derIndex.getTag(), DerTlvCoder.TAG_INTEGER)) {
            throw new IllegalArgumentException("Unexpected tag.");
        }
        int index = ByteArrayConverter.byteArrayToInt(derIndex.getValue());
        TlvEntryWrapper derLength = new TlvEntryWrapper(sequenceBytes, position += derIndex.getTotalLength(), parser);
        if (!Arrays.equals(derLength.getTag(), DerTlvCoder.TAG_INTEGER)) {
            throw new IllegalArgumentException("Unexpected tag.");
        }
        int length = ByteArrayConverter.byteArrayToInt(derLength.getValue());
        return new Path(derPathValue.getValue(), index, length);
    }

    private boolean currentDirIsPkcs15FileStructure() throws IllegalStateException {
        try {
            this.mFileViewProvider.selectByFID(20529);
            this.mFileViewProvider.selectByFID(20530);
            return true;
        }
        catch (IllegalStateException e2) {
            throw e2;
        }
        catch (Exception e3) {
            return false;
        }
    }

    private boolean recordContainsValidPath(byte[] recordData) {
        int startPosition;
        DerTlvParser parser = new DerTlvParser();
        try {
            startPosition = parser.searchTag(recordData, TLV_TAG_PKCS15_APP_TEMPLATE, 0);
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
        byte[] pkcs15RawData = new TlvEntryWrapper(recordData, startPosition, parser).getValue();
        try {
            startPosition = parser.searchTag(pkcs15RawData, TLV_TAG_PKCS15_PATH, startPosition);
        }
        catch (IllegalArgumentException e3) {
            return false;
        }
        byte[] rawPath = new TlvEntryWrapper(pkcs15RawData, startPosition, parser).getValue();
        try {
            this.mFileViewProvider.selectByPath(ByteArrayConverter.byteArrayToPathString(rawPath), false);
            return this.currentDirIsPkcs15FileStructure();
        }
        catch (Exception e4) {
            return false;
        }
    }

    private byte[] readOdf() throws IOException {
        this.mFileViewProvider.selectByFID(20529);
        byte[] odfContent = this.mFileViewProvider.readBinary(0, 0, 0);
        if (odfContent == null) {
            throw new IOException("Error reading EF(ODF): returned null.");
        }
        return odfContent;
    }

    private byte[] readTokenInfo() throws IOException {
        this.mFileViewProvider.selectByFID(20530);
        byte[] tokenInfoContent = this.mFileViewProvider.readBinary(0, 0, 0);
        if (tokenInfoContent == null) {
            throw new IOException("Error reading EF(TokenInfo): returned null.");
        }
        return tokenInfoContent;
    }

    private boolean isPrivateKeyTag(byte[] tag) {
        return Arrays.equals(tag, TLV_TAG_PRIVATE_KEY);
    }

    private boolean isPublicKeyTag(byte[] tag) {
        return Arrays.equals(tag, TLV_TAG_PUBLIC_KEY) || Arrays.equals(tag, TLV_TAG_PUBLIC_KEY_TRUSTED);
    }

    private boolean isCertificateTag(byte[] tag) {
        return Arrays.equals(tag, TLV_TAG_CERTIFICATE) || Arrays.equals(tag, TLV_TAG_CERTIFICATE_TRUSTED) || Arrays.equals(tag, TLV_TAG_CERTIFICATE_USEFUL);
    }

    private boolean isDataObjectTag(byte[] tag) {
        return Arrays.equals(tag, TLV_TAG_DATA_OBJECT);
    }

    private boolean isAuthenticationObjectTag(byte[] tag) {
        return Arrays.equals(tag, TLV_TAG_AUTHENTICATE_OBJECT);
    }

    public class Path {
        public static final int VALUE_UNDEFINED = -1;
        private byte[] mPath;
        private Integer mIndex;
        private Integer mLength;

        public Path(byte[] path) throws IllegalArgumentException {
            if (path == null) {
                throw new IllegalArgumentException(ErrorStrings.paramNull("path"));
            }
            this.mPath = new byte[path.length];
            System.arraycopy((byte[])path, (int)0, (byte[])this.mPath, (int)0, (int)path.length);
            this.mIndex = null;
            this.mLength = null;
        }

        public Path(byte[] path, int index, int length) throws IllegalArgumentException {
            if (path == null) {
                throw new IllegalArgumentException(ErrorStrings.paramNull("path"));
            }
            if (index < 1) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("index"));
            }
            if (length < 1) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("length"));
            }
            this.mPath = new byte[path.length];
            System.arraycopy((byte[])path, (int)0, (byte[])this.mPath, (int)0, (int)path.length);
            this.mIndex = index;
            this.mLength = length;
        }

        public byte[] getPath() {
            return this.mPath;
        }

        public boolean hasIndexLength() {
            return this.mIndex != null && this.mLength != null;
        }

        public int getIndex() {
            if (this.hasIndexLength()) {
                return this.mIndex;
            }
            return -1;
        }

        public int getLength() {
            if (this.hasIndexLength()) {
                return this.mLength;
            }
            return -1;
        }

        public byte[] encode() {
            byte[] derCodedLength;
            byte[] derCodedIndex;
            byte[] derCodedPath = DerTlvCoder.encodeOctetString(this.mPath);
            if (this.hasIndexLength()) {
                derCodedIndex = DerTlvCoder.encodeInteger(this.mIndex);
                derCodedLength = DerTlvCoder.encodeInteger(this.mLength);
            } else {
                derCodedIndex = new byte[]{};
                derCodedLength = new byte[]{};
            }
            byte[] encodedDer = new byte[derCodedPath.length + derCodedIndex.length + derCodedLength.length];
            System.arraycopy((byte[])derCodedPath, (int)0, (byte[])encodedDer, (int)0, (int)derCodedPath.length);
            System.arraycopy((byte[])derCodedIndex, (int)0, (byte[])encodedDer, (int)derCodedPath.length, (int)derCodedIndex.length);
            System.arraycopy((byte[])derCodedLength, (int)0, (byte[])encodedDer, (int)(derCodedPath.length + derCodedIndex.length), (int)derCodedLength.length);
            return DerTlvCoder.encodeSequence(encodedDer);
        }
    }
}

