/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import android.util.Log;
import org.simalliance.openmobileapi.Channel;
import org.simalliance.openmobileapi.SERecognizer;
import org.simalliance.openmobileapi.Session;
import org.simalliance.openmobileapi.internal.ErrorStrings;

public class SERecognizerByAID
extends SERecognizer {
    private static final String LOG_TAG = "SERecognizerByAID";
    public static final int AID_MIN_LENGTH = 5;
    public static final int AID_MAX_LENGTH = 16;
    private byte[] mAID;

    public SERecognizerByAID(byte[] aid) throws IllegalArgumentException {
        if (aid == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("aid"));
        }
        if (aid.length < 5 || aid.length > 16) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("aid"));
        }
        this.mAID = new byte[aid.length];
        System.arraycopy((byte[])aid, (int)0, (byte[])this.mAID, (int)0, (int)aid.length);
    }

    @Override
    public boolean isMatching(Session session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("session"));
        }
        try {
            Channel channel = session.openLogicalChannel(this.mAID);
            if (channel != null) {
                channel.close();
                return true;
            }
        }
        catch (Exception e2) {
            Log.e((String)LOG_TAG, (String)"Catch general Exception", (Throwable)e2);
        }
        return false;
    }
}

