/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import java.util.Arrays;
import org.simalliance.openmobileapi.SERecognizer;
import org.simalliance.openmobileapi.Session;
import org.simalliance.openmobileapi.internal.ErrorStrings;
import org.simalliance.openmobileapi.internal.HistoricalBytesUtilities;

public class SERecognizerByHistoricalBytes
extends SERecognizer {
    public static final int HISTORICAL_BYTES_MIN_LENGTH = 0;
    public static final int HISTORICAL_BYTES_MAX_LENGTH = 15;
    private byte[] mHistBytes;

    public SERecognizerByHistoricalBytes(byte[] values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("values"));
        }
        if (values.length < 0 || values.length > 15) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("values"));
        }
        this.mHistBytes = new byte[values.length];
        System.arraycopy((byte[])values, (int)0, (byte[])this.mHistBytes, (int)0, (int)values.length);
    }

    @Override
    public boolean isMatching(Session session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("session"));
        }
        byte[] sessionHistBytes = HistoricalBytesUtilities.getHistBytes(session.getATR());
        return Arrays.equals(this.mHistBytes, sessionHistBytes);
    }
}

