/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.simalliance.openmobileapi.Reader;
import org.simalliance.openmobileapi.service.ISmartcardService;
import org.simalliance.openmobileapi.service.ISmartcardServiceCallback;
import org.simalliance.openmobileapi.service.ISmartcardServiceReader;
import org.simalliance.openmobileapi.service.SmartcardError;

public class SEService {
    private static final String SERVICE_TAG = "SEService";
    private final Object mLock = new Object();
    private final Context mContext;
    private volatile ISmartcardService mSmartcardService;
    private ServiceConnection mConnection;
    private Map<String, Reader> mReaders;
    private final ISmartcardServiceCallback mCallback = new ISmartcardServiceCallback.Stub(){};
    private CallBack mCallerCallback;

    public SEService(Context context, CallBack listener) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        this.mContext = context;
        this.mCallerCallback = listener;
        this.mConnection = new ServiceConnection(){

            public synchronized void onServiceConnected(ComponentName className, IBinder service) {
                SEService.this.mSmartcardService = ISmartcardService.Stub.asInterface(service);
                if (SEService.this.mCallerCallback != null) {
                    SEService.this.mCallerCallback.serviceConnected(SEService.this);
                }
                Log.v((String)SEService.SERVICE_TAG, (String)"Service onServiceConnected");
            }

            public void onServiceDisconnected(ComponentName className) {
                SEService.this.mSmartcardService = null;
                Log.v((String)SEService.SERVICE_TAG, (String)"Service onServiceDisconnected");
            }
        };
        Intent intent = new Intent("org.simalliance.openmobileapi.BIND_SERVICE");
        intent.setPackage("org.simalliance.openmobileapi.service");
        boolean bindingSuccessful = this.mContext.bindService(intent, this.mConnection, 1);
        Log.v((String)SERVICE_TAG, (String)("bindingSuccessful: " + bindingSuccessful));
    }

    public boolean isConnected() {
        return this.mSmartcardService != null;
    }

    public Reader[] getReaders() throws IllegalStateException, NullPointerException {
        if (this.mSmartcardService == null) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mReaders == null) {
            this.initReadersMap();
        }
        return this.sortReaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSmartcardService != null && this.mReaders != null) {
                for (Reader reader : this.mReaders.values()) {
                    try {
                        reader.closeSessions();
                    }
                    catch (Exception ignore) {}
                }
            }
            try {
                this.mContext.unbindService(this.mConnection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mSmartcardService = null;
        }
    }

    public String getVersion() {
        return "3.0";
    }

    private ISmartcardServiceReader getReader(String name) throws IOException {
        try {
            SmartcardError error = new SmartcardError();
            ISmartcardServiceReader reader = this.mSmartcardService.getReader(name, error);
            if (error.isSet()) {
                error.throwException();
            }
            return reader;
        }
        catch (RemoteException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    ISmartcardServiceCallback getCallback() {
        return this.mCallback;
    }

    private void initReadersMap() {
        String[] readerNames;
        try {
            readerNames = this.mSmartcardService.getReaders();
        }
        catch (RemoteException e2) {
            throw new IllegalStateException(e2);
        }
        this.mReaders = new HashMap<String, Reader>();
        for (String readerName : readerNames) {
            try {
                this.mReaders.put(readerName, new Reader(this, this.getReader(readerName), readerName));
            }
            catch (Exception e3) {
                Log.w((String)SERVICE_TAG, (String)("Error adding reader " + readerName), (Throwable)e3);
            }
        }
    }

    private Reader[] sortReaders() {
        Reader reader;
        ArrayList<Reader> readersList = new ArrayList<Reader>();
        int i2 = 1;
        while ((reader = this.mReaders.get("SIM" + i2)) != null) {
            readersList.add(reader);
            ++i2;
        }
        i2 = 1;
        while ((reader = this.mReaders.get("eSE" + i2)) != null) {
            readersList.add(reader);
            ++i2;
        }
        i2 = 1;
        while ((reader = this.mReaders.get("SD" + i2)) != null) {
            readersList.add(reader);
            ++i2;
        }
        for (Reader r : this.mReaders.values()) {
            if (readersList.contains(r)) continue;
            readersList.add(r);
        }
        return readersList.toArray(new Reader[readersList.size()]);
    }

    public static interface CallBack {
        public void serviceConnected(SEService var1);
    }
}

