/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.simalliance.openmobileapi.Channel;
import org.simalliance.openmobileapi.Reader;
import org.simalliance.openmobileapi.service.ISmartcardServiceChannel;
import org.simalliance.openmobileapi.service.ISmartcardServiceSession;
import org.simalliance.openmobileapi.service.SmartcardError;

public class Session {
    private final Object mLock = new Object();
    private final Reader mReader;
    private final ISmartcardServiceSession mSession;

    Session(ISmartcardServiceSession session, Reader reader) {
        this.mReader = reader;
        this.mSession = session;
    }

    public Reader getReader() {
        return this.mReader;
    }

    public byte[] getATR() {
        if (this.mReader.getSEService() == null || !this.mReader.getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mSession == null) {
            throw new IllegalStateException("service session is null");
        }
        try {
            return this.mSession.getAtr();
        }
        catch (RemoteException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.mReader.getSEService() == null || !this.mReader.getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mSession != null) {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    SmartcardError error = new SmartcardError();
                    this.mSession.close(error);
                    if (error.isSet()) {
                        error.throwException();
                    }
                }
                catch (Exception e2) {
                    Log.e((String)this.getClass().getSimpleName(), (String)"Error closing session", (Throwable)e2);
                }
            }
        }
    }

    public boolean isClosed() {
        try {
            return this.mSession == null || this.mSession.isClosed();
        }
        catch (RemoteException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannels() {
        if (this.mReader.getSEService() == null || !this.mReader.getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mSession != null) {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    SmartcardError error = new SmartcardError();
                    this.mSession.closeChannels(error);
                    if (error.isSet()) {
                        error.throwException();
                    }
                }
                catch (Exception e2) {
                    Log.e((String)this.getClass().getSimpleName(), (String)"Error closing channels", (Throwable)e2);
                }
            }
        }
    }

    public Channel openBasicChannel(byte[] aid, byte p2) throws IOException, IllegalStateException, IllegalArgumentException, SecurityException, NoSuchElementException, UnsupportedOperationException {
        if (this.mReader.getSEService() == null || !this.mReader.getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mSession == null) {
            throw new IllegalStateException("service session is null");
        }
        if (this.getReader() == null) {
            throw new IllegalStateException("reader must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                SmartcardError error = new SmartcardError();
                ISmartcardServiceChannel channel = this.mSession.openBasicChannel(aid, p2, this.mReader.getSEService().getCallback(), error);
                if (error.isSet()) {
                    error.throwException();
                }
                if (channel == null) {
                    return null;
                }
                return new Channel(this, channel);
            }
            catch (RemoteException e2) {
                throw new IllegalStateException(e2.getMessage());
            }
        }
    }

    public Channel openBasicChannel(byte[] aid) throws IOException, IllegalStateException, IllegalArgumentException, SecurityException, NoSuchElementException, UnsupportedOperationException {
        return this.openBasicChannel(aid, (byte)0);
    }

    public Channel openLogicalChannel(byte[] aid, byte p2) throws IOException, IllegalStateException, IllegalArgumentException, SecurityException, NoSuchElementException, UnsupportedOperationException {
        if (this.mReader.getSEService() == null || !this.mReader.getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mSession == null) {
            throw new IllegalStateException("service session is null");
        }
        if (this.getReader() == null) {
            throw new IllegalStateException("reader must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                SmartcardError error = new SmartcardError();
                ISmartcardServiceChannel channel = this.mSession.openLogicalChannel(aid, p2, this.mReader.getSEService().getCallback(), error);
                if (error.isSet()) {
                    error.throwException();
                }
                if (channel == null) {
                    return null;
                }
                return new Channel(this, channel);
            }
            catch (RemoteException e2) {
                throw new IllegalStateException(e2.getMessage());
            }
        }
    }

    public Channel openLogicalChannel(byte[] aid) throws IOException, IllegalStateException, IllegalArgumentException, SecurityException, NoSuchElementException, UnsupportedOperationException {
        return this.openLogicalChannel(aid, (byte)0);
    }
}

