/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.internal;

public final class ByteArrayConverter {
    private ByteArrayConverter() {
    }

    public static String byteArrayToPathString(byte[] rawPath) throws IllegalArgumentException {
        if (rawPath.length % 2 != 0) {
            throw new IllegalArgumentException("Invald path");
        }
        byte[] buffer = new byte[2];
        String path = "";
        for (int i2 = 0; i2 < rawPath.length; i2 += 2) {
            System.arraycopy((byte[])rawPath, (int)i2, (byte[])buffer, (int)0, (int)2);
            String fid = ByteArrayConverter.byteArrayToHexString(buffer);
            if (fid.equalsIgnoreCase("3F00")) continue;
            path = path.concat(fid);
            if (i2 == rawPath.length - 2) continue;
            path = path.concat(":");
        }
        return path;
    }

    public static String byteArrayToHexString(byte[] array, int offset, int length) {
        if (array == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < length; ++i2) {
            sb.append(String.format("%02x", array[offset + i2] & 0xFF));
        }
        return sb.toString();
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        if (byteArray == null) {
            return "";
        }
        return ByteArrayConverter.byteArrayToHexString(byteArray, 0, byteArray.length);
    }

    public static byte[] hexStringToByteArray(String str, int offset, int length) {
        if (length % 2 != 0) {
            throw new IllegalArgumentException("length must be multiple of 2");
        }
        str = str.toUpperCase();
        byte[] outputBytes = new byte[str.length() / 2];
        for (int i2 = 0; i2 < length; i2 += 2) {
            char c1 = str.charAt(i2 + offset);
            char c2 = str.charAt(i2 + 1 + offset);
            if (!ByteArrayConverter.isHexChar(c1) || !ByteArrayConverter.isHexChar(c2)) {
                throw new IllegalArgumentException("Invalid char found");
            }
            outputBytes[i2 / 2] = (byte)((Character.digit(c1, 16) << 4) + Character.digit(c2, 16));
        }
        return outputBytes;
    }

    public static byte[] hexStringToByteArray(String str) {
        return ByteArrayConverter.hexStringToByteArray(str, 0, str.length());
    }

    public static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int byteArrayToInt(byte[] byteArray) {
        switch (byteArray.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return byteArray[0] & 0xFF;
            }
            case 2: {
                return (byteArray[0] & 0xFF) << 8 | byteArray[1] & 0xFF;
            }
            case 3: {
                return (byteArray[0] & 0xFF) << 16 | (byteArray[1] & 0xFF) << 8 | byteArray[2] & 0xFF;
            }
        }
        return (byteArray[0] & 0xFF) << 24 | (byteArray[1] & 0xFF) << 16 | (byteArray[2] & 0xFF) << 8 | byteArray[3] & 0xFF;
    }

    public static boolean isHexChar(char c2) {
        if (Character.isLowerCase(c2)) {
            c2 = Character.toUpperCase(c2);
        }
        return c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F';
    }
}

