/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.internal;

import java.util.ArrayList;

public final class HistoricalBytesUtilities {
    private HistoricalBytesUtilities() {
    }

    public static byte[] getHistBytes(byte[] atr) {
        int position = 1;
        byte tdi = atr[position];
        boolean areNextInterfaceBytesPresent = (tdi & 0xF0) != 0;
        ArrayList<Integer> tValues = new ArrayList<Integer>();
        tValues.add(tdi & 0xF);
        ++position;
        while (areNextInterfaceBytesPresent) {
            if ((tdi & 0x10) != 0) {
                ++position;
            }
            if ((tdi & 0x20) != 0) {
                ++position;
            }
            if ((tdi & 0x40) != 0) {
                ++position;
            }
            if ((tdi & 0x80) != 0) {
                tdi = atr[position];
                areNextInterfaceBytesPresent = (tdi & 0xF0) != 0;
                tValues.add(tdi & 0xF);
                ++position;
                continue;
            }
            areNextInterfaceBytesPresent = false;
        }
        int length = atr.length - position;
        if (HistoricalBytesUtilities.isTckPresent(tValues)) {
            --length;
        }
        byte[] historicalBytes = new byte[length];
        System.arraycopy((byte[])atr, (int)position, (byte[])historicalBytes, (int)0, (int)length);
        return historicalBytes;
    }

    private static boolean isTckPresent(ArrayList<Integer> tValues) {
        return tValues.size() != 1 || !tValues.contains(0);
    }
}

