/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.util;

public class CommandApdu {
    private byte mCla;
    private byte mIns;
    private byte mP1;
    private byte mP2;
    private byte[] mData;
    private Integer mLe;

    private CommandApdu() {
    }

    public CommandApdu(byte cla, byte ins, byte p1, byte p2) throws IllegalArgumentException {
        this.setCla(cla);
        this.setIns(ins);
        this.setP1(p1);
        this.setP2(p2);
    }

    public CommandApdu(byte cla, byte ins, byte p1, byte p2, int le) throws IllegalArgumentException {
        this.setCla(cla);
        this.setIns(ins);
        this.setP1(p1);
        this.setP2(p2);
        this.setLe(le);
    }

    public CommandApdu(byte cla, byte ins, byte p1, byte p2, byte[] data) throws IllegalArgumentException {
        this.setCla(cla);
        this.setIns(ins);
        this.setP1(p1);
        this.setP2(p2);
        this.setData(data);
    }

    public CommandApdu(byte cla, byte ins, byte p1, byte p2, byte[] data, int le) throws IllegalArgumentException {
        this.setCla(cla);
        this.setIns(ins);
        this.setP1(p1);
        this.setP2(p2);
        this.setData(data);
        this.setLe(le);
    }

    public CommandApdu(byte[] cmdApduAsByteArray) throws IllegalArgumentException {
        if (cmdApduAsByteArray.length < 4) {
            throw new IllegalArgumentException("Invalid length for command (" + cmdApduAsByteArray.length + ").");
        }
        this.setCla(cmdApduAsByteArray[0]);
        this.setIns(cmdApduAsByteArray[1]);
        this.setP1(cmdApduAsByteArray[2]);
        this.setP2(cmdApduAsByteArray[3]);
        if (cmdApduAsByteArray.length != 4) {
            if (cmdApduAsByteArray.length == 5) {
                this.setLe(0xFF & cmdApduAsByteArray[4]);
            } else if (cmdApduAsByteArray[4] != 0) {
                int lc = 0xFF & cmdApduAsByteArray[4];
                if (lc == 0) {
                    throw new IllegalArgumentException("Lc can't be 0");
                }
                if (cmdApduAsByteArray.length != 5 + lc) {
                    if (cmdApduAsByteArray.length == 6 + lc) {
                        this.setLe(0xFF & cmdApduAsByteArray[cmdApduAsByteArray.length - 1]);
                    } else {
                        throw new IllegalArgumentException("Unexpected value of Lc (" + lc + ")");
                    }
                }
                this.mData = new byte[lc];
                System.arraycopy((byte[])cmdApduAsByteArray, (int)5, (byte[])this.mData, (int)0, (int)lc);
            } else if (cmdApduAsByteArray.length == 7) {
                this.setLe(((0xFF & cmdApduAsByteArray[5]) << 8) + (0xFF & cmdApduAsByteArray[6]));
            } else {
                if (cmdApduAsByteArray.length <= 7) {
                    throw new IllegalArgumentException("Unexpected value of Lc or Le" + cmdApduAsByteArray.length);
                }
                int lc = ((0xFF & cmdApduAsByteArray[5]) << 8) + (0xFF & cmdApduAsByteArray[6]);
                if (lc == 0) {
                    throw new IllegalArgumentException("Lc can't be 0");
                }
                if (cmdApduAsByteArray.length != 7 + lc) {
                    if (cmdApduAsByteArray.length == 9 + lc) {
                        this.setLe(((0xFF & cmdApduAsByteArray[cmdApduAsByteArray.length - 2]) << 8) + (0xFF & cmdApduAsByteArray[cmdApduAsByteArray.length - 1]));
                    } else {
                        throw new IllegalArgumentException("Unexpected value of Lc (" + lc + ")--- 9 -" + cmdApduAsByteArray.length);
                    }
                }
                this.mData = new byte[lc];
                System.arraycopy((byte[])cmdApduAsByteArray, (int)7, (byte[])this.mData, (int)0, (int)lc);
            }
        }
    }

    public byte[] toByteArray() {
        byte[] array;
        if (!this.isExtendedLength()) {
            if (this.mData == null && this.mLe == null) {
                array = new byte[]{this.mCla, this.mIns, this.mP1, this.mP2};
            } else if (this.mData == null && this.mLe != null) {
                array = new byte[]{this.mCla, this.mIns, this.mP1, this.mP2, (byte)(this.mLe & 0xFF)};
            } else if (this.mData != null && this.mLe == null) {
                array = new byte[5 + this.mData.length];
                array[0] = this.mCla;
                array[1] = this.mIns;
                array[2] = this.mP1;
                array[3] = this.mP2;
                array[4] = (byte)(this.mData.length & 0xFF);
                System.arraycopy((byte[])this.mData, (int)0, (byte[])array, (int)5, (int)this.mData.length);
            } else {
                array = new byte[6 + this.mData.length];
                array[0] = this.mCla;
                array[1] = this.mIns;
                array[2] = this.mP1;
                array[3] = this.mP2;
                array[4] = (byte)(this.mData.length & 0xFF);
                System.arraycopy((byte[])this.mData, (int)0, (byte[])array, (int)5, (int)this.mData.length);
                array[array.length - 1] = (byte)(this.mLe & 0xFF);
            }
        } else if (this.mData == null && this.mLe != null) {
            array = new byte[]{this.mCla, this.mIns, this.mP1, this.mP2, 0, (byte)(this.mLe >> 8 & 0xFF), (byte)(this.mLe & 0xFF)};
        } else if (this.mData != null && this.mLe == null) {
            array = new byte[7 + this.mData.length];
            array[0] = this.mCla;
            array[1] = this.mIns;
            array[2] = this.mP1;
            array[3] = this.mP2;
            array[4] = 0;
            array[5] = (byte)(this.mData.length >> 8 & 0xFF);
            array[6] = (byte)(this.mData.length & 0xFF);
            System.arraycopy((byte[])this.mData, (int)0, (byte[])array, (int)7, (int)this.mData.length);
        } else {
            array = new byte[9 + this.mData.length];
            array[0] = this.mCla;
            array[1] = this.mIns;
            array[2] = this.mP1;
            array[3] = this.mP2;
            array[4] = 0;
            array[5] = (byte)(this.mData.length >> 8 & 0xFF);
            array[6] = (byte)(this.mData.length & 0xFF);
            System.arraycopy((byte[])this.mData, (int)0, (byte[])array, (int)7, (int)this.mData.length);
            array[array.length - 2] = (byte)(this.mLe >> 8 & 0xFF);
            array[array.length - 1] = (byte)(this.mLe & 0xFF);
        }
        return array;
    }

    public CommandApdu cloneWithLe(int le) {
        if (this.mData == null) {
            return new CommandApdu(this.mCla, this.mIns, this.mP1, this.mP2, (byte)le);
        }
        return new CommandApdu(this.mCla, this.mIns, this.mP1, this.mP2, this.mData, (byte)le);
    }

    private void setCla(byte cla) throws IllegalArgumentException {
        if (cla == -1) {
            throw new IllegalArgumentException("Invalid value of CLA (" + Integer.toHexString(cla) + ")");
        }
        this.mCla = cla;
    }

    private void setIns(byte ins) throws IllegalArgumentException {
        if ((ins & 0xF0) == 96 || (ins & 0xF0) == 144) {
            throw new IllegalArgumentException("Invalid value of INS (" + Integer.toHexString(ins) + "). " + "0x6X and 0x9X are not valid values");
        }
        this.mIns = ins;
    }

    private void setP1(byte p1) {
        this.mP1 = p1;
    }

    private void setP2(byte p2) {
        this.mP2 = p2;
    }

    private void setData(byte[] data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        if (data.length > 65535) {
            throw new IllegalArgumentException("Data too long.");
        }
        if (data.length == 0) {
            throw new IllegalArgumentException("Data must not be empty.");
        }
        this.mData = new byte[data.length];
        System.arraycopy((byte[])data, (int)0, (byte[])this.mData, (int)0, (int)data.length);
    }

    private void setLe(int le) throws IllegalArgumentException {
        if (le < 0 || le > 65536) {
            throw new IllegalArgumentException("Invalid value for le parameter (" + le + ").");
        }
        this.mLe = le;
    }

    public boolean isExtendedLength() {
        return this.mLe != null && this.mLe > 256 || this.mData != null && this.mData.length > 255;
    }
}

