/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.util;

public class ResponseApdu {
    private byte[] mData;
    private byte[] mSw;

    public ResponseApdu(byte[] response) {
        if (response == null) {
            throw new IllegalArgumentException("Response must not be null.");
        }
        if (response.length < 2 || response.length > 65538) {
            throw new IllegalArgumentException("Invalid response length (" + response.length + ").");
        }
        if (response.length > 2) {
            this.mData = new byte[response.length - 2];
            System.arraycopy((byte[])response, (int)0, (byte[])this.mData, (int)0, (int)this.mData.length);
        }
        this.mSw = new byte[2];
        System.arraycopy((byte[])response, (int)(response.length - 2), (byte[])this.mSw, (int)0, (int)2);
    }

    public byte[] getData() {
        return this.mData;
    }

    public byte[] getSw() {
        return this.mSw;
    }

    public int getSwValue() {
        return ((this.mSw[0] & 0xFF) << 8) + (this.mSw[1] & 0xFF);
    }

    public boolean isSuccess() {
        return this.getSwValue() == 36864;
    }

    public boolean isWarning() {
        return this.mSw[0] == 98 || this.mSw[0] == 99;
    }

    public int getSw1Value() {
        return 0xFF & this.mSw[0];
    }

    public int getSw2Value() {
        return 0xFF & this.mSw[1];
    }
}

