/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.board;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperJniApiBinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

@AutoChipForCall
public class OnboardJniApiBinder
extends SuperJniApiBinder {
    private static final String TAG = OnboardJniApiBinder.class.getSimpleName();
    JNIAPI jniapi = new JNIAPI();
    private static OnboardJniApiBinder instance;
    private ArrayList<String> classList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnboardJniApiBinder getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (instance != null) return instance;
        Class<OnboardJniApiBinder> clazz = OnboardJniApiBinder.class;
        synchronized (OnboardJniApiBinder.class) {
            if (instance != null) return instance;
            instance = new OnboardJniApiBinder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private OnboardJniApiBinder(Context context) {
        super(context);
    }

    @Override
    protected JNIAPI getApi() {
        return this.jniapi;
    }

    public int SpiConfig(int int0, int int1, int por, int power, int qwk, int speed) {
        Log.e((String)TAG, (String)"start spi config");
        return this.getApi().SpiConfig(int0, int1, por, power, qwk, speed);
    }

    @Override
    public int OpenDev(int index, long[] hHandle) throws RemoteException {
        int ret = this.getApi().OpenDev(index, hHandle);
        this.mHandle = ret == 0 ? hHandle[0] : 0L;
        return ret;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) throws RemoteException {
        Log.v((String)TAG, (String)"This method(OpenDevByName) doesn't work!");
        return 0;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) throws RemoteException {
        Log.v((String)TAG, (String)"This method(OpenDevByNameEx) doesn't work!");
        return 0;
    }

    @Override
    protected int selfOpenDev() {
        int cardType = Integer.valueOf(System.getProperty("_cardtype_", "-1"));
        if (cardType == -1) {
            return this.initFirst();
        }
        if (cardType == 2304) {
            return this.openThirdChip();
        }
        return this.initEnumOpenByCardType(cardType);
    }

    private int initFirst() {
        Properties properties;
        String flag;
        int ret;
        long[] devHandle = new long[1];
        int[] devNum = new int[1];
        int devNumSum = 0;
        try {
            this.EnumDev(531, devNum);
            devNumSum += devNum[0];
            this.EnumDev(535, devNum);
            devNumSum += devNum[0];
            this.EnumDev(2560, devNum);
            devNumSum += devNum[0];
            ret = this.EnumDev(536, devNum);
            devNumSum += devNum[0];
        }
        catch (RemoteException e) {
            e.printStackTrace();
            ret = -1;
        }
        Log.e((String)TAG, (String)("EnumDev num = " + devNumSum));
        if (devNumSum <= 0) {
            ret = -97;
        } else {
            try {
                ret = this.OpenDev(0, devHandle);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (ret != 0 && "true".equals(flag = (properties = MultiJniApiConfig.getInstance(this.mContext).getMultiCardFromProperties(this.mContext)).getProperty("isOpenThirdChip"))) {
            ret = this.openThirdChip();
        }
        return ret;
    }

    private int initEnumOpenByCardType(int cardtype) {
        int ret;
        long[] devHandle = new long[1];
        int[] devNum = new int[1];
        try {
            ret = this.EnumDev(cardtype, devNum);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            int ret2 = -97;
            return ret2;
        }
        if (devNum[0] <= 0) {
            ret = -97;
        } else {
            try {
                ret = this.OpenDev(0, devHandle);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    protected int getChipType() {
        return 1;
    }

    @Override
    public JniApiParam getJniApiParam() {
        return super.getJniApiParam();
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        return super.callMethod(bundle);
    }

    private int openThirdChip() {
        if (this.classList == null) {
            this.classList = new ArrayList();
            ApplicationInfo appInfo = null;
            try {
                appInfo = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            if (appInfo == null) {
                return -97;
            }
            Bundle metaData = appInfo.metaData;
            Set strings = metaData.keySet();
            for (String key : strings) {
                String value = metaData.getString(key);
                if (!"OnboardThird".equals(value)) continue;
                this.classList.add(key);
            }
        }
        for (String className : this.classList) {
            try {
                Class<?> aClass = Class.forName(className);
                Method open = aClass.getDeclaredMethod("open", Context.class, JNIAPI.class, long[].class);
                long[] devHandle = new long[1];
                int ret = (Integer)open.invoke(null, this.mContext, this.getApi(), devHandle);
                if (ret != 0) continue;
                this.mHandle = devHandle[0];
                return ret;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return -97;
    }
}

