package com.xdja.multichip.process;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.util.Log;

/**
 * 主进程启动，会通知各个卡进程
 * 防止主进程重新启动时，卡进程已存在，主进程没有绑定卡进程事件，所以需要主进程重新启动时，通知各个卡进程，向主进程注册事件
 * @author hyh
 * @data 2021/2/19 15:09
 */
public abstract class MainProcessStartUpReceiver extends BroadcastReceiver {
    public final static String PROCESS_RECEIVER_ACTION = "com.xdja.multichip.compat.CardProcessReceiver";
    private final static String TAG = "MainProcessStartUp";

    @Override
    public void onReceive(Context context, Intent intent) {
        Log.e(TAG, "main process startup notify card process pid " + Binder.getCallingPid());
    }

    public static void sendMainProcessStartUpEvent(Context context) {
        try {
            Intent intent = new Intent();
            intent.setPackage(context.getPackageName());
            intent.setAction(PROCESS_RECEIVER_ACTION);
            context.sendBroadcast(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
