package com.xdja.multichip.process.board;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperJniApiBinder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/13 <br/>
 */
@AutoChipForCall
public class OnboardJniApiBinder extends SuperJniApiBinder {
    private static final String TAG = OnboardJniApiBinder.class.getSimpleName();

    JNIAPI jniapi = new JNIAPI();

    private static OnboardJniApiBinder instance;

    public static OnboardJniApiBinder getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (instance == null) {
            synchronized (OnboardJniApiBinder.class) {
                if (instance == null) {
                    instance = new OnboardJniApiBinder(context);
                }
            }
        }
        return instance;
    }

    private OnboardJniApiBinder(Context context) {
        super(context);
    }

    @Override
    protected JNIAPI getApi() {
        return jniapi;
    }

    public int SpiConfig(int int0, int int1, int por, int power, int qwk, int speed) {
        Log.e(TAG, "start spi config");
        return getApi().SpiConfig(int0, int1, por, power, qwk, speed);
    }

    @Override
    public int OpenDev(int index, long[] hHandle) throws RemoteException {
        int ret = getApi().OpenDev(index, hHandle);
        if (ret == 0) {
            mHandle = hHandle[0];
        } else {
            mHandle = 0;
        }
        return ret;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) throws RemoteException {
        Log.v(TAG, "This method(OpenDevByName) doesn't work!");
        return 0;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) throws RemoteException {
        Log.v(TAG, "This method(OpenDevByNameEx) doesn't work!");
        return 0;
    }

    /**
     * 内部方法：
     * 用于打开设备
     * [
     * modify by zhangxiaolong@xdja.com 2018-11-23
     * 加上缓存，第一目的是解决libsafekey中关于海思芯片EnumDev的bug；
     * 第二目的：加速芯片的查找速度。
     * ]
     *
     * @return
     */
    @Override
    protected int selfOpenDev() {
        int cardType = Integer.valueOf(System.getProperty("_cardtype_", "-1"));
        if (cardType == -1) {
            return initFirst();
        } else {
            if (cardType == JNIAPI.CT_TPARTY) {
                return openThirdChip();
            } else {
                return initEnumOpenByCardType(cardType);
            }
        }
    }


    /**
     * 第一次初始化(内存缓存变量的第一次)
     *
     * @return
     */
    private int initFirst() {
        int ret;
        long[] devHandle = new long[1];
        int[] devNum = new int[1];
        int devNumSum = 0;
        try {
            //modify 2017年9月12日16:41:27 weizg 此处应该只枚举芯片类型的
            EnumDev(JNIAPI.CT_TF_XDJA_CHIP, devNum);
            devNumSum = devNumSum + devNum[0];

            EnumDev(JNIAPI.CT_XDJA_SPI, devNum);
            devNumSum = devNumSum + devNum[0];

            EnumDev(JNIAPI.CT_TEESPI, devNum);
            devNumSum = devNumSum + devNum[0];

            //modify zhangxiaolong 2020-10-28 支持八方执法仪项目
            ret = EnumDev(0x0218, devNum);
            devNumSum = devNumSum + devNum[0];
        } catch (RemoteException e) {
            e.printStackTrace();
            ret = -1;
        }

        Log.e(TAG, "EnumDev num = " + devNumSum);
        if (devNumSum <= 0) {
            ret = -97;
        } else {
            try {
                ret = OpenDev(0, devHandle);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        //add by zhangxiaolong 2018-11-22，适配海思芯片
        if (ret != 0) {
            //add by zhangxiaolong 2019-11-20 增加判断是否查找其他公司芯片的逻辑
            Properties properties = MultiJniApiConfig.getInstance(mContext).getMultiCardFromProperties(mContext);
            String flag = properties.getProperty(MultiJniApiConfig.KEY_ISOPEN_THIRD_CHIP);
            if ("true".equals(flag)) {
                ret = openThirdChip();
            }
        }
        return ret;
    }

    private int initEnumOpenByCardType(int cardtype) {
        int ret;
        long[] devHandle = new long[1];
        int[] devNum = new int[1];
        try {
            //modify 2017年9月12日16:41:27 weizg 此处应该只枚举芯片类型的
            ret = EnumDev(cardtype, devNum);
        } catch (RemoteException e) {
            e.printStackTrace();
            ret = -97;
            return ret;
        }

        if (devNum[0] <= 0) {
            ret = -97;
        } else {
            try {
                ret = OpenDev(0, devHandle);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /**
     * 得到芯片类型，参看：{@link JniApiParam#TYPE_ONBOARD}, {@link JniApiParam#TYPE_TF}, {@link JniApiParam#TYPE_BLUETOOTH}
     *
     * @return
     */
    @Override
    protected int getChipType() {
        return JniApiParam.TYPE_ONBOARD;
    }

    @Override
    public JniApiParam getJniApiParam() {
        return super.getJniApiParam();
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        return super.callMethod(bundle);
    }


    private ArrayList<String> classList = null;

    /**
     * 调用其他公司的芯片。
     * 具体参看{@link ForThird}的实现。
     * 需要注意的是：
     * 1. 实现的类需要有一个 public static int open(Context context, JNIAPI jniapi, long[] devHandle) 这样的方法；
     * 这个方法，如果找到芯片了，就返回0，并把handle的值放在devHandle[0]中；
     * 否则，返回-97；
     * 2. 需要在AndroidManifest.xml中的<application>的标签中声明一下：
     * <meta-data android:name="具体的类名" android:value="OnboardThird"/>
     *
     * @return
     */
    private int openThirdChip() {
        if (classList == null) {
            classList = new ArrayList<>();
            ApplicationInfo appInfo = null;
            try {
                appInfo = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), PackageManager.GET_META_DATA);
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            if (appInfo == null) {
                return -97;
            }
            Bundle metaData = appInfo.metaData;
            Set<String> strings = metaData.keySet();
            for (String key : strings) {
                String value = metaData.getString(key);
                if ("OnboardThird".equals(value)) {
                    classList.add(key);
                }
            }
        }

        for (String className : classList) {
            try {
                Class<?> aClass = Class.forName(className);
                Method open = aClass.getDeclaredMethod("open", Context.class, JNIAPI.class, long[].class);
                long[] devHandle = new long[1];
                int ret = (int) open.invoke(null, mContext, getApi(), devHandle);
                if (ret == 0) {
                    mHandle = devHandle[0];
                    return ret;
                }
            } catch (ClassNotFoundException | NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }


        return -97;
    }

}
