package com.xdja.multichip.process.board;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;

import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;

import java.util.ArrayList;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/5/26 <br/>
 * 操作板载芯片的service
 */
public class OnboardJniApiHandle {

    private static OnboardJniApiHandle instance;

    private OnboardJniApiHandle() {

    }

    public static OnboardJniApiHandle getInstance() {
        if (instance == null) {
            synchronized (OnboardJniApiHandle.class) {
                if (instance == null) {
                    instance = new OnboardJniApiHandle();
                }
            }
        }
        return instance;
    }

    /**
     * 得到板载芯片的所有JniApi的实例。
     * 目前只有一个手机上应该只有一个芯片。
     * 关于双系统上的卡操作，在JNIAPI加载so的时候进行判断；
     * 当是卡操作服务进程时，判断是否有卡操作服务，当有卡操作服务时，加载了libunitservicekey.so，否则加载libsafekey.so
     * 如果不是卡操作服务进程，直接加载libsafekey.so
     *
     * @param context
     * @return
     * @throws RemoteException
     */
    public ArrayList<Bundle> getAllJniApiParams(Context context) {
        ArrayList<Bundle> list = new ArrayList<>();
        OnboardJniApiBinder binder = OnboardJniApiBinder.getInstance(context);
        JniApiParam param = binder.getJniApiParam();
        if (param != null) {
            sendCardStatus(context,param);
            Bundle bundle = new Bundle();
            bundle.putBinder(ParamKeywords.KEY_Binder_Binder, binder);
            bundle.putParcelable(ParamKeywords.KEY_Parcelable_JniApiParam, param);
            list.add(bundle);
        }
        return list;
    }

    public Bundle spiConfig(Context context, Bundle configBundle) {
        if (configBundle == null) return null;
        int int0 = configBundle.getInt(ParamKeywords.SPICONFIG_INT0);
        int int1 = configBundle.getInt(ParamKeywords.SPICONFIG_INT1);
        int por = configBundle.getInt(ParamKeywords.SPICONFIG_POR);
        int power = configBundle.getInt(ParamKeywords.SPICONFIG_POWER);
        int qwk = configBundle.getInt(ParamKeywords.SPICONFIG_QWK);
        int speed = configBundle.getInt(ParamKeywords.SPICONFIG_SPEED);
        Bundle result = new Bundle();
        int ret = OnboardJniApiBinder.getInstance(context).SpiConfig(int0, int1, por, power, qwk, speed);
        result.putInt(ParamKeywords.KEY_SPICONFIG_RET, ret);
        return result;
    }


    private void sendCardStatus(Context context, JniApiParam param) {
        if (param == null) {
            return;
        }
        JarMultiChipStatusManager.getInstance().sendCardStatus(context, param.cardId, param.chipType, 1);
    }

}

