package com.xdja.multichip.process.board;

import android.content.Intent;
import android.os.Handler;
import android.os.Messenger;

import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.CardProcessService;
import com.xdja.multichip.process.SuperThreadRun;
import com.xdja.multichip.process.coveredcard.CCProcessReceiver;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/5/26 <br/>
 * 操作板载芯片的service
 */
public class OnboardProcessService extends CardProcessService {

    private Messenger messenger = new Messenger(new Handler());

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        SuperThreadRun.service.submit(new Runnable() {
            @Override
            public void run() {
                JarMultiChipStatusManager.getInstance().cardProcessRegister(getApplicationContext(), messenger.getBinder(), JniApiParam.TYPE_ONBOARD);
            }
        });

        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        receiverStartUpCardProcessReceiver(new OnboardProcessReceiver());
    }
}

