package com.xdja.multichip.process.coveredcard;

import android.util.Pair;

import com.xdja.SafeKey.XDJA_DEVINFO;

import java.util.HashMap;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/4/2 <br/>
 */

public class CCCacheManager {
    private static CCCacheManager instance = new CCCacheManager();
    private XDJA_DEVINFO devInfo;
    private HashMap<String, Pair<byte[], Integer>> certMap = new HashMap<>();


    private CCCacheManager() {
    }

    public static CCCacheManager getInstance() {
        return instance;
    }

    /**
     * 设置DevInfo缓存
     *
     * @param devInfo
     */
    public void setDevInfo(XDJA_DEVINFO devInfo) {
        this.devInfo = devInfo;
    }

    /**
     * 设置证书缓存
     *
     * @param fid
     * @param certBuf
     * @param certLen
     */
    public void setCert(byte[] fid, byte[] certBuf, int certLen) {
        certMap.put(new String(fid), Pair.create(certBuf, certLen));
    }

    /**
     * @param fid
     */
    public void removeCert(byte[] fid) {
        certMap.remove(new String(fid));
    }

    public XDJA_DEVINFO getDevInfo() {
        if (devInfo == null) {
            return null;
        }
        return devInfo;
    }

    public Pair<byte[], Integer> getCert(byte[] fid) {
        return certMap.get(new String(fid));
    }

    /**
     * 清楚缓存
     */
    public void clear() {
        devInfo = null;
        certMap.clear();
    }


}
