package com.xdja.multichip.process.vhsm;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.SuperChipForCall;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/12/27 <br/>
 */
public class VhsmChipForCall extends SuperChipForCall {
    public static final String NAME_PROCESS_VHSM = "vhsm";

    @Override
    protected Class getProviderClass() {
        return VhsmProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_VHSM;
    }

    @Override
    public boolean isCanUse() {
        //modify by zhangxiaolong 2019-7-10 先不支持单机版虚拟卡，因为当前单机版虚拟卡版本在取id时，默认取的是imei，
        // 之后有可能会改变这种取法，为了兼容问题，暂且不支持
        return false;
//        boolean flag = PermissionUtil.isGranted(context, Manifest.permission.READ_PHONE_STATE);
//        if (flag){
//            NetVhsmChipForCall netForCall = new NetVhsmChipForCall(context);
//            boolean canUse = netForCall.isCanUse();
//            if (canUse){
//                return false;
//            }
//        }
//        return flag;
    }

    @Override
    public int getChipType() {
        return JniApiParam.TYPE_VHSM;
    }

    @Override
    public void setContext(Context context) {
        super.context = context;
    }

    public Bundle createDefaultVhsm(){
        String authority = getProviderAuthority(context, getProviderClass().getName());
        if (TextUtils.isEmpty(authority)) {
            Log.e(TAG, getProviderClass().getName() + " authority is null.");
            return null;
        }
        Uri uri = Uri.parse("content://" + authority);
        ContentResolver resolver = context.getContentResolver();
        Bundle bundle =  resolver.call(uri, ParamKeywords.KEY_METHOD_CreateDefaultVhsm, "", null);
        return bundle;
    }
}
