package com.xdja.multichip.process.vhsm.net;

import android.Manifest;
import android.content.Context;
import android.os.Environment;

import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperChipForCall;
import com.xdja.multichip.utils.PermissionUtil;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/5/15 <br/>
 */
@AutoChipForCall
public class NetVhsmChipForCall extends SuperChipForCall {

    public static final String NAME_PROCESS_NETVHSM = "netVhsm";

    @Override
    protected Class getProviderClass() {
        return NetVhsmProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_NETVHSM;
    }

    static final String FILE_DIR = "xdja/vhsm/net/";
    static final String RANDFILEPATH = FILE_DIR + "rand.bin";
    static final String KDATFILEPATH = FILE_DIR + "vhsm.dat";
    static final String WBOXFILEPATH = FILE_DIR + "wbox.lib";
    static final String VHSMLIBFILEPATH = FILE_DIR + "vhsm.lib";

    @Override
    public boolean isCanUse() {
        //add 2019年11月4日14:45:54 weizg
        //新增判断，如果当前没有read_phone_state等权限，则不启动该进程
        List<String> permissions = new ArrayList<>();
        permissions.add(Manifest.permission.READ_PHONE_STATE);
        permissions.add(Manifest.permission.READ_EXTERNAL_STORAGE);
        permissions.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);

        List<String> deniedPermissions = PermissionUtil.getDeniedPermissions(context, permissions);

        //如果存在一个权限没有获取到，则不启动vhsm进程
        if (deniedPermissions.size() > 0) {
            return false;
        }


        File storageDir = Environment.getExternalStorageDirectory();
        File randFile = new File(storageDir, RANDFILEPATH);
        if (!randFile.exists()) {
            return false;
        }
        File wboxFile = new File(storageDir, WBOXFILEPATH);
        if (!wboxFile.exists()) {
            return false;
        }
        File kdatFile = new File(storageDir, KDATFILEPATH);
        if (!kdatFile.exists()) {
            return false;
        }
        return true;
    }

    @Override
    public int getChipType() {
        return JniApiParam.TYPE_VHSM_NET;
    }

    @Override
    public void setContext(Context context) {
        super.context = context;
    }
}
