package com.xdja.multichip.process.vhsm.net;

import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Messenger;
import android.util.Log;

import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.CardProcessService;
import com.xdja.multichip.process.SuperThreadRun;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/10/22 <br/>
 */
public class NetVhsmService extends CardProcessService {
    private static final String TAG = "NetVhsmServiceTag";
    private Messenger messenger = new Messenger(new Handler());

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        receiverStartUpCardProcessReceiver(new NetVhsmProcessReceiver());
        Log.d(TAG, NetVhsmService.class.getSimpleName() + " onCreate");
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        SuperThreadRun.service.submit(new Runnable() {
            @Override
            public void run() {
                JarMultiChipStatusManager.getInstance().cardProcessRegister(getApplicationContext(), messenger.getBinder(), JniApiParam.TYPE_VHSM_NET);
            }
        });
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.d(TAG, NetVhsmService.class.getSimpleName() + " onDestory");
    }
}
