package com.xdja.multichip.utils;

import android.util.Log;

/**
 * Created by hyh on 2020/11/26
 * 打印方法调用
 */
public class ChipLog {
    /**
     * 打印当前方法调用者日志
     *
     * @param tag
     * @param msg
     * @param currentMethod 当前方法
     */
    public static void e(String tag, String msg, String currentMethod) {
        Log.e(tag, getFunctionName(currentMethod) + "----->" + msg);
    }

    /**
     * 打印当前方法日志
     * @param tag
     * @param msg
     */
    public static void e(String tag, String msg) {
        Log.e(tag, msg);
    }

    /**
     * 获取当前方法路径名
     *
     * @return 当前方法路径名
     * @作者 hkb
     * @since 2014年11月12日 下午5:13:27
     */
    private static String getFunctionName(String currentMethod) {
        try {
            StackTraceElement[] sts = Thread.currentThread().getStackTrace();
            boolean isPrint = false;
            for (StackTraceElement st : sts) {
                if (isPrint) {
                    return Thread.currentThread().getName() + ": (" + st.getFileName() + ":"
                            + st.getLineNumber() + ") " + st.getMethodName();
                }

                if (st.getMethodName().equals(currentMethod)) {
                    isPrint = true;
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
