package com.xdja.multichip.process.coveredcard;

import android.content.Context;

import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperChipForCall;


/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/12/27 <br/>
 */
@AutoChipForCall
public class CCChipForCall extends SuperChipForCall {

    public static final String NAME_PROCESS_CC = "coveredcard";

    public static final String NAME_SUPPORT_LOWCHANNEL = "supportLowChannel";


    @Override
    protected Class getProviderClass() {
        return CCProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_CC;
    }

    @Override
    public boolean isCanUse() {
        return CCPermission.hasPermission(context);
    }

    @Override
    public int getChipType() {
        return JniApiParam.TYPE_COVERED;
    }

    @Override
    public void setContext(Context context) {
        super.context = context;
    }
}
