package com.xdja.multichip.process.coveredcard;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.util.Log;

import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.process.CardProcessService;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.ProcessExitsReceiver;
import com.xdja.multichip.utils.SharedPreferencesUtil;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by xwy on 2017/9/14.
 */
public class CCProcessProvider extends ContentProvider {
    private static final String TAG = "CCProcessProviderTag";


    @Override
    public boolean onCreate() {
        Log.e(TAG, "onCreate pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + getCallingPackage());

        Context context = getContext();
        if (SharedPreferencesUtil.getCcPersistence(context)){
            CCJniApi.getInstance(context).getTMCAPI().SetLogFlag(true);
        }
        if (!MultiJniApiConfig.getInstance(context).judgeChipCanUse(CCChipForCall.NAME_PROCESS_CC)) {
            return false;
        }
        CardProcessService.startService(context, new Intent(context, CCProcessService.class));

        ProcessExitsReceiver.register(context);
        return false;
    }


    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        Log.e(TAG, "call method: " + method);
        Log.e(TAG, "calling pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + getCallingPackage());
        Bundle bundle = new Bundle();
        if (ParamKeywords.KEY_METHOD_GetJniApiBinder.equals(method)) {
            increaseFlag();
            ArrayList<Bundle> list = CCJniApiHandle.getInstance().getCurrentCoveredCardInfo(getContext());
            bundle.putInt(ParamKeywords.KEY_int_ret, 0);
            bundle.putParcelableArrayList(ParamKeywords.KEY_Parcelable_JniApiParam, list);
            Log.e(TAG, "result list size = " + (list == null ? 0 : list.size()));
            decreaseFlag();
            return bundle;
        }else if (ParamKeywords.KEY_METHOD_CcSetLogFlag.equals(method)){
            return handleSetLogFlag(extras);
        }
        return super.call(method, arg, extras);
    }


    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }


    @Override
    public String getType(Uri uri) {
        return null;
    }


    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    private Bundle handleSetLogFlag(Bundle bundle){
        boolean flag = bundle.getBoolean(ParamKeywords.KEY_boolean_flag, false);
        boolean isPersistence = bundle.getBoolean(ParamKeywords.KEY_boolean_isPersistence, false);
        Log.i(TAG, "flag = " + flag + ", isPersistence = " + isPersistence);
        Context context = getContext();
        SharedPreferencesUtil.setCcPersistence(context, isPersistence);
        CCJniApi.getInstance(context).getTMCAPI().SetLogFlag(flag);
        Bundle result = new Bundle();
        result.putInt(ParamKeywords.KEY_int_ret,0);
        return result;
    }


    /**
     * add by zhangxiaolong 2018-10-16 10:53:22
     * 主要用于解决主进程provider调用贴膜卡进程provider时，
     * 贴膜卡进程直接exit会影响到主进程。
     */
    private static AtomicInteger callingFlag = new AtomicInteger(0);

    private static void increaseFlag() {
        callingFlag.incrementAndGet();
    }

    private static void decreaseFlag() {
        callingFlag.decrementAndGet();
    }

    public static int getCallingFlag() {
        return callingFlag.get();
    }
}
