package com.xdja.multichip.process.coveredcard;

import android.content.Intent;
import android.os.Handler;
import android.os.Messenger;
import android.util.Log;

import com.xdja.multichip.process.CardProcessService;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperThreadRun;

/**
 * Created by xwy on 2017/9/14.
 */

public class CCProcessService extends CardProcessService {
    public static final String TAG = "CCJniApiBinderTag";

    private Messenger messenger = new Messenger(new Handler());

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.e(TAG, "============ onStartCommand....");
        SuperThreadRun.service.submit(new Runnable() {
            @Override
            public void run() {
                JarMultiChipStatusManager.getInstance().cardProcessRegister(getApplicationContext(), messenger.getBinder(), JniApiParam.TYPE_COVERED);
            }
        });
        return super.onStartCommand(intent, flags, startId);
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.e(TAG, "=================== onDestroy ");
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Log.v(TAG, this.getClass().getName() + " onCreate");
        receiverStartUpCardProcessReceiver(new CCProcessReceiver());
        SuperThreadRun.service.submit(new Runnable() {
            @Override
            public void run() {
                if (CCPermission.hasPermission(getApplicationContext())) {
                    CCJniApiHandle.getInstance().getCurrentCoveredCardInfo(getApplicationContext());
                }
            }
        });
    }


}
