package com.xdja.multichip.process.tfcard;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.ProcessExitsReceiver;
import com.xdja.multichip.process.SuperThreadRun;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


class TFJniApiHandle extends SuperThreadRun<ArrayList<Bundle>> {
    public static final String ACTION_TF_MOUNTED = "com_xdja_safekeyservice_tf_mounted";
    public static final String ACTION_TF_REMOVED = "com_xdja_safekeyservice_tf_removed";
    public static final String TAG_CURRRENT_TF = "tag_current_safe_tf";

    private TFJniApiBinder chipBinder = null;
    private final String tag = "XdjaTFProcessService";
    ArrayList<Bundle> tfInfoBundleList = new ArrayList<>();

    private HashMap<String, TFJniApiBinder> pathBinderMap = new HashMap<>();

    private static TFJniApiHandle instance;

    private TFJniApiHandle() {
    }

    public static TFJniApiHandle getInstance() {
        if (instance == null) {
            synchronized (TFJniApiHandle.class) {
                if (instance == null) {
                    instance = new TFJniApiHandle();
                }
            }
        }
        return instance;
    }

    private Context context;

    /**
     * @param context
     * @return
     */
    public ArrayList<Bundle> getCurrentTFCardInfo(Context context) {
        this.context = context;
        return getResult();
    }

    private boolean isChipGetted(ArrayList<Bundle> bundleList, JniApiParam chipParam) {
        boolean isInList = false;

        for (Bundle bundle : bundleList) {
            JniApiParam chipParamInList = bundle.getParcelable(ParamKeywords.KEY_Parcelable_JniApiParam);

            if (chipParamInList != null && chipParam.cardId.
                    equalsIgnoreCase(chipParamInList.cardId)) {
                isInList = true;
                break;
            }
        }
        return isInList;
    }

    /**
     * 处理chipParam
     */
    private TFJniApiBinder handleJniApiBinder(Context context, String tfcardPath) {
        //add 2018年12月6日11:36:51 weizg 首先获取是否在缓存，不在则创建
        chipBinder = pathBinderMap.get(tfcardPath);

        //创建具体的操作芯片的Binder
        if (chipBinder == null) {
            chipBinder = createJniApiBinder(context, tfcardPath);
        }
        return chipBinder;
    }

    private synchronized TFJniApiBinder createJniApiBinder(Context context, String tfcardPath) {
        // 保证一个tfcardPath下只有一个binder
        if (pathBinderMap.containsKey(tfcardPath)) {
            return pathBinderMap.get(tfcardPath);
        }
        TFJniApiBinder binder = new TFJniApiBinder(context, tfcardPath);
        pathBinderMap.put(tfcardPath, binder);
        return binder;
    }

    void handleMediaRemoved(Context context) {
        JarMultiChipStatusManager.getInstance().sendCardStatus(context, "", JniApiParam.TYPE_TF, -1);
        //如果接收到设备移除广播
        //确定那个卡被移除，然后广播通知；信息列表
        if (tfInfoBundleList.size() > 0) {
            //如果有缓存可用tf信息
            //重新获取当前可用的tf信息，然后更新缓存
            List<Bundle> currentTFCardInfo = getCurrentTFCardInfo(context);
            //如果当前有缓存信息，则更新缓存，新增可用的，删除当前不可用的
            updateTFInfoInCache(currentTFCardInfo);
            sendTFInfoChangeBroadcast(context, ACTION_TF_REMOVED, tfInfoBundleList);
            Log.w(tag, "exitProcess: ");
            //      add 2018年4月20日19:49:48 weizg
            //在mate10（sp053C700）版本后，tf卡拔出时，芯片管家进程不会重启，
            // 可能会导致再次调用时接口返回错误；故，监听到tf卡拔出后，把进程杀死
            exitProcess();
        }
    }

    private void exitProcess() {
        ProcessExitsReceiver.processExits(context);
    }

    void handleMediaMounted(Context context) {
        //重新获取当前可用TF卡信息
        List<Bundle> currentTFCardInfo = getCurrentTFCardInfo(context);

        //如果遍历到TF卡信息
        if (!currentTFCardInfo.isEmpty()) {
            //检查出新增的TF卡信息
            if (tfInfoBundleList.isEmpty()) {
                //如果当前尚未缓存任何信息
                tfInfoBundleList.addAll(currentTFCardInfo);
                //发送当前可用设备信息广播
                sendTFInfoChangeBroadcast(context, ACTION_TF_MOUNTED, tfInfoBundleList);
            } else {
                //如果当前有缓存信息，则更新缓存，新增可用的，删除当前不可用的
                updateTFInfoInCache(currentTFCardInfo);
                sendTFInfoChangeBroadcast(context, ACTION_TF_MOUNTED, tfInfoBundleList);
            }
        } else {
            //如果未遍历到可用，清空本地缓存，然后发送当前无可用card通知
            tfInfoBundleList.clear();
            sendTFInfoChangeBroadcast(context, ACTION_TF_MOUNTED, new ArrayList<Bundle>(0));
        }
    }

    private void sendTFInfoChangeBroadcast(Context context, String action, ArrayList<Bundle> bundles) {
        Intent tfAddBroadcastIntent = new Intent();
        tfAddBroadcastIntent.setAction(action);
        tfAddBroadcastIntent.putParcelableArrayListExtra(TAG_CURRRENT_TF, bundles);
        context.sendBroadcast(tfAddBroadcastIntent);
    }

    private void updateTFInfoInCache(List<Bundle> currentTFCardInfo) {
        HashMap<String, Bundle> currentInfoMap = new HashMap<>();
        for (Bundle bundle : currentTFCardInfo) {
            JniApiParam chipParam = bundle.getParcelable(ParamKeywords.KEY_Parcelable_JniApiParam);
            if (chipParam != null) {
                currentInfoMap.put(chipParam.cardId, bundle);
            }
        }

        //如果缓存的TF卡信息没有在最新查询到的列表中，则移除
        int cacheListSize = tfInfoBundleList.size();
        for (int i = cacheListSize - 1; i >= 0; i--) {

            Bundle bundle = tfInfoBundleList.get(i);

            //add 2018年7月27日11:15:57 weizg
            //新增判断，如果发现为null，则移除
            if (bundle == null) {
                tfInfoBundleList.remove(i);
                continue;
            }

            JniApiParam chipParam = bundle.getParcelable(ParamKeywords.KEY_Parcelable_JniApiParam);
            if (chipParam == null) {
                tfInfoBundleList.remove(i);
                continue;
            }
            //如果没有在最新查找的列表中，则移除
            if (currentInfoMap.get(chipParam.cardId) == null) {
                tfInfoBundleList.remove(i);
            }
        }

        //新查询到的列表中，是否有当前缓存中没有包含的，如果有，则添加
        HashMap<String, Bundle> tfInfoInCacheMap = new HashMap<>();
        for (Bundle bundle : tfInfoBundleList) {
            JniApiParam chipParam = bundle.getParcelable(ParamKeywords.KEY_Parcelable_JniApiParam);
            if (chipParam != null) {
                tfInfoInCacheMap.put(chipParam.cardId, bundle);
            }
        }

        for (Bundle bundle : currentTFCardInfo) {
            JniApiParam chipParam = bundle.getParcelable(ParamKeywords.KEY_Parcelable_JniApiParam);
            //如果当前tf卡信息没有在缓存list中
            if (chipParam != null && tfInfoInCacheMap.get(chipParam.cardId) == null) {
                tfInfoBundleList.add(bundle);
            }
        }
    }


    @Override
    protected ArrayList<Bundle> getRunResult() {
        //检查获取当前设备上所有外置TF卡的路径列表
        //根据列表信息获取对应的卡信息
        ArrayList<Bundle> bundleList = new ArrayList<>();

        // add by zhangxiaolong 2022-5-17
        // 在这里加入的目的是 防止已经配置了 进程不可用，但进程启动了，又调到这里，导致触发寻找芯片
        if (!MultiJniApiConfig.getInstance(context).judgeChipCanUse(TFChipForCall.NAME_PROCESS_TF)) {
            return bundleList;
        }

        List<String> allExternalSdCardPath = TFCardUtils.getSuspicionSDCardPath(context);
        boolean findTfFlag = false;
        if (allExternalSdCardPath.size() > 0) {
            for (String sdcardPath : allExternalSdCardPath) {
                Log.i(tag, "sdcardPath: " + sdcardPath);

                TFJniApiBinder tfJniApiBinder = handleJniApiBinder(context, sdcardPath);
                JniApiParam chipParam = tfJniApiBinder.getJniApiParam();

                //modify 2017年7月10日14:25:42 weizg
                //新增判断TF卡是否已经获取到；原因是，在魅族手机上，发现一个TF卡会遍历到三个路径，导致获取到三个TF信息
                //如果打开卡成功
                if (chipParam != null && !isChipGetted(bundleList, chipParam)) {
                    findTfFlag = true;
                    JarMultiChipStatusManager.getInstance().sendCardStatus(context, chipParam.cardId, chipParam.chipType, JarMultiChipStatusManager.CARD_STATUS_EXIST);
                    Bundle bundle = new Bundle();

                    bundle.putBinder(ParamKeywords.KEY_Binder_Binder, tfJniApiBinder.asBinder());
                    bundle.putParcelable(ParamKeywords.KEY_Parcelable_JniApiParam, chipParam);
                    Log.w(tag, "bundleList.add");

                    bundleList.add(bundle);

                    //add 2017年7月18日15:06:54 weizg 外置TF在手机会有多个挂载路径，如果全部遍历打开的话，可能
                    //接口时间过长，引起界面卡顿，考虑到现在设备一般只有一个TF卡，故如果成功打开过一个则不再继续
                    break;
                }
            }
        }
        if (!findTfFlag) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(context, "", JniApiParam.TYPE_TF, JarMultiChipStatusManager.CARD_STATUS_NOT_EXIST);
        }

        //update 2018年5月10日17:56:19 weizg
        tfInfoBundleList.clear();
        tfInfoBundleList.addAll(bundleList);

        return bundleList;
    }
}

